"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterTableValueColumnMemo = void 0;
exports.FilterTableValueColumn = FilterTableValueColumn;
/* eslint-disable react/no-unused-prop-types */
const react_1 = __importDefault(require("react"));
const xtrem_shared_1 = require("@sage/xtrem-shared");
const select_1 = require("carbon-react/esm/components/select");
const lodash_1 = require("lodash");
const filter_table_utils_1 = require("./filter-table-utils");
const i18n_provider_1 = __importDefault(require("carbon-react/esm/components/i18n-provider"));
const date_range_1 = __importDefault(require("carbon-react/esm/components/date-range"));
const textbox_1 = __importDefault(require("carbon-react/esm/components/textbox"));
const text_value_input_1 = require("../shared-table-column/text-value-input");
const date_value_input_1 = require("../shared-table-column/date-value-input");
const enum_value_input_1 = require("../shared-table-column/enum-value-input");
const boolean_value_input_1 = require("../shared-table-column/boolean-value-input");
const parameter_value_input_1 = require("../shared-table-column/parameter-value-input");
const utils_1 = require("../utils");
const parameter_range_value_input_1 = require("../shared-table-column/parameter-range-value-input");
function DynamicTimeFrameFilterValueInput({ isDisabled, localize, onCellChange, rowData, }) {
    return (react_1.default.createElement(select_1.FilterableSelect, { disabled: isDisabled, openOnFocus: true, "data-testid": `e-widget-editor-filter-value-timeframe-${rowData._id}`, onChange: ({ target: { value } }) => {
            onCellChange({
                columnId: 'filterValue',
                rowId: rowData._id,
                value: value,
                rowData,
            });
        }, size: "small", value: rowData.filterValue ?? '' },
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/current-month', 'Current month'), value: "same-month", key: "same-month" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/current-year', 'Current year'), value: "same-year", key: "same-year" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/previous-month', 'Previous month'), value: "previous-month", key: "previous-month" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/previous-year', 'Previous year'), value: "previous-year", key: "previous-year" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/last-seven-days', 'Last 7 days'), value: "last-7-days", key: "last-7-days" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/last-thirty-days', 'Last 30 days'), value: "last-30-days", key: "last-30-days" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/previous-day', 'Previous day'), value: "previous-day", key: "previous-day" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/current-day', 'Current day'), value: "same-day", key: "same-day" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/previous-week', 'Previous week'), value: "previous-week", key: "previous-week" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/current-week', 'Current week'), value: "same-week", key: "same-week" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/next-day', 'Next day'), value: "next-day", key: "next-day" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/next-week', 'Next week'), value: "next-week", key: "next-week" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/next-month', 'Next month'), value: "next-month", key: "next-month" }),
        react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/next-year', 'Next year'), value: "next-year", key: "next-year" })));
}
function DateRangeFilterValueInput({ carbonLocale, errors, isDisabled, locale, onCellChange, rowData, }) {
    return (react_1.default.createElement("div", { className: "e-widget-editor-flat-table-date" },
        react_1.default.createElement(i18n_provider_1.default, { locale: carbonLocale(locale || 'en-US') },
            react_1.default.createElement(date_range_1.default, { startDateProps: {
                    disabled: isDisabled || !rowData.property || !rowData.filterType,
                }, endDateProps: {
                    disabled: isDisabled || !rowData.property || !rowData.filterType,
                }, tooltipPosition: "top", startError: errors[rowData._id]?.filterValue?.split(xtrem_shared_1.RANGE_DIVIDER)?.[0], endError: errors[rowData._id]?.filterValue?.split(xtrem_shared_1.RANGE_DIVIDER)?.[1], value: (rowData.filterValue ?? [{}, {}]).map((v) => v?.formattedValue || v?.rawValue || ''), onChange: ({ target: { value: values } }) => {
                    onCellChange({
                        columnId: 'filterValue',
                        rowId: rowData._id,
                        value: values,
                        rowData,
                    });
                } }))));
}
function NumberRangeFilterValueInput({ errors, isDisabled, localize, onCellChange, rowData, }) {
    return (react_1.default.createElement(filter_table_utils_1.SplitBox, { display: "flex", alignItems: "center", justifyContent: "center", gap: 1 },
        react_1.default.createElement(textbox_1.default, { error: errors[rowData._id]?.filterValue?.split(xtrem_shared_1.RANGE_DIVIDER)?.[0], tooltipPosition: "top", disabled: isDisabled || !rowData.property || !rowData.filterType, "data-testid": `e-widget-editor-filter-value-min-${rowData._id}`, onChange: ({ target: { value } }) => {
                onCellChange({
                    columnId: 'filterValue',
                    rowId: rowData._id,
                    value: [value, rowData.filterValue?.split(xtrem_shared_1.RANGE_DIVIDER)[1] ?? ''].join(xtrem_shared_1.RANGE_DIVIDER),
                    rowData,
                });
            }, placeholder: localize('@sage/xtrem-ui-components/select-filter-value-min', 'Minimum value'), size: "small", value: rowData.filterValue?.split(xtrem_shared_1.RANGE_DIVIDER)[0] ?? '' }),
        react_1.default.createElement(textbox_1.default, { error: errors[rowData._id]?.filterValue?.split(xtrem_shared_1.RANGE_DIVIDER)?.[1], tooltipPosition: "top", disabled: isDisabled || !rowData.property || !rowData.filterType, "data-testid": `e-widget-editor-filter-value-max-${rowData._id}`, onChange: ({ target: { value } }) => {
                onCellChange({
                    columnId: 'filterValue',
                    rowId: rowData._id,
                    value: [rowData.filterValue?.split(xtrem_shared_1.RANGE_DIVIDER)[0] ?? '', value].join(xtrem_shared_1.RANGE_DIVIDER),
                    rowData,
                });
            }, placeholder: localize('@sage/xtrem-ui-components/select-filter-value-max', 'Maximum value'), size: "small", value: rowData.filterValue?.split(xtrem_shared_1.RANGE_DIVIDER)[1] ?? '' })));
}
function FilterTableValueColumn(props) {
    const isDisabled = props.isDisabled || !props.rowData.property || !props.rowData.filterType;
    const { rowData } = props;
    // When the user enables the parameter value for the current row, we render a selection instead
    if (rowData.parameter) {
        /**
         * If the mode is `creation` a new parameter is created automatically when the user uses parameter for the field
         * and it is automatically set and cannot be changed by the user.
         *  */
        if (props.parameterMode === 'creation') {
            return null;
        }
        /**
         * In `usage` mode the user chooses from a predefined list of parameters which is supplied by the consuming component.
         */
        if (rowData.filterType === 'inRange') {
            return react_1.default.createElement(parameter_range_value_input_1.ParameterRangeValueInput, { ...props, columnId: "filterValue" });
        }
        return react_1.default.createElement(parameter_value_input_1.ParameterValueInput, { ...props, columnId: "filterValue", isDisabled: isDisabled });
    }
    if (rowData.filterType === 'empty' || rowData.filterType === 'notEmpty') {
        return null;
    }
    // date & date-time
    if (rowData.property?.data?.type &&
        (0, lodash_1.includes)([xtrem_shared_1.GraphQLTypes.Date, xtrem_shared_1.GraphQLTypes.DateTime], rowData.property.data.type)) {
        if (rowData.filterType === 'timeFrame') {
            return react_1.default.createElement(DynamicTimeFrameFilterValueInput, { ...props, isDisabled: isDisabled });
        }
        if (rowData.filterType === 'inRange') {
            return react_1.default.createElement(DateRangeFilterValueInput, { ...props, isDisabled: isDisabled });
        }
        return react_1.default.createElement(date_value_input_1.DateValueInput, { ...props, columnId: "filterValue", isDisabled: isDisabled });
    }
    // numeric ranges
    if (rowData.filterType === 'inRange' &&
        rowData.property?.data?.type &&
        (0, lodash_1.includes)([xtrem_shared_1.GraphQLTypes.Decimal, xtrem_shared_1.GraphQLTypes.Float, xtrem_shared_1.GraphQLTypes.Int, xtrem_shared_1.GraphQLTypes.IntReference], rowData.property.data.type)) {
        return react_1.default.createElement(NumberRangeFilterValueInput, { ...props, isDisabled: isDisabled });
    }
    if (rowData.property?.data?.type === xtrem_shared_1.GraphQLTypes.Boolean) {
        // We can't use the common is disabled here because we need the filter type is not selectable for boolean values
        return (react_1.default.createElement(boolean_value_input_1.BooleanValueInput, { ...props, columnId: "filterValue", isDisabled: props.isDisabled || !props.rowData.property }));
    }
    // enums
    if ((rowData.property?.data?.type === xtrem_shared_1.GraphQLTypes.Enum ||
        (rowData.property?.data.kind &&
            (0, lodash_1.includes)(utils_1.filterableGraphqlTypes.map(type => type.toLowerCase()), rowData.property?.data.kind.toLowerCase()))) &&
        rowData.property?.data.node &&
        rowData.property?.data.enumValues) {
        const enumType = rowData.property.data.node;
        const enumOptions = rowData.property.data.enumValues;
        return (react_1.default.createElement(enum_value_input_1.EnumValueInput, { ...props, columnId: "filterValue", isDisabled: isDisabled, enumOptions: enumOptions, enumType: enumType }));
    }
    return react_1.default.createElement(text_value_input_1.TextValueInput, { ...props, columnId: "filterValue", isDisabled: isDisabled });
}
exports.FilterTableValueColumnMemo = react_1.default.memo(FilterTableValueColumn);
exports.FilterTableValueColumnMemo.displayName = 'FilterTableValueColumnMemo';
//# sourceMappingURL=filter-table-value-column.js.map