"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterTableTypeColumnMemo = void 0;
exports.FilterTableTypeColumn = FilterTableTypeColumn;
const react_1 = __importDefault(require("react"));
const filter_table_types_1 = require("./filter-table-types");
const xtrem_shared_1 = require("@sage/xtrem-shared");
const select_1 = require("carbon-react/esm/components/select");
const box_1 = __importDefault(require("carbon-react/esm/components/box"));
const typography_1 = __importDefault(require("carbon-react/esm/components/typography"));
const isDateOrDateTimeProperty = (property) => property?.data?.type === xtrem_shared_1.GraphQLTypes.Date || property?.data?.type === xtrem_shared_1.GraphQLTypes.DateTime;
function FilterTableTypeColumn({ isDisabled, localize, onCellChange, rowData, }) {
    const type = rowData.property?.data?.type;
    const kind = rowData.property?.data?.kind;
    let filterableValue;
    if (type !== undefined && xtrem_shared_1.filterGraphqlMapping[type] !== undefined) {
        filterableValue = [...xtrem_shared_1.filterGraphqlMapping[type]];
    }
    else if (kind !== undefined) {
        const foundKey = Object.keys(xtrem_shared_1.filterGraphqlMapping).find(key => key.toLowerCase() === kind.toLowerCase());
        if (foundKey !== undefined) {
            filterableValue = [...(xtrem_shared_1.filterGraphqlMapping[foundKey] ?? [])];
        }
    }
    if (rowData.property?.data?.type && rowData.property.data.type === xtrem_shared_1.GraphQLTypes.Boolean) {
        return (react_1.default.createElement("div", { "data-testid": `e-widget-editor-filter-type-${rowData._id}` },
            react_1.default.createElement(box_1.default, { display: "flex", alignItems: "center", justifyContent: "flex-start" },
                react_1.default.createElement(typography_1.default, { variant: "p", m: 0, paddingLeft: "8px" }, localize('@sage/xtrem-ui-components/equals', 'Equals')))));
    }
    const renderOptions = (filterableValue, localize, property) => {
        return (filterableValue &&
            filterableValue
                ?.map((filterType) => {
                return (react_1.default.createElement(select_1.Option, { text: (0, filter_table_types_1.filterTranslations)(localize)[filterType] ?? '', value: filterType ?? '', key: filterType ?? '' }));
            })
                .concat(isDateOrDateTimeProperty(property)
                ? [react_1.default.createElement(select_1.Option, { text: (0, filter_table_types_1.filterTranslations)(localize).timeFrame, value: "timeFrame", key: "timeframe" })]
                : []));
    };
    return (react_1.default.createElement(select_1.FilterableSelect, { disabled: !rowData.property || isDisabled, openOnFocus: true, "data-testid": `e-widget-editor-filter-type-${rowData._id}`, onChange: ({ target: { value } }) => {
            onCellChange({
                columnId: 'filterType',
                rowId: rowData._id,
                value: value,
                rowData,
            });
        }, placeholder: localize('@sage/xtrem-ui-components/select-filter-type', 'Select filter type...'), size: "small", value: rowData.filterType ?? '' }, renderOptions(filterableValue, localize, rowData.property)));
}
exports.FilterTableTypeColumnMemo = react_1.default.memo(FilterTableTypeColumn);
exports.FilterTableTypeColumnMemo.displayName = 'FilterTableTypeColumn';
//# sourceMappingURL=filter-table-type-column.js.map