import React from 'react';
import { type DefaultFilterCols, type OnCellChange } from './filter-table-types';
import type { ColDef, FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { LocalizeFunction } from '@sage/xtrem-shared';
export interface FilterTableTypeColumnProps<Cols extends ColDef[] = [], E = unknown> {
    isDisabled?: boolean;
    localize: LocalizeFunction;
    onCellChange: OnCellChange<Cols, E>;
    rowData: FlatTableProps<UnrestrictedTableCols<DefaultFilterCols, Cols>, E>['data'][number];
}
export declare function FilterTableTypeColumn<Cols extends ColDef[] = [], E = unknown>({ isDisabled, localize, onCellChange, rowData, }: FilterTableTypeColumnProps<Cols, E>): React.ReactElement;
export declare const FilterTableTypeColumnMemo: React.MemoExoticComponent<typeof FilterTableTypeColumn>;
//# sourceMappingURL=filter-table-type-column.d.ts.map