"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterTablePropertyColumn = FilterTablePropertyColumn;
const react_1 = __importDefault(require("react"));
const property_table_header_1 = require("../property-template-header/property-table-header");
const select_1 = require("carbon-react/esm/components/select");
const filter_table_utils_1 = require("./filter-table-utils");
const button_1 = __importDefault(require("carbon-react/esm/components/button"));
function FilterTablePropertyColumn({ filterableProperties, isDisabled, isParentColumnHidden, localize, node, nodeNames, onCellChange, rowData, propertyAction, propertyActionLabel, }) {
    return (react_1.default.createElement(select_1.FilterableSelect, { listActionButton: propertyAction && (react_1.default.createElement(button_1.default, { iconType: "add", iconPosition: "after" }, propertyActionLabel ?? localize('@sage/xtrem-ui-components/add-property', 'Add property'))), onListAction: () => {
            if (propertyAction) {
                propertyAction();
            }
        }, multiColumn: true, tableHeader: react_1.default.createElement(property_table_header_1.PropertyTableHeader, { localize: localize, isParentColumnHidden: isParentColumnHidden }), openOnFocus: true, disabled: isDisabled, "data-testid": `e-widget-editor-filter-property-${rowData._id}`, 
        // @ts-expect-error "onChange" is actually triggered with { target: { value: Property } }
        onChange: ({ target: { value } }) => {
            onCellChange({ columnId: 'property', rowId: rowData._id, value, rowData });
        }, placeholder: localize('@sage/xtrem-ui-components/select-property', 'Select property...'), size: "small", 
        // @ts-expect-error value is of type Property
        value: rowData.property ?? {} }, filterableProperties.map(p => {
        return (
        // @ts-expect-error value is of type Property
        react_1.default.createElement(select_1.OptionRow, { text: p.label, value: p, key: p.id },
            react_1.default.createElement("td", { width: isParentColumnHidden ? '100%' : '50%', style: {
                    overflow: 'hidden',
                    whiteSpace: 'pre-line',
                    maxWidth: 0,
                } }, p.label),
            !isParentColumnHidden && (react_1.default.createElement("td", { width: "50%", style: {
                    overflow: 'hidden',
                    whiteSpace: 'pre-line',
                    maxWidth: 0,
                    textAlign: 'end',
                } }, (0, filter_table_utils_1.getPropertyParentNode)({ nodeNames, labelPath: p.labelPath, node })))));
    })));
}
//# sourceMappingURL=filter-table-property-column.js.map