"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterTablePod = FilterTablePod;
const react_1 = __importDefault(require("react"));
const box_1 = __importDefault(require("carbon-react/esm/components/box"));
const typography_1 = __importDefault(require("carbon-react/esm/components/typography"));
const button_1 = __importDefault(require("carbon-react/esm/components/button"));
const button_minor_1 = __importDefault(require("carbon-react/esm/components/button-minor"));
const lodash_1 = require("lodash");
function NoFilter({ emptyStateText, isAddButtonHidden, onPodAdded, addButtonText, }) {
    return (react_1.default.createElement(box_1.default, { paddingY: 80, gap: 1, display: "flex", flexDirection: "column", alignItems: "center", justifyContent: "center" },
        react_1.default.createElement("div", { className: "e-flat-table-placeholder" },
            react_1.default.createElement(typography_1.default, { color: "--colorsUtilityMajor100", lineHeight: "30px", variant: "h3" }, emptyStateText)),
        !isAddButtonHidden && (react_1.default.createElement(button_minor_1.default, { mt: 2, iconType: "add", onClick: onPodAdded, "data-testid": "add-item-button" }, addButtonText))));
}
function FilterTablePod({ data, extraData, columns, emptyStateText, localize, onPodAdded = lodash_1.noop, onPodRemoved = lodash_1.noop, isAddButtonHidden, addButtonText = 'Add condition', }) {
    const propertyColumn = columns.find(column => column.id === 'property');
    const filterType = columns.find(column => column.id === 'filterType');
    const parameter = columns.find(column => column.id === 'parameter');
    const filterValue = columns.find(column => column.id === 'filterValue');
    // if some of the properties above are undefined return null
    if (!propertyColumn || !filterType || !filterValue) {
        return null;
    }
    return (react_1.default.createElement("div", { "data-testid": "e-filter-pod-container", className: "e-filter-pod-container" }, data.length === 0 ? (react_1.default.createElement(NoFilter, { emptyStateText: emptyStateText, isAddButtonHidden: isAddButtonHidden, onPodAdded: onPodAdded, addButtonText: addButtonText })) : (react_1.default.createElement(react_1.default.Fragment, null,
        data.map((rowData, index) => {
            const propertyElement = propertyColumn.cellRenderer?.({
                rowData,
                rowIndex: index,
                data,
                extraData,
            });
            const filterElement = filterType.cellRenderer?.({
                rowData,
                rowIndex: index,
                data,
                extraData,
            });
            const parameterElement = parameter?.cellRenderer?.({
                rowData,
                rowIndex: index,
                data,
                extraData,
                filterTypeMode: 'dropdown',
            });
            const filterValueElement = filterValue.cellRenderer?.({
                rowData,
                rowIndex: index,
                data,
                extraData,
            });
            return (react_1.default.createElement("div", { key: rowData._id, "data-testid": `e-filter-pod-row-${rowData._id}`, className: "e-filter-pod-row" },
                react_1.default.createElement("div", { className: "e-filter-pod-condition-label", "data-testid": `e-filter-pod-condition-label-${rowData._id}` },
                    react_1.default.createElement(typography_1.default, { marginBottom: 0, fontWeight: "500" }, `${localize('@sage/xtrem-ui-components/pod-condition', 'Condition')} ${index + 1}`)),
                react_1.default.createElement("div", { className: "e-filter-pod-property", "data-testid": `e-filter-pod-property-${rowData._id}` }, propertyElement),
                react_1.default.createElement("div", { className: "e-filter-pod-filter-parameter-container", "data-testid": `e-filter-pod-filter-parameter-container-${rowData._id}` },
                    react_1.default.createElement("div", { className: "e-filter-pod-filter-type", "data-testid": `e-filter-pod-filter-type-${rowData._id}` }, filterElement),
                    parameter && (react_1.default.createElement("div", { "data-testid": `e-filter-pod-parameter-${rowData._id}`, className: "e-filter-pod-parameter" }, parameterElement))),
                react_1.default.createElement("div", { className: "e-filter-pod-filter-value", "data-testid": `e-filter-pod-filter-value-${rowData._id}` }, filterValueElement),
                react_1.default.createElement("div", { className: "e-filter-pod-remove", "data-testid": `e-filter-pod-remove-${rowData._id}` },
                    react_1.default.createElement(button_1.default, { destructive: true, iconType: "remove", onClick: () => {
                            onPodRemoved(rowData);
                        }, "data-testid": `e-filter-table-remove-row-button-${rowData._id}` }, localize('@sage/xtrem-ui-components/filter-pod-remove-condition', 'Remove condition')))));
        }),
        !isAddButtonHidden && (react_1.default.createElement("div", { className: "e-filter-pod-add" },
            react_1.default.createElement(button_1.default, { mt: 2, iconType: "add", onClick: onPodAdded, "data-testid": "e-filter-table-add-row-button" }, localize('@sage/xtrem-ui-components/filter-pod-add-condition', 'Add condition'))))))));
}
//# sourceMappingURL=filter-table-pod.js.map