"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FilterTableParameterColumnMemo = void 0;
exports.FilterTableParameterColumn = FilterTableParameterColumn;
const react_1 = __importDefault(require("react"));
const switch_1 = __importDefault(require("carbon-react/esm/components/switch"));
const select_1 = require("carbon-react/esm/components/select");
function FilterTableParameterColumn({ isDisabled, onCellChange, mode, rowData, localize, }) {
    if (mode === 'dropdown') {
        return (react_1.default.createElement("div", { className: "e-filter-table-parameter-dropdown" },
            react_1.default.createElement(select_1.Select, { "data-testid": `e-widget-editor-filter-parameter-${rowData._id}`, size: "small", name: "parameter", disabled: isDisabled, onChange: (e) => {
                    onCellChange({
                        columnId: 'parameter',
                        rowData,
                        rowId: rowData._id,
                        value: e.target.value === 'parameter',
                    });
                    // reset filter value
                    onCellChange({
                        columnId: 'filterValue',
                        rowData,
                        rowId: rowData._id,
                        value: undefined,
                    });
                }, value: rowData.parameter ? 'parameter' : 'filterValue' },
                react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/filter-table-option-enter-manually', 'Enter manually'), value: "filterValue" }),
                react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/filter-table-option-select-parameter', 'Select a parameter'), value: "parameter" }))));
    }
    return (react_1.default.createElement("div", { className: "e-filter-table-parameter-switch" },
        react_1.default.createElement(switch_1.default, { "data-testid": `e-widget-editor-filter-parameter-${rowData._id}`, size: "small", name: "parameter", disabled: isDisabled, onChange: (e) => {
                onCellChange({
                    columnId: 'parameter',
                    rowData,
                    rowId: rowData._id,
                    value: e.target.checked,
                });
                // reset filter value
                onCellChange({
                    columnId: 'filterValue',
                    rowData,
                    rowId: rowData._id,
                    value: undefined,
                });
            }, checked: rowData.parameter || false })));
}
exports.FilterTableParameterColumnMemo = react_1.default.memo(FilterTableParameterColumn);
exports.FilterTableParameterColumnMemo.displayName = 'FilterTableParameterColumnMemo';
//# sourceMappingURL=filter-table-parameter-column.js.map