"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useContentTable = useContentTable;
exports.ContentTableComponent = ContentTableComponent;
const xtrem_shared_1 = require("@sage/xtrem-shared");
const textbox_1 = __importDefault(require("carbon-react/esm/components/textbox"));
const lodash_1 = require("lodash");
const React = __importStar(require("react"));
const flat_table_1 = require("../flat-table/flat-table");
const content_table_presentation_column_1 = require("./content-table-presentation-column");
const content_table_property_column_1 = require("./content-table-property-column");
const content_table_utils_1 = require("./content-table-utils");
const use_previous_1 = require("../hooks/use-previous");
const hooks_1 = require("../hooks");
const content_table_title_column_1 = require("./content-table-title-column");
function useContentTable({ value, contentType, isDisabled, localize, node, nodeNames, onChange, selectedProperties, isPropertySelectionDisabled, }) {
    const previousValue = (0, use_previous_1.usePrevious)(value);
    const onCellChange = React.useCallback(changes => {
        dispatch({ type: 'CELL_CHANGED', changes, selectedProperties: selectedProperties ?? {} });
    }, [selectedProperties]);
    const addButtonText = React.useMemo(() => localize('@sage/xtrem-ui-components/add-column', 'Add column'), [localize]);
    const onRowDrag = React.useCallback(ids => {
        dispatch({ type: 'ROW_DRAGGED', ids });
    }, []);
    const onRowAdded = React.useCallback(dataOverride => {
        dispatch({ type: 'ROW_ADDED', data: dataOverride });
    }, []);
    const onRowRemoved = React.useCallback((row) => {
        dispatch({ type: 'ROW_REMOVED', row });
    }, []);
    const valueToDataMapper = React.useCallback(({ presentation, formatting, labelPath, title, divisor, path, property, ...rest }, index) => {
        return {
            // spread needed in case columns are extended
            ...rest,
            _id: String(index + 1),
            property: selectedProperties?.[path],
            presentation,
            formatting: (0, lodash_1.isNil)(formatting) ? undefined : String(formatting),
            type: property?.data?.type,
            path,
            labelPath,
            title,
            divisor: (0, lodash_1.isNil)(divisor) ? undefined : String(divisor),
        };
    }, [selectedProperties]);
    const columns = React.useMemo(() => [
        {
            id: 'property',
            header: { name: localize('@sage/xtrem-ui-components/property', 'Property'), width: 250 },
            cellRenderer: ({ rowData, data: allData }) => (React.createElement(content_table_property_column_1.ContentTablePropertyColumn, { allData: allData, isDisabled: isDisabled, isPropertySelectionDisabled: isPropertySelectionDisabled, localize: localize, node: node, nodeNames: nodeNames, onCellChange: onCellChange, rowData: rowData, selectedProperties: selectedProperties })),
        },
        {
            id: 'title',
            header: { name: localize('@sage/xtrem-ui-components/title', 'Title'), width: 150 },
            cellRenderer: ({ rowData, extraData }) => {
                const errors = extraData;
                return (React.createElement(content_table_title_column_1.ContentTableTitleColumn, { rowData: rowData, errors: errors, onCellChange: onCellChange, localize: localize, value: rowData.title }));
            },
        },
        {
            id: 'presentation',
            header: { name: localize('@sage/xtrem-ui-components/presentation', 'Presentation'), width: 180 },
            cellRenderer: ({ rowData }) => {
                return (React.createElement(content_table_presentation_column_1.ContentTablePresentationColumn, { isDisabled: isDisabled, localize: localize, onCellChange: onCellChange, rowData: rowData, contentType: contentType }));
            },
        },
        {
            id: 'formatting',
            header: { name: localize('@sage/xtrem-ui-components/decimal-digits', 'Decimal places'), width: 130 },
            cellRenderer: ({ rowData, extraData }) => {
                if (rowData.property?.data?.type && !(0, lodash_1.includes)(xtrem_shared_1.numericFields, rowData.property.data.type)) {
                    return null;
                }
                const errors = extraData;
                return (React.createElement(textbox_1.default, { error: errors[rowData._id]?.formatting, inputMode: "numeric", tooltipPosition: "top", "data-testid": `e-widget-editor-content-formatting-${rowData._id}`, onChange: ({ target: { value: formattingValue } }) => {
                        onCellChange({
                            columnId: 'formatting',
                            rowId: rowData._id,
                            value: formattingValue,
                            rowData,
                        });
                    }, placeholder: localize('@sage/xtrem-ui-components/widget-editor-content-formatting', 'Decimal digits'), size: "small", value: rowData.formatting ?? '' }));
            },
        },
        {
            id: 'divisor',
            header: { name: localize('@sage/xtrem-ui-components/divisor', 'Divisor'), width: 130 },
            cellRenderer: ({ rowData, extraData }) => {
                if (rowData.property?.data?.type && !(0, lodash_1.includes)(xtrem_shared_1.numericFields, rowData.property.data.type)) {
                    return null;
                }
                const errors = extraData;
                return (React.createElement(textbox_1.default, { error: errors[rowData._id]?.divisor, inputMode: "numeric", tooltipPosition: "top", "data-testid": `e-widget-editor-content-divisor-${rowData._id}`, onChange: ({ target: { value: divisorValue } }) => {
                        onCellChange({
                            columnId: 'divisor',
                            rowId: rowData._id,
                            value: divisorValue,
                            rowData,
                        });
                    }, placeholder: localize('@sage/xtrem-ui-components/divisor', 'Divisor'), size: "small", value: rowData.divisor ?? '' }));
            },
        },
        { id: 'path', isHidden: true, header: { name: 'Path' } },
        { id: 'labelPath', isHidden: true, header: { name: 'Label path' } },
    ], [
        contentType,
        isDisabled,
        isPropertySelectionDisabled,
        localize,
        node,
        nodeNames,
        onCellChange,
        selectedProperties,
    ]);
    const [tableDefinition, dispatch] = React.useReducer((0, content_table_utils_1.tableWidgetReducer)()(localize), {
        addButtonText,
        canDrag: true,
        onRowDrag,
        onRowRemoved,
        onRowAdded,
        columns,
        data: value.map(valueToDataMapper),
        counter: (value ?? []).length,
        validations: {},
    });
    const currentIds = (0, hooks_1.useDeepCompareMemo)(() => tableDefinition.data.map(d => d._id), [tableDefinition.data]);
    const setOrderedIds = React.useCallback(({ newOrderedIds, id, enforceContiguous }) => {
        if (!(0, lodash_1.isEqual)(currentIds, newOrderedIds)) {
            dispatch({ type: 'ORDER_CHANGED', orderedIds: newOrderedIds, id, enforceContiguous });
        }
    }, [currentIds]);
    const canAddNewLines = React.useMemo(() => {
        return Boolean(!(0, lodash_1.isEmpty)(selectedProperties) &&
            tableDefinition.data.length < 100 &&
            tableDefinition.data.length < Object.keys(selectedProperties).length);
    }, [tableDefinition.data.length, selectedProperties]);
    (0, hooks_1.useDeepCompareEffect)(() => {
        dispatch({ type: 'COLUMNS_CHANGED', columns });
    }, [selectedProperties, dispatch]);
    React.useEffect(() => {
        if (!(0, lodash_1.isEqual)(previousValue, value) &&
            !(0, lodash_1.isEqual)(value.map(v => (0, lodash_1.omit)(v, ['_id'])), tableDefinition.data.map(d => (0, lodash_1.omit)(d, ['_id'])))) {
            dispatch({
                type: 'DATA_RESET',
                data: value.map((v, idx) => ({ ...v, _id: String(idx + 1) })),
            });
            return;
        }
        if ((0, lodash_1.isEqual)(value, tableDefinition.data)) {
            return;
        }
        onChange(tableDefinition.data
            .filter(row => (0, content_table_utils_1.isContentRowValid)({ row, validations: tableDefinition.validations }))
            .map(({ presentation, property, title, formatting, divisor, path, labelPath, ...rest }) => {
            const result = {
                // spread needed in case columns are extended
                ...rest,
                presentation: presentation,
                title: title,
                labelPath: labelPath,
                formatting,
                divisor,
                property,
                path,
            };
            return result;
        }));
    }, [tableDefinition.data, tableDefinition.validations, onChange, previousValue, value]);
    const setData = React.useCallback((data) => {
        dispatch({ type: 'DATA_RESET', data });
    }, []);
    const hook = React.useMemo(() => ({
        ...tableDefinition,
        canAddNewLines,
        onCellChange,
        setOrderedIds,
        setData,
    }), [canAddNewLines, onCellChange, tableDefinition, setOrderedIds, setData]);
    return hook;
}
function ContentTableComponent(props) {
    const { addButtonText, canAddNewLines, canDrag, columns, data, onRowAdded, onRowDrag, onRowRemoved, validations } = useContentTable(props);
    return (React.createElement(flat_table_1.FlatTable, { addButtonText: addButtonText, canAddNewLines: !props.isDisabled && canAddNewLines, canDrag: canDrag, columns: columns, data: data, onRowAdded: onRowAdded, onRowDrag: onRowDrag, onRowRemoved: onRowRemoved, extraData: validations }));
}
//# sourceMappingURL=content-table.js.map