import * as React from 'react';
import type { Dict, LocalizeFunction } from '@sage/xtrem-shared';
import type { ToastProps } from 'carbon-react/esm/components/toast';
import type { FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { AdditionalContentColumns, ContentTableProps, DefaultContentTableCols, TreeElementWithGroups } from './content-table-types';
export interface TableContentWithGroupsProps<P extends TreeElementWithGroups = TreeElementWithGroups, E = unknown> {
    isAddButtonHidden?: boolean;
    isDisabled?: boolean;
    isLastElementRemovable?: boolean;
    isPropertySelectionDisabled?: boolean;
    localize: LocalizeFunction;
    onChange: ContentTableProps<AdditionalContentColumns, P, E>['onChange'];
    selectedItems?: Dict<P>;
    value: Omit<FlatTableProps<UnrestrictedTableCols<DefaultContentTableCols, AdditionalContentColumns, false>, E>['data'][number], '_id'>[];
    onDisplayNotification?: (content: string, type: ToastProps['variant']) => void;
    setGroupOrderError?: (value: boolean) => void;
}
export declare function TableContentWithGroups<P extends TreeElementWithGroups = TreeElementWithGroups, E = unknown>({ selectedItems, onChange, localize, value, isDisabled, isAddButtonHidden, isPropertySelectionDisabled, isLastElementRemovable, onDisplayNotification, setGroupOrderError, }: TableContentWithGroupsProps<P, E>): React.ReactElement;
//# sourceMappingURL=content-table-with-groups.d.ts.map