import type { GraphQLTypes, KeysOfValue, LocalizeFunction } from '@sage/xtrem-shared';
import { FieldKey } from '@sage/xtrem-shared';
import type { ColDef, FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { DefaultPropertyType } from '../types';
import type { ContentAction, ContentTableValidations, DefaultContentTableCols, GroupOrderValidationResult, WidgetContentState } from './content-table-types';
export declare const presentationTranslations: ((localize: LocalizeFunction) => Record<FieldKey, string>) & import("lodash").MemoizedFunction;
export declare const getMainPresentation: (({ localize, type }: {
    localize: LocalizeFunction;
    type: GraphQLTypes;
}) => string) & import("lodash").MemoizedFunction;
export declare function tableWidgetReducer<Cols extends ColDef[] = [], P extends DefaultPropertyType = DefaultPropertyType, E = unknown>(): (localize: LocalizeFunction) => (state: WidgetContentState<Cols, E>, action: ContentAction<Cols, P, E>) => WidgetContentState<Cols, E>;
export declare function enforceContiguousOrder<R extends {
    _id: string;
}, K extends KeysOfValue<R, number>>({ orderedData, key, }: {
    orderedData: R[];
    key: K;
}): R[];
export declare function areAllPropertiesNonSortable<Cols extends ColDef[] = [], E = unknown>(data: FlatTableProps<UnrestrictedTableCols<DefaultContentTableCols, Cols>, E>['data']): boolean;
export declare function checkValidGroupOrder<Cols extends ColDef[] = [], E = unknown>({ data, enforceContiguous, }: {
    data: FlatTableProps<UnrestrictedTableCols<DefaultContentTableCols, Cols>, E>['data'];
    enforceContiguous?: any;
}): GroupOrderValidationResult;
export declare function isContentRowValid({ row, validations, }: {
    row: FlatTableProps<UnrestrictedTableCols<DefaultContentTableCols>>['data'][number];
    validations: ContentTableValidations;
}): boolean;
//# sourceMappingURL=content-table-utils.d.ts.map