"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentTableTitleColumn = ContentTableTitleColumn;
const react_1 = __importDefault(require("react"));
const textbox_1 = __importDefault(require("carbon-react/esm/components/textbox"));
function ContentTableTitleColumn({ rowData, errors, onCellChange, localize, value: propValue, }) {
    const [titleValue, setTitleValue] = react_1.default.useState(propValue);
    react_1.default.useEffect(() => {
        setTitleValue(propValue);
    }, [propValue]);
    const onChange = react_1.default.useCallback(({ target: { value } }) => {
        setTitleValue(value);
    }, []);
    const onBlur = react_1.default.useCallback(() => {
        if (titleValue === propValue) {
            return;
        }
        onCellChange({
            columnId: 'title',
            rowId: rowData._id,
            value: titleValue,
            rowData,
        });
    }, [titleValue, propValue, onCellChange, rowData]);
    return (react_1.default.createElement(textbox_1.default, { error: errors[rowData._id]?.title, disabled: !rowData.property, inputMode: "text", tooltipPosition: "top", "data-testid": `e-widget-editor-content-title-${rowData._id}`, onChange: onChange, onBlur: onBlur, placeholder: localize('@sage/xtrem-ui-components/title', 'Title'), size: "small", value: titleValue ?? '' }));
}
//# sourceMappingURL=content-table-title-column.js.map