"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentTablePropertyColumn = ContentTablePropertyColumn;
const react_1 = __importDefault(require("react"));
const property_table_header_1 = require("../property-template-header/property-table-header");
const filter_table_utils_1 = require("../filter-table/filter-table-utils");
const select_1 = require("carbon-react/esm/components/select");
const use_deep_compare_memo_1 = require("../hooks/use-deep-compare-memo");
function ContentTablePropertyColumn({ allData, isDisabled, isPropertySelectionDisabled, localize, node, nodeNames, onCellChange, rowData, selectedProperties, ...rest }) {
    const options = (0, use_deep_compare_memo_1.useDeepCompareMemo)(() => Object.values(selectedProperties ?? {}).map(s => {
        const { id, label, labelPath, path, data } = s;
        return { id: id ?? path, label, labelPath, path, data };
    }), [selectedProperties]);
    const value = (0, use_deep_compare_memo_1.useDeepCompareMemo)(() => {
        const { id, label, labelPath, path, data } = rowData.property ?? {};
        return { id: id ?? path, label, labelPath, path, data };
    }, [rowData.property]);
    const onKeyDown = react_1.default.useCallback(e => {
        if (isPropertySelectionDisabled && e.key !== 'Tab') {
            e.preventDefault();
        }
    }, [isPropertySelectionDisabled]);
    return (react_1.default.createElement(select_1.FilterableSelect, { disabled: isDisabled, multiColumn: true, tableHeader: react_1.default.createElement(property_table_header_1.PropertyTableHeader, { localize: localize }), openOnFocus: true, "data-testid": `e-widget-editor-content-property-${rowData._id}`, 
        // @ts-expect-error "onChange" is actually triggered with { target: { value: Property } }
        onChange: ({ target: { value } }) => {
            onCellChange({ columnId: 'property', rowId: rowData._id, value, rowData });
        }, onKeyDown: onKeyDown, placeholder: localize('@sage/xtrem-ui-components/select-property', 'Select property...'), size: "small", value: value, ...rest }, options
        .filter(p => !allData
        .filter(item => item.property && item._id !== rowData._id)
        .map(item => item.path)
        .includes(p.id) && p.data.type)
        .map(p => {
        return (react_1.default.createElement(select_1.OptionRow, { text: p.label, value: p, key: p.id ?? p.path },
            react_1.default.createElement("td", { width: "50%", style: {
                    overflow: 'hidden',
                    whiteSpace: 'pre-line',
                    maxWidth: 0,
                } }, p.label),
            react_1.default.createElement("td", { width: "50%", style: {
                    overflow: 'hidden',
                    whiteSpace: 'pre-line',
                    maxWidth: 0,
                    textAlign: 'end',
                } }, (0, filter_table_utils_1.getPropertyParentNode)({ nodeNames, labelPath: p.labelPath, node }))));
    })));
}
//# sourceMappingURL=content-table-property-column.js.map