"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentTableGroupColumn = ContentTableGroupColumn;
const xtrem_shared_1 = require("@sage/xtrem-shared");
const select_1 = require("carbon-react/esm/components/select");
const lodash_1 = require("lodash");
const react_1 = __importDefault(require("react"));
const hooks_1 = require("../hooks");
const content_table_utils_1 = require("./content-table-utils");
function ContentTableGroupColumn({ data, rowIndex, rowData, onCellChange, localize, setOrderedIds, setGroupOrderValidation, setGroupOrderError, displayGroupErrorMessage, }) {
    const onGroupChange = (0, hooks_1.useDeepCompareMemo)(() => ({ target: { value: groupValue } }) => {
        const newValue = Number(groupValue);
        const { success, data: orderedData } = (0, xtrem_shared_1.arrayMovePreservingOrder)({
            data,
            fromIndex: rowIndex,
            toValue: newValue,
            orderByKey: 'group',
        });
        if (success) {
            onCellChange({
                columnId: 'group',
                rowId: rowData._id,
                value: newValue,
                rowData: { ...rowData, group: newValue },
            });
            setOrderedIds({
                newOrderedIds: orderedData.map(d => d.path),
                id: 'path',
                enforceContiguous: 'group',
            });
            setGroupOrderValidation({ isValid: true });
            if (setGroupOrderError) {
                setGroupOrderError(false);
            }
        }
        else {
            displayGroupErrorMessage();
        }
    }, [data, rowIndex, rowData]);
    const options = (0, hooks_1.useDeepCompareMemo)(() => (0, lodash_1.range)(0, ((0, lodash_1.max)(data.map(d => d.group)) ?? 0) + 2), [data]);
    const value = react_1.default.useMemo(() => ((0, lodash_1.isNil)(rowData.group) ? '0' : String(rowData.group)), [rowData.group]);
    if ((0, content_table_utils_1.areAllPropertiesNonSortable)(data)) {
        return null;
    }
    return (react_1.default.createElement(select_1.FilterableSelect, { openOnFocus: true, "data-testid": `e-widget-editor-content-group-${rowData._id}`, onChange: onGroupChange, placeholder: localize('@sage/xtrem-ui-components/select-value-placeholder', 'Select value...'), size: "small", value: value }, options.map(option => {
        const text = localize('@sage/xtrem-ui-components/group-number', 'Group {{groupNumber}}', {
            groupNumber: option + 1,
        });
        return (react_1.default.createElement(select_1.Option, { key: option, text: text, value: String(option) }, text));
    })));
}
//# sourceMappingURL=content-table-group-column.js.map