import type { LocalizeFunction } from '@sage/xtrem-shared';
import React from 'react';
import type { FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { AdditionalContentColumns, DefaultContentTableCols, GroupOrderValidationResult, UnrestrictedOnCellChange, UseContentTableHook } from './content-table-types';
import type { TableContentWithGroupsProps } from './content-table-with-groups';
export interface ContentTableGroupColumnProp {
    localize: LocalizeFunction;
    onCellChange: UnrestrictedOnCellChange<AdditionalContentColumns, any>;
    data: FlatTableProps<UnrestrictedTableCols<DefaultContentTableCols, AdditionalContentColumns, false>>['data'];
    rowData: FlatTableProps<UnrestrictedTableCols<DefaultContentTableCols, AdditionalContentColumns, false>>['data'][number];
    rowIndex: number;
    setOrderedIds: UseContentTableHook<AdditionalContentColumns>['setOrderedIds'];
    setGroupOrderValidation: React.Dispatch<React.SetStateAction<GroupOrderValidationResult>>;
    setGroupOrderError: TableContentWithGroupsProps['setGroupOrderError'];
    displayGroupErrorMessage: () => void;
}
export declare function ContentTableGroupColumn({ data, rowIndex, rowData, onCellChange, localize, setOrderedIds, setGroupOrderValidation, setGroupOrderError, displayGroupErrorMessage, }: ContentTableGroupColumnProp): React.ReactNode;
//# sourceMappingURL=content-table-group-column.d.ts.map