"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValueColumn = ValueColumn;
const React = __importStar(require("react"));
const xtrem_shared_1 = require("@sage/xtrem-shared");
const lodash_1 = require("lodash");
const parameter_value_input_1 = require("../shared-table-column/parameter-value-input");
const date_value_input_1 = require("../shared-table-column/date-value-input");
const boolean_value_input_1 = require("../shared-table-column/boolean-value-input");
const enum_value_input_1 = require("../shared-table-column/enum-value-input");
const text_value_input_1 = require("../shared-table-column/text-value-input");
const property_column_1 = require("./property-column");
const utils_1 = require("../utils");
const SUPPORTED_PARAMETER_TYPES = [
    xtrem_shared_1.GraphQLTypes.Int,
    xtrem_shared_1.GraphQLTypes.Float,
    xtrem_shared_1.GraphQLTypes.Decimal,
    xtrem_shared_1.GraphQLTypes.Boolean,
    xtrem_shared_1.GraphQLTypes.String,
    xtrem_shared_1.GraphQLTypes.Date,
];
function ValueColumn({ localize, onCellChange, rowData, locale, carbonLocale, localizeEnumMember, errors, fetchItems, node, parameters, typeRestriction, valueType, columnId, enumOptions: enumValues, enumType, ...rest }) {
    const isDisabled = rest.isDisabled || !valueType || !valueType;
    const filteredFetchItems = React.useCallback(async (element) => {
        const items = await fetchItems(element);
        if (!typeRestriction) {
            return items;
        }
        // Numeric values can be compared against each other, regardless their actual type, so here we normalize all numeric types to Int
        const normalizedExpectedType = utils_1.NUMERIC_TYPES.includes(typeRestriction) ? xtrem_shared_1.GraphQLTypes.Int : typeRestriction;
        return items.filter(i => {
            const normalizedCurrentType = utils_1.NUMERIC_TYPES.includes(i.type) ? xtrem_shared_1.GraphQLTypes.Int : i.type;
            return normalizedCurrentType === normalizedExpectedType || i.kind === 'OBJECT';
        });
    }, [fetchItems, typeRestriction]);
    const filteredParameters = React.useMemo(() => {
        if (!parameters) {
            return [];
        }
        if (!typeRestriction) {
            return parameters.filter(p => SUPPORTED_PARAMETER_TYPES.includes(p.type));
        }
        const normalizedExpectedType = utils_1.NUMERIC_TYPES.includes(typeRestriction) ? xtrem_shared_1.GraphQLTypes.Int : typeRestriction;
        return parameters.filter(p => {
            const normalizedCurrentType = utils_1.NUMERIC_TYPES.includes(p.type) ? xtrem_shared_1.GraphQLTypes.Int : p.type;
            return normalizedCurrentType === normalizedExpectedType;
        });
    }, [parameters, typeRestriction]);
    if (valueType === 'property') {
        return (React.createElement(property_column_1.PropertyColumn, { localize: localize, isDisabled: isDisabled, onCellChange: onCellChange, rowData: rowData, columnId: columnId, fetchItems: filteredFetchItems, node: node, "data-testid": `e-condition-table-${columnId}-${rowData._id}` }));
    }
    // When the user enables the parameter value for the current row, we render a selection instead
    if (valueType === 'parameter') {
        return (React.createElement(parameter_value_input_1.ParameterValueInput, { localize: localize, isDisabled: isDisabled, onCellChange: onCellChange, rowData: rowData, errors: errors, columnId: columnId, parameters: filteredParameters, noParameterFiltering: true, "data-testid": `e-condition-table-${columnId}` }));
    }
    // date & date-time
    if (valueType === 'constant' &&
        typeRestriction &&
        (0, lodash_1.includes)([xtrem_shared_1.GraphQLTypes.Date, xtrem_shared_1.GraphQLTypes.DateTime], typeRestriction)) {
        return (React.createElement(date_value_input_1.DateValueInput, { isDisabled: isDisabled, onCellChange: onCellChange, rowData: rowData, locale: locale, carbonLocale: carbonLocale, errors: errors, columnId: columnId, "data-testid": `e-condition-table-${columnId}` }));
    }
    if (valueType === 'constant' && typeRestriction === xtrem_shared_1.GraphQLTypes.Boolean) {
        return (React.createElement(boolean_value_input_1.BooleanValueInput, { isDisabled: isDisabled, onCellChange: onCellChange, rowData: rowData, localize: localize, columnId: columnId, "data-testid": `e-condition-table-${columnId}` }));
    }
    // enums
    if (valueType === 'constant' && enumValues && enumType) {
        return (React.createElement(enum_value_input_1.EnumValueInput, { isDisabled: isDisabled, onCellChange: onCellChange, rowData: rowData, localize: localize, localizeEnumMember: localizeEnumMember, columnId: columnId, enumOptions: enumValues, enumType: enumType, "data-testid": `e-condition-table-${columnId}` }));
    }
    return (React.createElement(text_value_input_1.TextValueInput, { isDisabled: isDisabled, onCellChange: onCellChange, rowData: rowData, localize: localize, errors: errors, columnId: columnId, "data-testid": `e-condition-table-${columnId}` }));
}
//# sourceMappingURL=value-column.js.map