import * as React from 'react';
import type { DefaultConditionEditorCols, FilterParameter, OnCellChange, ValueType } from './condition-editor-table-types';
import type { ColDef, FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { LocalizeFunction, LocalizeLocale, NodeDetails } from '@sage/xtrem-shared';
import type { CarbonLocaleType } from '../types';
export interface OperatorColumnProps<Cols extends ColDef[] = [], E = unknown> {
    localize: LocalizeFunction;
    onCellChange: OnCellChange<Cols, E>;
    rowData: FlatTableProps<UnrestrictedTableCols<DefaultConditionEditorCols, Cols>, E>['data'][number];
    fetchItems: (element: NodeDetails) => Promise<NodeDetails[]>;
    carbonLocale: CarbonLocaleType;
    isDisabled?: boolean;
    locale: LocalizeLocale;
    localizeEnumMember: (enumFullPathName: string, memberName: string) => string;
    errors?: Record<string, any>;
    node?: string;
    parameters?: FilterParameter[];
    typeRestriction?: NodeDetails['type'];
    valueType?: ValueType;
    columnId: 'value1' | 'value2';
    enumOptions?: string[];
    enumType?: string;
}
export declare function ValueColumn<Cols extends ColDef[] = [], E = unknown>({ localize, onCellChange, rowData, locale, carbonLocale, localizeEnumMember, errors, fetchItems, node, parameters, typeRestriction, valueType, columnId, enumOptions: enumValues, enumType, ...rest }: OperatorColumnProps<Cols, E>): React.ReactElement;
//# sourceMappingURL=value-column.d.ts.map