"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PropertyColumn = PropertyColumn;
const react_1 = __importDefault(require("react"));
const tree_input_1 = require("../tree-input/tree-input");
function PropertyColumn({ 'data-testid': dataTestId, columnId = 'value1', fetchItems, isDisabled, localize, node, onCellChange, rowData, }) {
    const onChange = react_1.default.useCallback((value) => {
        onCellChange({
            columnId,
            rowData,
            rowId: rowData._id,
            value: value || undefined,
        });
    }, [columnId, onCellChange, rowData]);
    return (react_1.default.createElement(tree_input_1.TreeInput, { canSelectObjects: false, "data-testid": dataTestId, fetchItems: fetchItems, isDisabled: isDisabled, localize: localize, node: node, onChange: onChange, value: rowData[columnId] ?? null }));
}
//# sourceMappingURL=property-column.js.map