"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConjunctionColumn = ConjunctionColumn;
const react_1 = __importDefault(require("react"));
const select_1 = require("carbon-react/esm/components/select");
const lodash_1 = require("lodash");
function ConjunctionColumn({ isDisabled, onCellChange, rowData, localize, rowIndex, }) {
    return (react_1.default.createElement("div", { className: "e-condition-table-conjunction-column" },
        rowIndex === 0 && (react_1.default.createElement(select_1.Select, { disabled: true, openOnFocus: true, "data-testid": `e-condition-table-conjunction-column-${rowData._id}`, size: "small", value: "if", onChange: lodash_1.noop },
            react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/condition-conjunction-if', 'If'), value: "if", key: "if" }))),
        rowIndex !== 0 && (react_1.default.createElement(select_1.Select, { disabled: isDisabled, openOnFocus: true, "data-testid": `e-condition-table-conjunction-column-${rowData._id}`, onChange: ({ target: { value } }) => {
                onCellChange({
                    columnId: 'conjunction',
                    rowId: rowData._id,
                    value: value,
                    rowData,
                });
            }, size: "small", value: rowData.conjunction ?? '' },
            react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/condition-conjunction-and', 'And'), value: "and", key: "and" }),
            react_1.default.createElement(select_1.Option, { text: localize('@sage/xtrem-ui-components/condition-conjunction-or', 'Or'), value: "or", key: "or" })))));
}
//# sourceMappingURL=conjunction-column.js.map