"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.useConditionEditorTable = useConditionEditorTable;
exports.ConditionEditorTableComponent = ConditionEditorTableComponent;
const lodash_1 = require("lodash");
const react_1 = __importDefault(require("react"));
const flat_table_1 = require("../flat-table/flat-table");
const use_previous_1 = require("../hooks/use-previous");
const condition_editor_table_utils_1 = require("./condition-editor-table-utils");
const conjunction_column_1 = require("./conjunction-column");
const operator_column_1 = require("./operator-column");
const value_column_1 = require("./value-column");
const value_type_column_1 = require("./value-type-column");
const utils_1 = require("../utils");
function useConditionEditorTable({ carbonLocale, isDisabled, localize, localizeEnumMember, node, onChange, onValidityChange, parameters = [], value = [], fetchItems, locale, }) {
    const previousValue = (0, use_previous_1.usePrevious)(value);
    const onCellChange = react_1.default.useCallback(changes => {
        dispatch({ type: 'CELL_CHANGED', changes });
    }, []);
    const onRowAdded = react_1.default.useCallback(() => {
        dispatch({ type: 'ROW_ADDED' });
    }, []);
    const onRowRemoved = react_1.default.useCallback((row) => {
        dispatch({ type: 'ROW_REMOVED', row });
    }, []);
    const columns = react_1.default.useMemo(() => {
        return [
            {
                id: 'conjunction',
                header: {
                    name: localize('@sage/xtrem-ui-components/condition-editor', 'Conjunction'),
                    width: 120,
                },
                cellRenderer: ({ rowData, rowIndex }) => (react_1.default.createElement(conjunction_column_1.ConjunctionColumn, { isDisabled: isDisabled, localize: localize, onCellChange: onCellChange, rowData: rowData, rowIndex: rowIndex })),
            },
            {
                id: 'valueType1',
                header: {
                    name: localize('@sage/xtrem-ui-components/condition-value-type-1', 'Value Type 1'),
                    width: 150,
                },
                cellRenderer: ({ rowData }) => (react_1.default.createElement(value_type_column_1.ValueTypeColumn, { isDisabled: isDisabled, localize: localize, onCellChange: onCellChange, rowData: rowData, columnId: "valueType1", parameters: parameters })),
            },
            {
                id: 'value1',
                header: {
                    name: localize('@sage/xtrem-ui-components/condition-table-value-1', 'Value 1'),
                },
                cellRenderer: ({ rowData, extraData }) => (react_1.default.createElement(value_column_1.ValueColumn, { errors: extraData[0], isDisabled: isDisabled, localize: localize, onCellChange: onCellChange, rowData: rowData, carbonLocale: carbonLocale, fetchItems: fetchItems, locale: locale, localizeEnumMember: localizeEnumMember, node: extraData[1], parameters: parameters, columnId: "value1", valueType: rowData.valueType1 })),
            },
            {
                id: 'operator',
                header: {
                    name: localize('@sage/xtrem-ui-components/operator', 'Operator'),
                    width: undefined,
                },
                cellRenderer: ({ rowData }) => (react_1.default.createElement(operator_column_1.OperatorColumn, { isDisabled: isDisabled, localize: localize, onCellChange: onCellChange, rowData: rowData, parameters: parameters })),
            },
            {
                id: 'valueType2',
                header: {
                    name: localize('@sage/xtrem-ui-components/condition-value-type-2', 'Value Type 2'),
                    width: 150,
                },
                cellRenderer: ({ rowData }) => {
                    if (rowData.operator === 'empty' || rowData.operator === 'notEmpty') {
                        return null;
                    }
                    return (react_1.default.createElement(value_type_column_1.ValueTypeColumn, { isDisabled: isDisabled || !rowData.valueType1 || !rowData.value1, localize: localize, onCellChange: onCellChange, rowData: rowData, columnId: "valueType2", parameters: parameters }));
                },
            },
            {
                id: 'value2',
                header: {
                    name: localize('@sage/xtrem-ui-components/condition-table-value-2', 'Value 2'),
                },
                cellRenderer: ({ rowData, extraData: [validations, node] }) => {
                    if (rowData.operator === 'empty' || rowData.operator === 'notEmpty') {
                        return null;
                    }
                    const isParameter = rowData.valueType1 === 'parameter';
                    const isEnum = !isParameter && (0, utils_1.isEnumField)(rowData.value1?.data);
                    // If the value is a parameter, the type is the type of the parameter
                    const type = isParameter
                        ? parameters?.find(p => p.name === rowData.value1)?.type
                        : rowData.value1?.data?.type;
                    return (react_1.default.createElement(value_column_1.ValueColumn, { errors: validations, isDisabled: isDisabled || !type || !rowData.valueType2, localize: localize, onCellChange: onCellChange, rowData: rowData, carbonLocale: carbonLocale, fetchItems: fetchItems, locale: locale, localizeEnumMember: localizeEnumMember, node: node, parameters: parameters, columnId: "value2", valueType: rowData.valueType2, typeRestriction: type, enumType: isEnum ? rowData.value1?.data?.type : undefined, enumOptions: isEnum ? rowData.value1?.data?.enumValues : undefined }));
                },
            },
            { id: 'key', isHidden: true, header: { name: 'Key' } },
        ];
    }, [carbonLocale, fetchItems, isDisabled, locale, localize, localizeEnumMember, onCellChange, parameters]);
    const onRowDrag = react_1.default.useCallback(ids => {
        dispatch({ type: 'ROW_DRAGGED', ids });
    }, []);
    const addButtonText = react_1.default.useMemo(() => localize('@sage/xtrem-ui-components/add-condition', 'Add condition'), [localize]);
    const data = react_1.default.useMemo(() => {
        return (0, condition_editor_table_utils_1.mapConditionToEditorRow)({ value });
    }, [value]);
    const [tableDefinition, dispatch] = react_1.default.useReducer((0, condition_editor_table_utils_1.conditionEditorTableReducer)()(localize, parameters), {
        addButtonText,
        canDrag: true,
        columns,
        counter: value.length,
        data,
        onRowAdded,
        onRowDrag,
        onRowRemoved,
        validations: {},
    });
    react_1.default.useEffect(() => {
        const completeRows = tableDefinition.data.filter(row => (0, condition_editor_table_utils_1.isCompleteRow)(row, tableDefinition.validations));
        onChange(completeRows.map(({ conjunction, value1, value2, valueType1, valueType2, key, operator, _id, ...rest }) => {
            return {
                // spread needed in case columns are extended
                ...rest,
                conjunction: conjunction,
                valueType1,
                valueType2,
                _id,
                value1,
                value2,
                key,
                operator,
            };
        }));
        onValidityChange?.(completeRows.length === tableDefinition.data.length);
        // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [tableDefinition.data, tableDefinition.validations, onValidityChange]);
    react_1.default.useEffect(() => {
        const newValue = (0, condition_editor_table_utils_1.mapConditionToEditorRow)({ value });
        if (!(0, lodash_1.isEqual)(previousValue, value) && !(0, lodash_1.isEqual)(newValue, tableDefinition.data)) {
            dispatch({ type: 'DATA_RESET', value });
        }
    }, [value, tableDefinition.data, previousValue]);
    return {
        ...tableDefinition,
        extraData: [tableDefinition.validations, node],
        canRemoveLines: true,
        emptyStateText: localize('@sage/xtrem-ui-components/condition-empty-state', 'Click the add button to start editing the conditions'),
        actionsText: localize('@sage/xtrem-ui-components/actions', 'Actions'),
        isAddButtonHidden: false,
        onCellChange,
    };
}
function ConditionEditorTableComponent(props) {
    const { actionsText, addButtonText, canDrag, canRemoveLines, columns, data, emptyStateText, extraData, isAddButtonHidden, onRowAdded, onRowDrag, onRowRemoved, } = useConditionEditorTable(props);
    const memoizedExtraData = react_1.default.useMemo(() => {
        return [extraData?.[0], extraData?.[1] || props.node];
    }, [extraData, props.node]);
    return (react_1.default.createElement(flat_table_1.FlatTable, { actionsText: actionsText, addButtonText: addButtonText, canAddNewLines: !props.isDisabled, canDrag: canDrag, canRemoveLines: canRemoveLines, columns: columns, data: data, emptyStateText: emptyStateText, extraData: memoizedExtraData, isAddButtonHidden: isAddButtonHidden, maxLines: 10, onRowAdded: onRowAdded, onRowDrag: onRowDrag, onRowRemoved: onRowRemoved }));
}
//# sourceMappingURL=condition-editor-table.js.map