import type { LocalizeFunction } from '@sage/xtrem-shared';
import type { ColDef, FlatTableProps, UnrestrictedTableCols } from '../flat-table/flat-table-types';
import type { ConditionEditorTableProps, ConditionEditorTableState, ConditionEditorTableValidations, ConditionTableEditorAction, DefaultConditionEditorCols, FilterParameter } from './condition-editor-table-types';
export declare const SplitBox: import("styled-components").StyledComponent<import("react").ForwardRefExoticComponent<import("carbon-react/esm/components/box").BoxProps & import("react").RefAttributes<HTMLDivElement>>, any, {}, never>;
export declare const isCompleteRow: <Cols extends ColDef[] = [], E = unknown>(row: FlatTableProps<UnrestrictedTableCols<DefaultConditionEditorCols, Cols>, E>["data"][number], validations: ConditionEditorTableValidations<Cols>) => boolean;
export declare const mapConditionToEditorRow: (<Cols extends ColDef[] = []>({ value, }: {
    value: NonNullable<ConditionEditorTableProps["value"]>;
}) => FlatTableProps<UnrestrictedTableCols<DefaultConditionEditorCols, Cols>>["data"]) & import("lodash").MemoizedFunction;
export declare function conditionEditorTableReducer<Cols extends ColDef[] = [], E = unknown>(): (localize: LocalizeFunction, parameters?: FilterParameter[]) => (state: ConditionEditorTableState<Cols, E>, action: ConditionTableEditorAction<Cols, E>) => ConditionEditorTableState<Cols, E>;
//# sourceMappingURL=condition-editor-table-utils.d.ts.map