"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const crypto = require("node:crypto");
const SECRET_CONFIG_PREFIX = " @secret/";
class LocalWrapper {
    async getTenantEncryptionKey(tenantId) {
        return crypto.createHash("sha256").update(tenantId).digest("base64");
    }
    async readConfigValue(configValue) {
        if (configValue.startsWith(SECRET_CONFIG_PREFIX)) {
            console.log(`Warning: You are trying to read a secret ${configValue} using a local implementation of the secret library.`);
        }
        return configValue;
    }
}
exports.default = LocalWrapper;
;
