"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretHandler = void 0;
exports.getSecretHandler = getSecretHandler;
exports.recreateSecretHandler = recreateSecretHandler;
const SecretHandler_1 = require("./SecretHandler");
exports.SecretHandler = SecretHandler_1.default;
const xtrem_deployment_1 = require("@sage/xtrem-deployment");
let secretHandlerInstance;
/**
 * Return a secret handler instance or a cached version
 * Warning, if you call it with different config, use "recreateSecretHandler" instead
 * @param config
 * @param secretsManagerMock
 */
function getSecretHandler(config, secretsManagerMock) {
    const internalConfig = config instanceof xtrem_deployment_1.XtremDeploymentConfig ? config.getSecretConfig() : config;
    if (!secretHandlerInstance) {
        secretHandlerInstance = new SecretHandler_1.default(internalConfig, secretsManagerMock);
    }
    return secretHandlerInstance;
}
/**
 * Replaces the secrethandler singleton instance we have in cache by a new one
 * Can be use if you need a differnt config than the one currently in place
 * @param config
 * @param secretsManagerMock
 */
function recreateSecretHandler(config, secretsManagerMock) {
    const internalConfig = config instanceof xtrem_deployment_1.XtremDeploymentConfig ? config.getSecretConfig() : config;
    secretHandlerInstance = new SecretHandler_1.default(internalConfig, secretsManagerMock);
    return secretHandlerInstance;
}
