import SecretHandler, { SecretConfig } from "./SecretHandler";
import { XtremDeploymentConfig } from "@sage/xtrem-deployment";
/**
 * Return a secret handler instance or a cached version
 * Warning, if you call it with different config, use "recreateSecretHandler" instead
 * @param config
 * @param secretsManagerMock
 */
declare function getSecretHandler(config?: SecretConfig | XtremDeploymentConfig, secretsManagerMock?: any): SecretHandler;
/**
 * Replaces the secrethandler singleton instance we have in cache by a new one
 * Can be use if you need a differnt config than the one currently in place
 * @param config
 * @param secretsManagerMock
 */
declare function recreateSecretHandler(config?: SecretConfig | XtremDeploymentConfig, secretsManagerMock?: any): SecretHandler;
export { getSecretHandler, recreateSecretHandler, SecretHandler, SecretConfig };
