import { SecretWrapperInterface } from "./secretWrapperInterface";
export interface SecretConfig {
    xtremEnv?: string;
    clusterId?: string;
    secretCacheTimeoutInMinutes?: number;
}
export default class SecretHandler {
    secretWrapper: SecretWrapperInterface;
    isLocal: boolean;
    constructor(config?: SecretConfig, secretsManagerMock?: any);
    private static checkParametersForNullOrBlank;
    getTenantEncryptionKey(tenantId: string): Promise<string>;
    /***
     * parse configuration value and retrive the aws secret if starting by @secret/ or pass back the original
     * value if not
     * @param configValue
     */
    getConfigSecretValue(configValue: string): Promise<string>;
}
