import { SecretsManager } from "@aws-sdk/client-secrets-manager";
import { SecretConfig } from "./SecretHandler";
import { SecretWrapperInterface } from "./secretWrapperInterface";
export default class AWSSecretWrapper implements SecretWrapperInterface {
    SecretsManager: SecretsManager;
    xtremEnv: string;
    clusterId: string;
    secretCache: any;
    secretCacheTimeoutInMinutes: number;
    constructor(config: SecretConfig, secretsManagerMock?: any);
    getTenantEncryptionKey(tenantId: string): Promise<string>;
    /***
     * Read a configuration file value, if it's a secret it will return the secret value.
     * If it's not it will return the original config value.
     * we expect the secret configValue to have full path ex : @secret/xtreem-dev-eu/cluster-xxx/path
     * @param configValue
     */
    readConfigValue(configValue: string): Promise<string>;
    isConfigValueASecret(configValue: string): boolean | "";
    /***
     * Read a secret from cache if exists, add to cache after read if existed
     * @param secretPath
     */
    readSecret(secretPath: string): Promise<string>;
    cacheExpired(timeStamp: number): boolean;
    cacheStoreSecret(secretPath: string, secretString: string): void;
    cacheRetrieveSecret(secretPath: string): any;
    private getTenantSecretPath;
}
