/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.generateClientPackageJson=generateClientPackageJson,exports.generateClientPackageJsonFromPackage=generateClientPackageJsonFromPackage;const os_1=require("os"),path=require("path"),safeRequirePackageFile=(e,a)=>{const n=path.resolve(a,".."),r=path.resolve(n,"..");try{return require(require.resolve(`${e}/package.json`,{paths:[a,n,r]}))}catch{return null}};function generateClientPackageJson(e){const a={...e.mainPackage.packageJson.peerDependencies,...e.mainPackage.packageJson.dependencies},n=e.getPackages().filter(n=>n.name!==e.name&&a[n.name]).map(e=>({apiDepPackageName:`${e.name}-api`,version:a[e.name]})),r={name:`${e.name}-api`,description:`Client API for ${e.name}`,version:e.mainPackage.packageJson.version,author:e.mainPackage.packageJson.author,license:e.mainPackage.packageJson.license,typings:"api.d.ts",dependencies:[{apiDepPackageName:"@sage/xtrem-client",version:a["@sage/xtrem-client"]??a["@sage/xtrem-core"]},...n].sort((e,a)=>{if(e.apiDepPackageName>a.apiDepPackageName)return 1;if(e.apiDepPackageName<a.apiDepPackageName)return-1;return 0}).reduce((e,a)=>(e[a.apiDepPackageName]=a.version,e),{})};return JSON.stringify(r,null,4).replace(/\n/g,os_1.EOL)+os_1.EOL}function generateClientPackageJsonFromPackage(e){const xtremClientPackage=require("@sage/xtrem-client/package.json"),a="^",xtremPackage=require(path.resolve(e,"package.json")),n=Object.keys(xtremPackage.dependencies).map(a=>safeRequirePackageFile(a,e)).filter(e=>!!e&&true===Boolean(e.xtrem)&&e.name!==xtremPackage.name).sort((e,a)=>{if(e.name>a.name)return 1;if(e.name<a.name)return-1;return 0}).reduce((e,n)=>({...e,[`${n.name}-api`]:`${a}${n.version}`}),{}),r={name:`${xtremPackage.name}-api`,description:`Client API for ${xtremPackage.name}`,version:xtremPackage.version,author:xtremPackage.author,license:xtremPackage.license,typings:"api.d.ts",dependencies:{"@sage/xtrem-client":`${a}${xtremClientPackage.version}`,...n}};return JSON.stringify(r,null,4).replace(/\n/g,os_1.EOL)+os_1.EOL}
//# sourceMappingURL=gen-package-json.js.map