declare module '@sage/xtrem-x3-copilot-api-partial' {
    import type { Package as SageXtremAppMetadata$Package } from '@sage/xtrem-app-metadata-api';
    import type {
        Package as SageXtremX3SystemUtils$Package,
        SysPackage,
        SysUser,
    } from '@sage/xtrem-x3-system-utils-api';
    import type {
        AggregateQueryOperation,
        AggregateReadOperation,
        ClientNode,
        ClientNodeInput,
        CreateOperation,
        DeleteOperation,
        DuplicateOperation,
        GetDefaultsOperation,
        GetDuplicateOperation,
        Operation as Node$Operation,
        QueryOperation,
        ReadOperation,
        TextStream,
        UpdateByIdOperation,
        UpdateOperation,
    } from '@sage/xtrem-client';
    export interface InsightTypeType$Enum {
        main: 1;
        data: 2;
    }
    export type InsightTypeType = keyof InsightTypeType$Enum;
    export interface SysCopilot extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
    }
    export interface SysCopilotInput extends ClientNodeInput {}
    export interface SysCopilotBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
    }
    export interface SysCopilot$Queries {
        getInsightDataQueries: Node$Operation<
            {
                chatContext: string;
            },
            {
                data: string;
                queries: {
                    key: string;
                    query: TextStream;
                }[];
            }
        >;
    }
    export interface SysCopilot$Operations {
        queries: SysCopilot$Queries;
        getDefaults: GetDefaultsOperation<SysCopilot>;
    }
    export interface SysInsight extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        package: SysPackage;
        screenId: string;
        key: string;
        type: InsightTypeType;
        query: TextStream;
        hash: string;
    }
    export interface SysInsightInput extends ClientNodeInput {
        package?: string;
        screenId?: string;
        key?: string;
        type?: InsightTypeType;
        query?: TextStream;
        hash?: string;
    }
    export interface SysInsightBinding extends ClientNode {
        _updateUser: SysUser;
        _createUser: SysUser;
        package: SysPackage;
        screenId: string;
        key: string;
        type: InsightTypeType;
        query: TextStream;
        hash: string;
    }
    export interface SysInsight$Mutations {
        saveToDisk: Node$Operation<{}, boolean>;
    }
    export interface SysInsight$Lookups {
        package: QueryOperation<SysPackage>;
    }
    export interface SysInsight$Operations {
        query: QueryOperation<SysInsight>;
        read: ReadOperation<SysInsight>;
        aggregate: {
            read: AggregateReadOperation<SysInsight>;
            query: AggregateQueryOperation<SysInsight>;
        };
        create: CreateOperation<SysInsightInput, SysInsight>;
        getDuplicate: GetDuplicateOperation<SysInsight>;
        duplicate: DuplicateOperation<string, SysInsightInput, SysInsight>;
        update: UpdateOperation<SysInsightInput, SysInsight>;
        updateById: UpdateByIdOperation<SysInsightInput, SysInsight>;
        delete: DeleteOperation<{}>;
        deleteById: DeleteOperation<string>;
        mutations: SysInsight$Mutations;
        lookups(dataOrId: string | { data: SysInsightInput }): SysInsight$Lookups;
        getDefaults: GetDefaultsOperation<SysInsight>;
    }
    export interface Package {
        '@sage/xtrem-x3-copilot/SysCopilot': SysCopilot$Operations;
        '@sage/xtrem-x3-copilot/SysInsight': SysInsight$Operations;
    }
    export interface GraphApi extends Package, SageXtremAppMetadata$Package, SageXtremX3SystemUtils$Package {}
}
declare module '@sage/xtrem-x3-copilot-api' {
    export type * from '@sage/xtrem-x3-copilot-api-partial';
}
declare module '@sage/xtrem-app-metadata-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/xtrem-x3-copilot-api';
    export interface GraphApi extends GraphApiExtension {}
}
declare module '@sage/xtrem-x3-system-utils-api-partial' {
    import type { GraphApi as GraphApiExtension } from '@sage/xtrem-x3-copilot-api';
    export interface GraphApi extends GraphApiExtension {}
}
