"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// src/utils.ts
var path2 = __toESM(require("node:path"));

// src/utils/cache.ts
var crypto = __toESM(require("node:crypto"));
var fs = __toESM(require("node:fs"));
var os = __toESM(require("node:os"));
var path = __toESM(require("node:path"));
var import_node_util = require("node:util");
var debug = (0, import_node_util.debuglog)("eslint-plugin-redos");
var __mock__ = {
  nodeModuleDir: path.join(require.resolve("@sage/eslint-plugin-redos/package.json"), "../..")
};
var findDefaultCacheFile = () => {
  let cacheDir = null;
  try {
    cacheDir = path.join(__mock__.nodeModuleDir, ".cache/eslint-plugin-redos");
    fs.mkdirSync(cacheDir, { recursive: true });
  } catch {
    cacheDir = os.tmpdir();
  }
  const cacheFile = path.join(cacheDir, "recheck-cache.json");
  return cacheFile;
};
var findCacheFileFromOptions = (location) => {
  const cacheFile = path.resolve(location);
  let stat;
  try {
    stat = fs.statSync(cacheFile);
  } catch {
  }
  if (stat) {
    if (stat.isDirectory()) {
      throw new Error(`Resolved cache.location '${cacheFile}' is a directory`);
    }
  }
  return cacheFile;
};
var cacheLocationPerPackage = /* @__PURE__ */ Object.create(null);
var findCacheFile = (location, segmented) => {
  if (segmented) {
    const cwd = location ?? process.cwd();
    let cacheLocation = cacheLocationPerPackage[cwd];
    if (!cacheLocation) {
      const packageJson = path.join(cwd, "package.json");
      if (fs.existsSync(packageJson)) {
        const { version, name } = require("@sage/eslint-plugin-redos/package.json");
        const redosCacheVersionHash = crypto.createHash("sha256").update(`${name}:${version}`).digest("hex").substring(0, 40);
        const packageName = require(packageJson).name.replace("/", "-");
        const dir = path.join(os.tmpdir(), "xtrem-cache", "lint");
        fs.mkdirSync(dir, { recursive: true });
        cacheLocation = path.join(dir, `${packageName}--recheck-cache-${redosCacheVersionHash}.json`);
        cacheLocationPerPackage[cwd] = ensureValidCache(cacheLocation);
        debug(`(cache miss) version: ${version}, packageName: ${packageName}, location: ${cacheLocation}`);
      }
    }
    if (cacheLocation) {
      return cacheLocation;
    }
  }
  if (!location) {
    return findDefaultCacheFile();
  }
  return findCacheFileFromOptions(location);
};
function ensureValidCache(filePath) {
  try {
    JSON.parse(fs.readFileSync(filePath, "utf8"));
  } catch (e) {
    const error = e;
    if (error.code !== "ENOENT") {
      if (/Unexpected (token|end of JSON input)/.test(error.message)) {
        console.error(`Reset invalid cache file: ${filePath}`);
        fs.writeFileSync(filePath, "{}", "utf8");
        return filePath;
      }
      console.error(`Error reading cache file: ${filePath} [${error.message}]`);
      throw e;
    }
  }
  return filePath;
}

// src/utils.ts
module.exports = {
  getFilename(packageDir) {
    return path2.basename(findCacheFile(packageDir, true));
  }
};
