import { prepareAggregateGenericRequest } from '@sage/wh-master-data/lib/client-functions/aggregators';
import {
    AggregateGroupSelector,
    AggregateQueryOptions,
    AggregateQuerySelector,
    AggregateValuesSelector,
    ClientNode,
} from '@sage/xtrem-client';

/**
 * Generate an aggregate request for StockObject
 * @param selector
 * @param filter
 * @param numberOfRecords (optional, default 1000)
 * @returns aggregated query request
 */
export function generateAggregateStockObjectRequest<T extends ClientNode>(
    pageInstance: any,
    selector: AggregateQuerySelector<T, AggregateGroupSelector<T>, AggregateValuesSelector<T>>,
    filter: AggregateQueryOptions<T>,
    numberOfRecords = 1000,
) {
    return pageInstance.$.graph
        .node('@sage/wh-stock-data/StockObject')
        .aggregate.query(prepareAggregateGenericRequest<T>(selector, filter, numberOfRecords));
}

/**
 * Generate an aggregate request for SerialNumber
 * @param selector
 * @param filter
 * @param numberOfRecords (optional, default 1000)
 * @returns aggregated query request
 */
export function generateAggregateSerialNumberRequest<T extends ClientNode>(
    pageInstance: any,
    selector: AggregateQuerySelector<T, AggregateGroupSelector<T>, AggregateValuesSelector<T>>,
    filter: AggregateQueryOptions<T>,
    numberOfRecords = 1000,
) {
    return pageInstance.$.graph
        .node('@sage/wh-stock-data/SerialNumber')
        .aggregate.query(prepareAggregateGenericRequest<T>(selector, filter, numberOfRecords));
}
