// From file: @sage/wh-stock-data/build/index.d.ts
declare module '@sage/wh-stock-data/index' {
	export * from '@sage/wh-stock-data/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/index.d.ts
declare module '@sage/wh-stock-data/lib/index' {
	export * as enums from '@sage/wh-stock-data/lib/enums/index';
	export * as functions from '@sage/wh-stock-data/lib/functions/index';
	export * as interfaces from '@sage/wh-stock-data/lib/interfaces/index';
	export * as nodeExtensions from '@sage/wh-stock-data/lib/node-extensions/index';
	export * as nodes from '@sage/wh-stock-data/lib/nodes/index';
	export * as serviceOptions from '@sage/wh-stock-data/lib/service-options/index';
	export * as sharedFunctions from '@sage/wh-stock-data/lib/shared-functions/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/shared-functions/index.d.ts
declare module '@sage/wh-stock-data/lib/shared-functions/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/service-options/index.d.ts
declare module '@sage/wh-stock-data/lib/service-options/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/nodes/stock-object.d.ts
declare module '@sage/wh-stock-data/lib/nodes/stock-object' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, decimal, date, integer, Collection } from '@sage/xtrem-core';
	import * as sageWhStockData from '@sage/wh-stock-data/lib/index';
	export class StockObject extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly code: Promise<string>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly store: Reference<sageWhMasterData.nodes.Store>;
	    readonly location: Reference<sageWhMasterData.nodes.Location>;
	    readonly storeType: Promise<sageWhMasterData.enums.StoreType>;
	    readonly locationType: Promise<sageWhMasterData.enums.LocationType>;
	    readonly containerNumber: Promise<string>;
	    readonly lotNumber: Promise<string>;
	    readonly supportNumber: Promise<string>;
	    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly containerCoefficient: Promise<decimal>;
	    readonly numberOfConsumptionUnit: Promise<decimal>;
	    readonly numberOfContainer: Promise<decimal>;
	    readonly numberOfConsumptionUnitInPendingInput: Promise<decimal | null>;
	    readonly numberOfConsumptionUnitInPendingOutput: Promise<decimal | null>;
	    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
	    readonly reservationNumber: Promise<string>;
	    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
	    readonly stockObjectLinkNumber: Promise<string>;
	    readonly fifoDate: Promise<date | null>;
	    readonly receiptDate: Promise<date | null>;
	    readonly manufacturedDate: Promise<date | null>;
	    readonly detentionDate: Promise<date | null>;
	    readonly sellByDate: Promise<date | null>;
	    readonly useByDate: Promise<date | null>;
	    readonly shipByDate: Promise<date | null>;
	    readonly unStockingAllocationSequence: Promise<integer>;
	    readonly storingDate: Promise<date | null>;
	    readonly storingTime: Promise<integer | null>;
	    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
	    readonly homogeneousContainerCoefficient: Promise<decimal>;
	    readonly homogeneousQuantity: Promise<decimal>;
	    readonly quantityInContainerCorrespondence: Promise<decimal>;
	    readonly serialNumbers: Collection<sageWhStockData.nodes.SerialNumber>;
	    readonly containerLevels: Collection<sageWhStockData.nodes.StockObjectContainerLevels>;
	}
	//# sourceMappingURL=stock-object.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/nodes/stock-object-container-levels.d.ts
declare module '@sage/wh-stock-data/lib/nodes/stock-object-container-levels' {
	import * as sageWhProductData from '@sage/wh-product-data';
	import { Node, integer, Reference, decimal } from '@sage/xtrem-core';
	import * as sageWhStockData from '@sage/wh-stock-data/lib/index';
	export class StockObjectContainerLevels extends Node {
	    readonly denormalizedIndex: Promise<integer>;
	    readonly site: Promise<string>;
	    readonly code: Promise<string>;
	    readonly _denormalizedParent: Reference<sageWhStockData.nodes.StockObject>;
	    readonly containerLevel: Reference<sageWhProductData.nodes.ProductContainer | null>;
	    readonly quantityOfConsumptionUnitPerLevel: Promise<decimal | null>;
	}
	//# sourceMappingURL=stock-object-container-levels.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/nodes/serial-traceability.d.ts
declare module '@sage/wh-stock-data/lib/nodes/serial-traceability' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, date } from '@sage/xtrem-core';
	export class SerialTraceability extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly product: Promise<string>;
	    readonly serialNumber: Promise<string>;
	    readonly double: Promise<integer | null>;
	    readonly occurrence: Promise<integer | null>;
	    readonly code: Promise<string>;
	    readonly operationType: Promise<sageWhProductData.enums.SerialAction>;
	    readonly directInputNumber: Promise<string>;
	    readonly directInputLineNumber: Promise<integer>;
	    readonly receiptDate: Promise<date | null>;
	    readonly deliveryOrderNumber: Promise<string>;
	    readonly deliveryOrderLineNumber: Promise<integer | null>;
	    readonly outputDate: Promise<date | null>;
	    readonly inputAdjustmentNumber: Promise<string>;
	    readonly outputAdjustmentNumber: Promise<string>;
	    readonly inputMovementNumber: Promise<string>;
	    readonly outputMovementNumber: Promise<string>;
	    readonly replenishmentNumber: Promise<string>;
	    readonly transferMovementNumber: Promise<string>;
	    readonly stockObjectNumber: Promise<string>;
	    readonly originStockObject: Promise<string>;
	    readonly serialGroup: Promise<string>;
	    readonly parentGroup: Promise<string>;
	    readonly replenishmentDate: Promise<date | null>;
	    readonly free1: Promise<string>;
	    readonly free2: Promise<string>;
	    readonly free3: Promise<string>;
	    readonly free4: Promise<string>;
	    readonly free5: Promise<string>;
	}
	//# sourceMappingURL=serial-traceability.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/nodes/serial-number.d.ts
declare module '@sage/wh-stock-data/lib/nodes/serial-number' {
	import * as sageWhMasterData from '@sage/wh-master-data';
	import * as sageWhProductData from '@sage/wh-product-data';
	import * as sageWhSystem from '@sage/wh-system';
	import { Node, Reference, integer, date } from '@sage/xtrem-core';
	import * as sageWhStockData from '@sage/wh-stock-data/lib/index';
	export class SerialNumber extends Node {
	    readonly site: Reference<sageWhSystem.nodes.Site>;
	    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
	    readonly product: Reference<sageWhProductData.nodes.Product>;
	    readonly code: Promise<string>;
	    readonly double: Promise<integer | null>;
	    readonly occurrence: Promise<integer | null>;
	    readonly linePointerNumber: Promise<integer | null>;
	    readonly receiptDate: Promise<date | null>;
	    readonly deliveryOrderLineNumber: Promise<integer | null>;
	    readonly outputDate: Promise<date | null>;
	    readonly transmittedToL3: Promise<integer | null>;
	    readonly stockObject: Reference<sageWhStockData.nodes.StockObject | null>;
	    readonly serialGroup: Reference<sageWhMasterData.nodes.SerialGroup | null>;
	    readonly validatedStoringList: Promise<integer | null>;
	    readonly validatedPreparationOrder: Promise<integer | null>;
	    readonly serialParentGroup: Reference<sageWhMasterData.nodes.SerialGroup | null>;
	    readonly transferDate: Promise<date | null>;
	    readonly free1: Promise<string>;
	    readonly free2: Promise<string>;
	    readonly free3: Promise<string>;
	    readonly free4: Promise<string>;
	    readonly free5: Promise<string>;
	    readonly voided: Promise<integer | null>;
	    readonly postponed: Promise<integer | null>;
	    readonly displayCode: Promise<string>;
	    readonly keyCodeForDuplicates: Promise<string>;
	    readonly actionImport: Promise<string>;
	}
	//# sourceMappingURL=serial-number.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/nodes/index.d.ts
declare module '@sage/wh-stock-data/lib/nodes/index' {
	export * from '@sage/wh-stock-data/lib/nodes/serial-number';
	export * from '@sage/wh-stock-data/lib/nodes/serial-traceability';
	export * from '@sage/wh-stock-data/lib/nodes/stock-object-container-levels';
	export * from '@sage/wh-stock-data/lib/nodes/stock-object';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/node-extensions/product-extension.d.ts
declare module '@sage/wh-stock-data/lib/node-extensions/product-extension' {
	import * as sageWhProductData from '@sage/wh-product-data';
	import { NodeExtension, Collection } from '@sage/xtrem-core';
	import * as sageWhStockData from '@sage/wh-stock-data/lib/index';
	export class ProductExtension extends NodeExtension<sageWhProductData.nodes.Product> {
	    readonly stockObjects: Collection<sageWhStockData.nodes.StockObject>;
	}
	declare module '@sage/wh-product-data/lib/nodes/product' {
	    interface Product extends ProductExtension {
	    }
	}
	//# sourceMappingURL=product-extension.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/node-extensions/index.d.ts
declare module '@sage/wh-stock-data/lib/node-extensions/index' {
	export * from '@sage/wh-stock-data/lib/node-extensions/product-extension';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/interfaces/index.d.ts
declare module '@sage/wh-stock-data/lib/interfaces/index' {
	export * from '@sage/wh-stock-data/lib/interfaces/environnement';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/interfaces/environnement.d.ts
declare module '@sage/wh-stock-data/lib/interfaces/environnement' {
	export interface StockObjectSelected {
	    code: string;
	    _id: string;
	    details?: any;
	}
	//# sourceMappingURL=environnement.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/functions/serial-number.d.ts
declare module '@sage/wh-stock-data/lib/functions/serial-number' {
	import type * as sageWhStockData from '@sage/wh-stock-data/lib/index';
	/**
	 * Get the key code for display (SQL mutation).
	 * @param _this The serial number object.
	 * @returns The key code as a string.
	 */
	export function getDisplayCode(_this: sageWhStockData.nodes.SerialNumber): Promise<string>;
	/**
	 * Get the key code for duplicates (SQL mutation).
	 * @param _this The serial number object.
	 * @returns The key code as a string.
	 */
	export function getKeyCodeForDuplicates(_this: sageWhStockData.nodes.SerialNumber): Promise<string>;
	//# sourceMappingURL=serial-number.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/functions/index.d.ts
declare module '@sage/wh-stock-data/lib/functions/index' {
	export * from '@sage/wh-stock-data/lib/functions/serial-number';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/wh-stock-data/build/lib/enums/index.d.ts
declare module '@sage/wh-stock-data/lib/enums/index' {
	export type Dummy = void;
	//# sourceMappingURL=index.d.ts.map
}
declare module '@sage/wh-stock-data' {
	export * from '@sage/wh-stock-data/index';
}
