import * as sageWhMasterData from '@sage/wh-master-data';
import * as sageWhProductData from '@sage/wh-product-data';
import * as sageWhSystem from '@sage/wh-system';
import { Node, Reference, decimal, date, integer, Collection } from '@sage/xtrem-core';
import * as sageWhStockData from '..';
export declare class StockObject extends Node {
    readonly site: Reference<sageWhSystem.nodes.Site>;
    readonly code: Promise<string>;
    readonly depositor: Reference<sageWhMasterData.nodes.Depositor>;
    readonly product: Reference<sageWhProductData.nodes.Product>;
    readonly store: Reference<sageWhMasterData.nodes.Store>;
    readonly location: Reference<sageWhMasterData.nodes.Location>;
    readonly storeType: Promise<sageWhMasterData.enums.StoreType>;
    readonly locationType: Promise<sageWhMasterData.enums.LocationType>;
    readonly containerNumber: Promise<string>;
    readonly lotNumber: Promise<string>;
    readonly supportNumber: Promise<string>;
    readonly container: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly containerCoefficient: Promise<decimal>;
    readonly numberOfConsumptionUnit: Promise<decimal>;
    readonly numberOfContainer: Promise<decimal>;
    readonly numberOfConsumptionUnitInPendingInput: Promise<decimal | null>;
    readonly numberOfConsumptionUnitInPendingOutput: Promise<decimal | null>;
    readonly stockStatus: Reference<sageWhMasterData.nodes.StockNature | null>;
    readonly reservationNumber: Promise<string>;
    readonly source: Reference<sageWhProductData.nodes.Origin | null>;
    readonly stockObjectLinkNumber: Promise<string>;
    readonly fifoDate: Promise<date | null>;
    readonly receiptDate: Promise<date | null>;
    readonly manufacturedDate: Promise<date | null>;
    readonly detentionDate: Promise<date | null>;
    readonly sellByDate: Promise<date | null>;
    readonly useByDate: Promise<date | null>;
    readonly shipByDate: Promise<date | null>;
    readonly unStockingAllocationSequence: Promise<integer>;
    readonly storingDate: Promise<date | null>;
    readonly storingTime: Promise<integer | null>;
    readonly homogeneousContainer: Reference<sageWhProductData.nodes.ProductContainer>;
    readonly homogeneousContainerCoefficient: Promise<decimal>;
    readonly homogeneousQuantity: Promise<decimal>;
    readonly quantityInContainerCorrespondence: Promise<decimal>;
    readonly serialNumbers: Collection<sageWhStockData.nodes.SerialNumber>;
    readonly containerLevels: Collection<sageWhStockData.nodes.StockObjectContainerLevels>;
}
//# sourceMappingURL=stock-object.d.ts.map