"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDisplayCode = getDisplayCode;
exports.getKeyCodeForDuplicates = getKeyCodeForDuplicates;
const xtrem_core_1 = require("@sage/xtrem-core");
/**
 * Get the key code for display (SQL mutation).
 * @param _this The serial number object.
 * @returns The key code as a string.
 */
async function getDisplayCode(_this) {
    return `${await _this.code}-${await _this.double}-${await _this.occurrence}`;
}
(0, xtrem_core_1.registerSqlFunction)('sageWhStockData.functions.getDisplayCode', getDisplayCode);
/**
 * Get the key code for duplicates (SQL mutation).
 * @param _this The serial number object.
 * @returns The key code as a string.
 */
async function getKeyCodeForDuplicates(_this) {
    return `${await _this.code}|${await _this.double}|${await _this.occurrence}`;
}
(0, xtrem_core_1.registerSqlFunction)('sageWhStockData.functions.getKeyCodeForDuplicates', getKeyCodeForDuplicates);
//# sourceMappingURL=serial-number.js.map