"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateAggregateStockObjectRequest = generateAggregateStockObjectRequest;
exports.generateAggregateSerialNumberRequest = generateAggregateSerialNumberRequest;
const aggregators_1 = require("@sage/wh-master-data/lib/client-functions/aggregators");
/**
 * Generate an aggregate request for StockObject
 * @param selector
 * @param filter
 * @param numberOfRecords (optional, default 1000)
 * @returns aggregated query request
 */
function generateAggregateStockObjectRequest(pageInstance, selector, filter, numberOfRecords = 1000) {
    return pageInstance.$.graph
        .node('@sage/wh-stock-data/StockObject')
        .aggregate.query((0, aggregators_1.prepareAggregateGenericRequest)(selector, filter, numberOfRecords));
}
/**
 * Generate an aggregate request for SerialNumber
 * @param selector
 * @param filter
 * @param numberOfRecords (optional, default 1000)
 * @returns aggregated query request
 */
function generateAggregateSerialNumberRequest(pageInstance, selector, filter, numberOfRecords = 1000) {
    return pageInstance.$.graph
        .node('@sage/wh-stock-data/SerialNumber')
        .aggregate.query((0, aggregators_1.prepareAggregateGenericRequest)(selector, filter, numberOfRecords));
}
//# sourceMappingURL=aggregators.js.map