/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),xtrem_decimal_1=require("@sage/xtrem-decimal"),chai_1=require("chai"),mocha_1=require("mocha"),sinon=require("sinon"),xtremX3Interop=require("../../lib");let appInfoStub;(0,mocha_1.describe)("Sys synchronization",()=>{before(()=>{const{rootAbout:e}=xtrem_core_1.Test.application;appInfoStub=sinon.stub(xtrem_core_1.Test.application,"rootAbout").get(()=>({...e,appName:"test",version:"1.0.0",metadataPackage:"xtrem-app-metadata"}))}),after(()=>{appInfoStub.reset()}),it("Can get app info",()=>xtrem_core_1.Test.withContext(async e=>{const t=await xtremX3Interop.nodes.SysApp.getAppInfo(e);chai_1.assert.deepEqual(t,{name:"test",version:"1.0.0",metadataPackage:"xtrem-app-metadata"})})),it("Can read source feed",()=>xtrem_core_1.Test.withContext(async e=>{const t=await xtremX3Interop.nodes.SysSynchronizationSource.getSynchronizationFeed(e,"SysSite",xtrem_decimal_1.Decimal.make(0),"{\n                    code: true,\n                    name: true,\n                    isStockSite: true\n                }");chai_1.assert.isAbove(Number(t.nextTick),0);const r=[];for await(const e of t.feed)r.push(e);chai_1.assert.isAbove(r.length,0)})),it("Can read source feed with filter",()=>xtrem_core_1.Test.withContext(async e=>{const t=await xtremX3Interop.nodes.SysSynchronizationSource.getSynchronizationFeed(e,"SysSite",xtrem_decimal_1.Decimal.make(0),"{\n                    code: true,\n                    name: true,\n                    isStockSite: true\n                }","{ isStockSite: false}");chai_1.assert.isAbove(Number(t.nextTick),0);const r=[];for await(const e of t.feed)r.push(e);chai_1.assert.isAbove(r.length,0),chai_1.assert.isTrue(r.every(e=>!(0,xtrem_core_1.friendlyJsonParse)(e).isStockSite))}))});
//# sourceMappingURL=sys-synchronization-test.js.map