// From file: @sage/xtrem-x3-interop/build/index.d.ts
declare module '@sage/xtrem-x3-interop/index' {
	export * from '@sage/xtrem-x3-interop/lib/index';
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-interop/build/lib/index.d.ts
declare module '@sage/xtrem-x3-interop/lib/index' {
	import * as nodes from '@sage/xtrem-x3-interop/lib/nodes/_index';
	export { nodes };
	//# sourceMappingURL=index.d.ts.map
}
// From file: @sage/xtrem-x3-interop/build/lib/nodes/sys-synchronization-source.d.ts
declare module '@sage/xtrem-x3-interop/lib/nodes/sys-synchronization-source' {
	import { Context, Node } from '@sage/xtrem-core';
	import { Decimal } from '@sage/xtrem-decimal';
	import { decimal } from '@sage/xtrem-shared';
	/**
	 * Synchronization feed returned by the SysSynchronizationSource.getSynchronizationFeed method
	 */
	export interface SynchronizationFeed {
	    /** Tick for the next synchronization pass */
	    nextTick: decimal;
	    /** The returned feed. Each entry is a JSON string containing the record payload */
	    feed: AsyncGenerator<string>;
	}
	export class SysSynchronizationSource extends Node {
	    /**
	     *  Returns a synchronization feed for a synchronization source node.
	     *
	     * @param context the context
	     * @param node the synchronization source node
	     * @param startTick the start tick for incremental synchronization
	     * @param selector the selector that specifies the properties included in the response
	     * @returns a synchronization feed
	     */
	    static getSynchronizationFeed(context: Context, node: string, startTick: Decimal, selector: string, filter?: string): Promise<SynchronizationFeed>;
	}
	//# sourceMappingURL=sys-synchronization-source.d.ts.map
}
// From file: @sage/xtrem-x3-interop/build/lib/nodes/sys-app.d.ts
declare module '@sage/xtrem-x3-interop/lib/nodes/sys-app' {
	import { Context, Node } from '@sage/xtrem-core';
	export interface AppInfo {
	    name: string;
	    version: string;
	    metadataPackage: string;
	}
	export class SysApp extends Node {
	    /**
	     *  Returns the source app's version.
	     *
	     * @param context the context
	     * @returns a synchronization feed
	     */
	    static getAppInfo(context: Context): Promise<AppInfo>;
	}
	//# sourceMappingURL=sys-app.d.ts.map
}
// From file: @sage/xtrem-x3-interop/build/lib/nodes/_index.d.ts
declare module '@sage/xtrem-x3-interop/lib/nodes/_index' {
	export * from '@sage/xtrem-x3-interop/lib/nodes/sys-app';
	export * from '@sage/xtrem-x3-interop/lib/nodes/sys-synchronization-source';
	//# sourceMappingURL=_index.d.ts.map
}
declare module '@sage/xtrem-x3-interop' {
	export * from '@sage/xtrem-x3-interop/index';
}
