import { Context, Node } from '@sage/xtrem-core';
import { Decimal } from '@sage/xtrem-decimal';
import { decimal } from '@sage/xtrem-shared';
/**
 * Synchronization feed returned by the SysSynchronizationSource.getSynchronizationFeed method
 */
export interface SynchronizationFeed {
    /** Tick for the next synchronization pass */
    nextTick: decimal;
    /** The returned feed. Each entry is a JSON string containing the record payload */
    feed: AsyncGenerator<string>;
}
export declare class SysSynchronizationSource extends Node {
    /**
     *  Returns a synchronization feed for a synchronization source node.
     *
     * @param context the context
     * @param node the synchronization source node
     * @param startTick the start tick for incremental synchronization
     * @param selector the selector that specifies the properties included in the response
     * @returns a synchronization feed
     */
    static getSynchronizationFeed(context: Context, node: string, startTick: Decimal, selector: string, filter?: string): Promise<SynchronizationFeed>;
}
//# sourceMappingURL=sys-synchronization-source.d.ts.map