"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SysApp = void 0;
const xtrem_core_1 = require("@sage/xtrem-core");
const xtrem_x3_gateway_1 = require("@sage/xtrem-x3-gateway");
let SysApp = class SysApp extends xtrem_core_1.Node {
    /**
     *  Returns the source app's version.
     *
     * @param context the context
     * @returns a synchronization feed
     */
    static getAppInfo(context) {
        const { appName, version } = context.application.rootAbout;
        return Promise.resolve({ name: appName || '', version, metadataPackage: 'xtrem-app-metadata' });
    }
};
exports.SysApp = SysApp;
__decorate([
    xtrem_core_1.decorators.query({
        isPublished: true,
        parameters: [],
        return: {
            type: 'object',
            properties: {
                name: 'string',
                version: 'string',
                metadataPackage: 'string',
            },
        },
    })
], SysApp, "getAppInfo", null);
exports.SysApp = SysApp = __decorate([
    xtrem_core_1.decorators.node({
        isPublished: true,
        storage: 'external',
        externalStorageManager: new xtrem_x3_gateway_1.DummyStorageManager(),
        keyPropertyNames: ['_id'],
    })
], SysApp);
//# sourceMappingURL=sys-app.js.map