/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),chai_1=require("chai"),sql_query_1=require("../../../lib/sql-mapper/sql-query"),x3_storage_manager_1=require("../../../lib/storage/x3-storage-manager"),nodes_1=require("../../fixtures/nodes"),denormalized_with_reference_1=require("../../fixtures/nodes/denormalized-with-reference"),document_1=require("../../fixtures/nodes/document"),document_line_with_enum_ref_1=require("../../fixtures/nodes/document-line-with-enum-ref"),test_syracuse_method_1=require("../../fixtures/nodes/test-syracuse-method"),setup_1=require("../../fixtures/setup");function test(T,A,_,C,E,N){(T=>{switch(T){case"only":return it.only;case"skip":return it.skip;default:return it}})(N?.executionMode)(`${T} - ${_}`,async()=>{const T={response:{locals:{config:{x3:{sql:{driver:_,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com",database:"fakeDatabase",password:"fakePassword"}}}}}};await xtrem_core_1.Test.withContext(async T=>{if(!xtrem_x3_config_manager_1.X3ConfigManager.current.x3?.sql)throw new Error("X3 SQL config not found");xtrem_x3_config_manager_1.X3ConfigManager.current.x3.sql.driver=_;const O=T.application.getFactoryByConstructor(E),D=new sql_query_1.SqlQuery(T,O,{filters:[A],singleResultRequest:N?.singleResultRequest,orderBy:N?.orderBy,selector:N?.selector},"REPOSX3").getSqlQuery(),t=D.sql;chai_1.assert.equal(t.trim(),C[_].trim());const R=await D.promisedParameterValues;if(R.length>0){const T=N?.driverArgs?.[_]?N?.driverArgs?.[_]:N?.args;chai_1.assert.deepEqual(R,T)}},{config:T})})}describe("SQL Tests",()=>{before(setup_1.setupTest),["oracle","tedious","postgres"].forEach(T=>{describe(`SQL Query Generation - ${T}`,()=>{test("full table query",{},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE 1=1',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE 1=1    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE 1=1    "},nodes_1.TestDatatypes)}),describe("sql computed property",()=>{test("computed property logical test",{_or:[{computed:11},{computed:12}]},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN $1::INT8 ELSE (t0.ID_0 * t0.CVAL_0) END)::INT8 = $2::INT8 OR (CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN $1::INT8 ELSE (t0.ID_0 * t0.CVAL_0) END)::INT8 = $3::INT8)',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CAST((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN :v1 ELSE (t0.ID_0 * t0.CVAL_0) END) AS INTEGER) = :v2 OR CAST((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN :v1 ELSE (t0.ID_0 * t0.CVAL_0) END) AS INTEGER) = :v3)",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CAST((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN @p0 ELSE (t0.ID_0 * t0.CVAL_0) END) AS INTEGER) = @p1 OR CAST((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN @p0 ELSE (t0.ID_0 * t0.CVAL_0) END) AS INTEGER) = @p2)"},nodes_1.TestDatatypes,{args:[0,11,12]}),test("computed property where clause",{computed:1},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN $1::INT8 ELSE (t0.ID_0 * t0.CVAL_0) END)::INT8 = $2::INT8',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CAST((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN :v1 ELSE (t0.ID_0 * t0.CVAL_0) END) AS INTEGER) = :v2",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CAST((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN @p0 ELSE (t0.ID_0 * t0.CVAL_0) END) AS INTEGER) = @p1"},nodes_1.TestDatatypes,{args:[0,1]}),it(`can order by computed property - ${T}`,async()=>{const A={response:{locals:{config:{x3:{sql:{driver:T,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com",database:"fakeDatabase",password:"fakePassword"}}}}}};await xtrem_core_1.Test.withContext(A=>{const _=A.application.getFactoryByConstructor(nodes_1.TestDatatypes),C=new sql_query_1.SqlQuery(A,_,{orderBy:{computed:-1},filters:[]},"REPOSX3").getSqlQuery().sql;switch(T){case"postgres":chai_1.assert.equal(C.trim(),'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0", (CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN $1::INT8 ELSE (t0.ID_0 * t0.CVAL_0) END)::INT8 AS "THIS_COMPUTED" FROM REPOSX3.TESTDAT t0 WHERE 1=1  ORDER BY "THIS_COMPUTED" DESC');break;case"oracle":chai_1.assert.equal(C.trim(),"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, CAST((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN :v1 ELSE (t0.ID_0 * t0.CVAL_0) END) AS INTEGER) AS THIS_COMPUTED FROM REPOSX3.TESTDAT t0 WHERE 1=1  ORDER BY THIS_COMPUTED DESC NULLS LAST");break;default:chai_1.assert.equal(C.trim(),"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, CAST((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) THEN @p0 ELSE (t0.ID_0 * t0.CVAL_0) END) AS INTEGER) AS THIS_COMPUTED FROM REPOSX3.TESTDAT t0 WHERE 1=1  ORDER BY THIS_COMPUTED DESC")}},{config:A})})}),describe("convert null value to one space string in joins with function",()=>{test("can convert a null value to a single space string in joins with function",{reference:{code:1}},T,{postgres:'SELECT  t0.COD_0 AS "T_0_COD_0", t0.REF_0 AS "T_0_REF_0", t0.REFNOJOIN_0 AS "T_0_REFNOJOIN_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REF_0 AND t1.DES3AEX_0 = \' \' WHERE t1.COD_0 = $1',oracle:"SELECT  t0.COD_0 AS T_0_COD_0, t0.REF_0 AS T_0_REF_0, t0.REFNOJOIN_0 AS T_0_REFNOJOIN_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REF_0 AND t1.DES3AEX_0 = ' ' WHERE t1.COD_0 = :v1",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, t0.REF_0 AS T_0_REF_0, t0.REFNOJOIN_0 AS T_0_REFNOJOIN_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REF_0 AND t1.DES3AEX_0 = ' ' WHERE t1.COD_0 = @p0"},nodes_1.TestReferencing,{args:["1"]})}),describe("reference property without a join provide",()=>{test("can have a reference with an omitted join, provided that the target node has only one key property",{referenceNoJoin:{code:1}},T,{postgres:'SELECT  t0.COD_0 AS "T_0_COD_0", t0.REF_0 AS "T_0_REF_0", t0.REFNOJOIN_0 AS "T_0_REFNOJOIN_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REFNOJOIN_0 WHERE t1.COD_0 = $1',oracle:"SELECT  t0.COD_0 AS T_0_COD_0, t0.REF_0 AS T_0_REF_0, t0.REFNOJOIN_0 AS T_0_REFNOJOIN_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REFNOJOIN_0 WHERE t1.COD_0 = :v1",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, t0.REF_0 AS T_0_REF_0, t0.REFNOJOIN_0 AS T_0_REFNOJOIN_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REFNOJOIN_0 WHERE t1.COD_0 = @p0"},nodes_1.TestReferencing,{args:["1"]})}),describe("sql predicate regex",()=>{test("regex (not anchored)",{stringVal:/ring/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["ring",""],driverArgs:{tedious:["%ring%"]}}),test("regex with i option",{stringVal:{_regex:"Ring",_options:"i"}},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CI_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["Ring","i"],driverArgs:{tedious:["%Ring%"]}}),test("regex without i option",{stringVal:{_regex:"Ring"}},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["Ring",""],driverArgs:{tedious:["%Ring%"]}}),test("regex (anchored at start, matching)",{stringVal:/^string/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["^string",""],driverArgs:{tedious:["string%"]}}),test("regex (anchored at start, not matching)",{stringVal:/^ring/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["^ring",""],driverArgs:{tedious:["ring%"]}}),test("regex (anchored at end, not matching)",{stringVal:/1$/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["1$",""],driverArgs:{tedious:["%1"]}}),test("regex . pattern (matching)",{stringVal:/tr..g/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["tr..g",""],driverArgs:{tedious:["%tr__g%"]}}),test("regex . pattern (not matching)",{stringVal:/t..g/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["t..g",""],driverArgs:{tedious:["%t__g%"]}}),test("regex .* pattern (matching multiple)",{stringVal:/t.*g/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["t.*g",""],driverArgs:{tedious:["%t%g%"]}}),test("regex .* pattern (matching 1)",{stringVal:/tri.*g/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["tri.*g",""],driverArgs:{tedious:["%tri%g%"]}}),test("regex .* pattern (matching empty)",{stringVal:/trin.*g/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["trin.*g",""],driverArgs:{tedious:["%trin%g%"]}}),test("regex .* pattern (anchored and matching at start)",{stringVal:/^.*trin/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["^.*trin",""],driverArgs:{tedious:["%trin%"]}}),test("regex .* pattern (not anchored and matching at start)",{stringVal:/.*trin/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:[".*trin",""],driverArgs:{tedious:["%%trin%"]}}),test("regex .* pattern (anchored and matching at end)",{stringVal:/tring...1.*$/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["tring...1.*$",""],driverArgs:{tedious:["%tring___1%"]}}),test("regex .* pattern (not anchored and matching at end)",{stringVal:/tring...1.*/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["tring...1.*",""],driverArgs:{tedious:["%tring___1%%"]}}),test("regex containing % (matching)",{stringVal:/tring%/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["tring%",""],driverArgs:{tedious:["%tring$%%"]}}),test("regex containing % (not matching)",{stringVal:/t%g/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["t%g",""],driverArgs:{tedious:["%t$%g%"]}}),test("regex containing _ (matching)",{stringVal:/tring._/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["tring._",""],driverArgs:{tedious:["%tring_$_%"]}}),test("regex containing _ (not matching)",{stringVal:/tr_ng/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["tr_ng",""],driverArgs:{tedious:["%tr$_ng%"]}}),test("regex containing $ (matching)",{stringVal:/tring..\$/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["tring..\\$",""],driverArgs:{tedious:["%tring__$$%"]}}),test("regex containing $ (not matching)",{stringVal:/tr\$ng/},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE ARRAY_LENGTH(REGEXP_MATCH(t0.AVAL_0::TEXT, $1, $2), 1) > 0',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE REGEXP_LIKE(TO_CHAR(t0.AVAL_0),:v1,:v2)    ",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CONVERT(VARCHAR(max),t0.AVAL_0) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'    "},nodes_1.TestDatatypes,{args:["tr\\$ng",""],driverArgs:{tedious:["%tr$$ng%"]}}),after(()=>{})}),describe("Collections and references",()=>{test("Query reference",{enumValRef:{code:"ENUMCODE"}},T,{postgres:'SELECT  t0.DES_0 AS "T_0_DES_0", t0.NUMLIG_0 AS "T_0_NUMLIG_0", t0.ENUMVAL_0 AS "T_0_ENUMVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.ENUMREF t1 ON t1.COD_0 = t0.ENUMVAL_0 AND t1.ENUMVAL_0 = $1 WHERE t1.COD_0 = $2',oracle:"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.ENUMVAL_0 AS T_0_ENUMVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.ENUMREF t1 ON t1.COD_0 = t0.ENUMVAL_0 AND t1.ENUMVAL_0 = :v1 WHERE t1.COD_0 = :v2",tedious:"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.ENUMVAL_0 AS T_0_ENUMVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.ENUMREF t1 ON t1.COD_0 = t0.ENUMVAL_0 AND t1.ENUMVAL_0 = @p0 WHERE t1.COD_0 = @p1"},document_line_with_enum_ref_1.TestDocumentLineWithEnumRef,{args:[1,"ENUMCODE"]}),test("Query reference",{document:{parentDocument:{code:"DOCA"}}},T,{postgres:'SELECT  t0.DES_0 AS "T_0_DES_0", t0.NUMLIG_0 AS "T_0_NUMLIG_0", t0.DOC_0 AS "T_0_DOC_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE t2.COD_0 = $1',oracle:"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE t2.COD_0 = :v1",tedious:"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE t2.COD_0 = @p0"},nodes_1.TestDocumentLine,{args:["DOCA"]}),test("Query composite reference",{document:{parentDocument:{grandparentDocument:{code:"DOCA"}}}},T,{postgres:'SELECT  t0.DES_0 AS "T_0_DES_0", t0.NUMLIG_0 AS "T_0_NUMLIG_0", t0.DOC_0 AS "T_0_DOC_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t2.MAINDOC_0 INNER JOIN REPOSX3.TABDOC t4 ON t4.COD_0 = t3.MAINDOC_0 WHERE t4.COD_0 = $1',oracle:"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t2.MAINDOC_0 INNER JOIN REPOSX3.TABDOC t4 ON t4.COD_0 = t3.MAINDOC_0 WHERE t4.COD_0 = :v1",tedious:"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t2.MAINDOC_0 INNER JOIN REPOSX3.TABDOC t4 ON t4.COD_0 = t3.MAINDOC_0 WHERE t4.COD_0 = @p0"},nodes_1.TestDocumentLine,{args:["DOCA"]}),test("Query collection",{lines:{_every:true,lineNumber:1}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((SELECT COUNT(*) FROM REPOSX3.TABDOCLIN t9 WHERE  t9.DOC_0 = t0.COD_0 AND NOT(t9.NUMLIG_0 = $1::INT8)) = 0)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((SELECT COUNT(*) FROM REPOSX3.TABDOCLIN t9 WHERE  t9.DOC_0 = t0.COD_0 AND NOT(t9.NUMLIG_0 = :v1)) = 0)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((SELECT COUNT(*) FROM REPOSX3.TABDOCLIN t9 WHERE  t9.DOC_0 = t0.COD_0 AND NOT(t9.NUMLIG_0 = @p0)) = 0)"},document_1.TestDocument,{args:[1]}),test("Query composite collection",{grandparentLines:{_every:true,lineNumber:1}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((SELECT COUNT(*) FROM REPOSX3.TABDOCLIN t9 WHERE  t9.DOC_0 = t6.COD_0 AND NOT(t9.NUMLIG_0 = $1::INT8)) = 0)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((SELECT COUNT(*) FROM REPOSX3.TABDOCLIN t9 WHERE  t9.DOC_0 = t6.COD_0 AND NOT(t9.NUMLIG_0 = :v1)) = 0)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((SELECT COUNT(*) FROM REPOSX3.TABDOCLIN t9 WHERE  t9.DOC_0 = t6.COD_0 AND NOT(t9.NUMLIG_0 = @p0)) = 0)"},document_1.TestDocument,{args:[1]}),test("Denormailzed node with localized property",{id:1},T,{postgres:"SELECT  t0.ID_0 AS \"T_0_ID_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\", t0.DIM_0 AS \"T_0_DIM_0\", t0.DIM_1 AS \"T_0_DIM_1\", t0.DIM_2 AS \"T_0_DIM_2\", t0.DIM_3 AS \"T_0_DIM_3\", t0.DIM_4 AS \"T_0_DIM_4\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DIMLOC_0\", (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS \"T_0_DIMLOC_1\", (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS \"T_0_DIMLOC_2\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_0_DIMLOC_3\", (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS \"T_0_DIMLOC_4\" FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT($1,1),$2) AND t1.IDENT1_0 = t0.ID_0::TEXT AND t1.IDENT2_0 = t0.DIM_0::TEXT AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT($1,1),$2) AND t2.IDENT1_0 = t0.ID_0::TEXT AND t2.IDENT2_0 = t0.DIM_0::TEXT AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT($1,2),$2) AND t3.IDENT1_0 = t0.ID_0::TEXT AND t3.IDENT2_0 = t0.DIM_1::TEXT AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT($1,2),$2) AND t4.IDENT1_0 = t0.ID_0::TEXT AND t4.IDENT2_0 = t0.DIM_1::TEXT AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT($1,3),$2) AND t5.IDENT1_0 = t0.ID_0::TEXT AND t5.IDENT2_0 = t0.DIM_2::TEXT AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT($1,3),$2) AND t6.IDENT1_0 = t0.ID_0::TEXT AND t6.IDENT2_0 = t0.DIM_2::TEXT AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT($1,4),$2) AND t7.IDENT1_0 = t0.ID_0::TEXT AND t7.IDENT2_0 = t0.DIM_3::TEXT AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT($1,4),$2) AND t8.IDENT1_0 = t0.ID_0::TEXT AND t8.IDENT2_0 = t0.DIM_3::TEXT AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT($1,5),$2) AND t9.IDENT1_0 = t0.ID_0::TEXT AND t9.IDENT2_0 = t0.DIM_4::TEXT AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT($1,5),$2) AND t10.IDENT1_0 = t0.ID_0::TEXT AND t10.IDENT2_0 = t0.DIM_4::TEXT AND t10.LANGUE_0 = 'FRA' WHERE t0.ID_0 = $3::INT8  ORDER BY \"T_0_ID_0\" ASC",oracle:"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT(:v1,1),:v2) AND t1.IDENT1_0 = TO_CHAR(t0.ID_0) AND t1.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT(:v1,1),:v2) AND t2.IDENT1_0 = TO_CHAR(t0.ID_0) AND t2.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT(:v1,2),:v2) AND t3.IDENT1_0 = TO_CHAR(t0.ID_0) AND t3.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT(:v1,2),:v2) AND t4.IDENT1_0 = TO_CHAR(t0.ID_0) AND t4.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT(:v1,3),:v2) AND t5.IDENT1_0 = TO_CHAR(t0.ID_0) AND t5.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT(:v1,3),:v2) AND t6.IDENT1_0 = TO_CHAR(t0.ID_0) AND t6.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT(:v1,4),:v2) AND t7.IDENT1_0 = TO_CHAR(t0.ID_0) AND t7.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT(:v1,4),:v2) AND t8.IDENT1_0 = TO_CHAR(t0.ID_0) AND t8.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT(:v1,5),:v2) AND t9.IDENT1_0 = TO_CHAR(t0.ID_0) AND t9.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT(:v1,5),:v2) AND t10.IDENT1_0 = TO_CHAR(t0.ID_0) AND t10.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE t0.ID_0 = :v3  ORDER BY T_0_ID_0 ASC NULLS FIRST",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT(@p0,1),@p1) AND t1.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t1.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT(@p0,1),@p1) AND t2.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t2.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT(@p0,2),@p1) AND t3.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t3.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT(@p0,2),@p1) AND t4.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t4.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT(@p0,3),@p1) AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t5.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT(@p0,3),@p1) AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t6.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT(@p0,4),@p1) AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t7.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT(@p0,4),@p1) AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t8.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT(@p0,5),@p1) AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t9.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT(@p0,5),@p1) AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t10.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE t0.ID_0 = @p2  ORDER BY T_0_ID_0 ASC"},nodes_1.TestDenormalized,{args:["DIMLOC(",")",1]}),test("Denormailzed node with filter",{denormalized:"VALUE"},T,{postgres:"SELECT  t0.ID_0 AS \"T_0_ID_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\", t0.DIM_0 AS \"T_0_DIM_0\", t0.DIM_1 AS \"T_0_DIM_1\", t0.DIM_2 AS \"T_0_DIM_2\", t0.DIM_3 AS \"T_0_DIM_3\", t0.DIM_4 AS \"T_0_DIM_4\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DIMLOC_0\", (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS \"T_0_DIMLOC_1\", (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS \"T_0_DIMLOC_2\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_0_DIMLOC_3\", (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS \"T_0_DIMLOC_4\" FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT($1,1),$2) AND t1.IDENT1_0 = t0.ID_0::TEXT AND t1.IDENT2_0 = t0.DIM_0::TEXT AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT($1,1),$2) AND t2.IDENT1_0 = t0.ID_0::TEXT AND t2.IDENT2_0 = t0.DIM_0::TEXT AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT($1,2),$2) AND t3.IDENT1_0 = t0.ID_0::TEXT AND t3.IDENT2_0 = t0.DIM_1::TEXT AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT($1,2),$2) AND t4.IDENT1_0 = t0.ID_0::TEXT AND t4.IDENT2_0 = t0.DIM_1::TEXT AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT($1,3),$2) AND t5.IDENT1_0 = t0.ID_0::TEXT AND t5.IDENT2_0 = t0.DIM_2::TEXT AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT($1,3),$2) AND t6.IDENT1_0 = t0.ID_0::TEXT AND t6.IDENT2_0 = t0.DIM_2::TEXT AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT($1,4),$2) AND t7.IDENT1_0 = t0.ID_0::TEXT AND t7.IDENT2_0 = t0.DIM_3::TEXT AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT($1,4),$2) AND t8.IDENT1_0 = t0.ID_0::TEXT AND t8.IDENT2_0 = t0.DIM_3::TEXT AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT($1,5),$2) AND t9.IDENT1_0 = t0.ID_0::TEXT AND t9.IDENT2_0 = t0.DIM_4::TEXT AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT($1,5),$2) AND t10.IDENT1_0 = t0.ID_0::TEXT AND t10.IDENT2_0 = t0.DIM_4::TEXT AND t10.LANGUE_0 = 'FRA' WHERE (t0.DIM_0 = $3 OR t0.DIM_1 = $3 OR t0.DIM_2 = $3 OR t0.DIM_3 = $3 OR t0.DIM_4 = $3)  ORDER BY \"T_0_ID_0\" ASC",oracle:"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT(:v1,1),:v2) AND t1.IDENT1_0 = TO_CHAR(t0.ID_0) AND t1.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT(:v1,1),:v2) AND t2.IDENT1_0 = TO_CHAR(t0.ID_0) AND t2.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT(:v1,2),:v2) AND t3.IDENT1_0 = TO_CHAR(t0.ID_0) AND t3.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT(:v1,2),:v2) AND t4.IDENT1_0 = TO_CHAR(t0.ID_0) AND t4.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT(:v1,3),:v2) AND t5.IDENT1_0 = TO_CHAR(t0.ID_0) AND t5.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT(:v1,3),:v2) AND t6.IDENT1_0 = TO_CHAR(t0.ID_0) AND t6.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT(:v1,4),:v2) AND t7.IDENT1_0 = TO_CHAR(t0.ID_0) AND t7.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT(:v1,4),:v2) AND t8.IDENT1_0 = TO_CHAR(t0.ID_0) AND t8.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT(:v1,5),:v2) AND t9.IDENT1_0 = TO_CHAR(t0.ID_0) AND t9.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT(:v1,5),:v2) AND t10.IDENT1_0 = TO_CHAR(t0.ID_0) AND t10.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE (t0.DIM_0 = :v3 OR t0.DIM_1 = :v3 OR t0.DIM_2 = :v3 OR t0.DIM_3 = :v3 OR t0.DIM_4 = :v3)  ORDER BY T_0_ID_0 ASC NULLS FIRST",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT(@p0,1),@p1) AND t1.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t1.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT(@p0,1),@p1) AND t2.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t2.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT(@p0,2),@p1) AND t3.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t3.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT(@p0,2),@p1) AND t4.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t4.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT(@p0,3),@p1) AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t5.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT(@p0,3),@p1) AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t6.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT(@p0,4),@p1) AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t7.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT(@p0,4),@p1) AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t8.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT(@p0,5),@p1) AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t9.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT(@p0,5),@p1) AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t10.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE (t0.DIM_0 = @p2 OR t0.DIM_1 = @p2 OR t0.DIM_2 = @p2 OR t0.DIM_3 = @p2 OR t0.DIM_4 = @p2)  ORDER BY T_0_ID_0 ASC"},nodes_1.TestDenormalized,{args:["DIMLOC(",")","VALUE"]}),test("Denormailzed node with _ne filter",{denormalized:{_ne:"VALUE"}},T,{postgres:"SELECT  t0.ID_0 AS \"T_0_ID_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\", t0.DIM_0 AS \"T_0_DIM_0\", t0.DIM_1 AS \"T_0_DIM_1\", t0.DIM_2 AS \"T_0_DIM_2\", t0.DIM_3 AS \"T_0_DIM_3\", t0.DIM_4 AS \"T_0_DIM_4\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DIMLOC_0\", (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS \"T_0_DIMLOC_1\", (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS \"T_0_DIMLOC_2\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_0_DIMLOC_3\", (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS \"T_0_DIMLOC_4\" FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT($1,1),$2) AND t1.IDENT1_0 = t0.ID_0::TEXT AND t1.IDENT2_0 = t0.DIM_0::TEXT AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT($1,1),$2) AND t2.IDENT1_0 = t0.ID_0::TEXT AND t2.IDENT2_0 = t0.DIM_0::TEXT AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT($1,2),$2) AND t3.IDENT1_0 = t0.ID_0::TEXT AND t3.IDENT2_0 = t0.DIM_1::TEXT AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT($1,2),$2) AND t4.IDENT1_0 = t0.ID_0::TEXT AND t4.IDENT2_0 = t0.DIM_1::TEXT AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT($1,3),$2) AND t5.IDENT1_0 = t0.ID_0::TEXT AND t5.IDENT2_0 = t0.DIM_2::TEXT AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT($1,3),$2) AND t6.IDENT1_0 = t0.ID_0::TEXT AND t6.IDENT2_0 = t0.DIM_2::TEXT AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT($1,4),$2) AND t7.IDENT1_0 = t0.ID_0::TEXT AND t7.IDENT2_0 = t0.DIM_3::TEXT AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT($1,4),$2) AND t8.IDENT1_0 = t0.ID_0::TEXT AND t8.IDENT2_0 = t0.DIM_3::TEXT AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT($1,5),$2) AND t9.IDENT1_0 = t0.ID_0::TEXT AND t9.IDENT2_0 = t0.DIM_4::TEXT AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT($1,5),$2) AND t10.IDENT1_0 = t0.ID_0::TEXT AND t10.IDENT2_0 = t0.DIM_4::TEXT AND t10.LANGUE_0 = 'FRA' WHERE ((t0.DIM_0 != $3) OR (t0.DIM_1 != $3) OR (t0.DIM_2 != $3) OR (t0.DIM_3 != $3) OR (t0.DIM_4 != $3))  ORDER BY \"T_0_ID_0\" ASC",oracle:"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT(:v1,1),:v2) AND t1.IDENT1_0 = TO_CHAR(t0.ID_0) AND t1.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT(:v1,1),:v2) AND t2.IDENT1_0 = TO_CHAR(t0.ID_0) AND t2.IDENT2_0 = TO_CHAR(t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT(:v1,2),:v2) AND t3.IDENT1_0 = TO_CHAR(t0.ID_0) AND t3.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT(:v1,2),:v2) AND t4.IDENT1_0 = TO_CHAR(t0.ID_0) AND t4.IDENT2_0 = TO_CHAR(t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT(:v1,3),:v2) AND t5.IDENT1_0 = TO_CHAR(t0.ID_0) AND t5.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT(:v1,3),:v2) AND t6.IDENT1_0 = TO_CHAR(t0.ID_0) AND t6.IDENT2_0 = TO_CHAR(t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT(:v1,4),:v2) AND t7.IDENT1_0 = TO_CHAR(t0.ID_0) AND t7.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT(:v1,4),:v2) AND t8.IDENT1_0 = TO_CHAR(t0.ID_0) AND t8.IDENT2_0 = TO_CHAR(t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT(:v1,5),:v2) AND t9.IDENT1_0 = TO_CHAR(t0.ID_0) AND t9.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT(:v1,5),:v2) AND t10.IDENT1_0 = TO_CHAR(t0.ID_0) AND t10.IDENT2_0 = TO_CHAR(t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE ((t0.DIM_0 != :v3) OR (t0.DIM_1 != :v3) OR (t0.DIM_2 != :v3) OR (t0.DIM_3 != :v3) OR (t0.DIM_4 != :v3))  ORDER BY T_0_ID_0 ASC NULLS FIRST",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DIMLOC_0, (CASE WHEN (t3.TEXTE_0 IS NOT NULL) THEN t3.TEXTE_0 ELSE t4.TEXTE_0 END) AS T_0_DIMLOC_1, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_0_DIMLOC_2, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_0_DIMLOC_3, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_0_DIMLOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'DENORMALIZEDPARENT' AND t1.ZONE_0 = CONCAT(CONCAT(@p0,1),@p1) AND t1.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t1.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'DENORMALIZEDPARENT' AND t2.ZONE_0 = CONCAT(CONCAT(@p0,1),@p1) AND t2.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t2.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_0) AND t2.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'DENORMALIZEDPARENT' AND t3.ZONE_0 = CONCAT(CONCAT(@p0,2),@p1) AND t3.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t3.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t3.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'DENORMALIZEDPARENT' AND t4.ZONE_0 = CONCAT(CONCAT(@p0,2),@p1) AND t4.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t4.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_1) AND t4.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'DENORMALIZEDPARENT' AND t5.ZONE_0 = CONCAT(CONCAT(@p0,3),@p1) AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t5.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'DENORMALIZEDPARENT' AND t6.ZONE_0 = CONCAT(CONCAT(@p0,3),@p1) AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t6.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_2) AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'DENORMALIZEDPARENT' AND t7.ZONE_0 = CONCAT(CONCAT(@p0,4),@p1) AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t7.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'DENORMALIZEDPARENT' AND t8.ZONE_0 = CONCAT(CONCAT(@p0,4),@p1) AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t8.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_3) AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'DENORMALIZEDPARENT' AND t9.ZONE_0 = CONCAT(CONCAT(@p0,5),@p1) AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t9.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'DENORMALIZEDPARENT' AND t10.ZONE_0 = CONCAT(CONCAT(@p0,5),@p1) AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t0.ID_0) AND t10.IDENT2_0 = CONVERT(VARCHAR(max),t0.DIM_4) AND t10.LANGUE_0 = 'FRA' WHERE ((t0.DIM_0 != @p2) OR (t0.DIM_1 != @p2) OR (t0.DIM_2 != @p2) OR (t0.DIM_3 != @p2) OR (t0.DIM_4 != @p2))  ORDER BY T_0_ID_0 ASC"},nodes_1.TestDenormalized,{args:["DIMLOC(",")","VALUE"]}),test("Denormailzed node with reference filter",{document:{parentDocument:{code:"VALUE"}}},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0", t0.DOC_0 AS "T_0_DOC_0", t0.DOC_1 AS "T_0_DOC_1", t0.DOC_2 AS "T_0_DOC_2", t0.DOC_3 AS "T_0_DOC_3", t0.DOC_4 AS "T_0_DOC_4" FROM REPOSX3.DENORMALIZEDPARENT t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 IN (t0.DOC_0,t0.DOC_1,t0.DOC_2,t0.DOC_3,t0.DOC_4) INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE t2.COD_0 = $1  ORDER BY "T_0_ID_0" ASC',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DOC_0 AS T_0_DOC_0, t0.DOC_1 AS T_0_DOC_1, t0.DOC_2 AS T_0_DOC_2, t0.DOC_3 AS T_0_DOC_3, t0.DOC_4 AS T_0_DOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 IN (t0.DOC_0,t0.DOC_1,t0.DOC_2,t0.DOC_3,t0.DOC_4) INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE t2.COD_0 = :v1  ORDER BY T_0_ID_0 ASC NULLS FIRST",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t0.DOC_0 AS T_0_DOC_0, t0.DOC_1 AS T_0_DOC_1, t0.DOC_2 AS T_0_DOC_2, t0.DOC_3 AS T_0_DOC_3, t0.DOC_4 AS T_0_DOC_4 FROM REPOSX3.DENORMALIZEDPARENT t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 IN (t0.DOC_0,t0.DOC_1,t0.DOC_2,t0.DOC_3,t0.DOC_4) INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE t2.COD_0 = @p0  ORDER BY T_0_ID_0 ASC"},denormalized_with_reference_1.TestDenormalizedWithReference,{args:["VALUE"]}),test("Nested filter on denormalized collection",{denormalized:{_atLeast:1,denormalized:"VALUE"}},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", t0.DIM_3 AS "T_0_DIM_3", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.DENORMALIZEDPARENT t0 WHERE ((SELECT COUNT(*) FROM REPOSX3.DENORMALIZEDPARENT t1 WHERE  t1.ID_0 = t0.ID_0 AND (t1.DIM_0 = $1 OR t1.DIM_1 = $1 OR t1.DIM_2 = $1 OR t1.DIM_3 = $1 OR t1.DIM_4 = $1)) >= $2)',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, t0.DIM_3 AS T_0_DIM_3, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.DENORMALIZEDPARENT t0 WHERE ((SELECT COUNT(*) FROM REPOSX3.DENORMALIZEDPARENT t1 WHERE  t1.ID_0 = t0.ID_0 AND (t1.DIM_0 = :v1 OR t1.DIM_1 = :v1 OR t1.DIM_2 = :v1 OR t1.DIM_3 = :v1 OR t1.DIM_4 = :v1)) >= :v2)",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, t0.DIM_3 AS T_0_DIM_3, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.DENORMALIZEDPARENT t0 WHERE ((SELECT COUNT(*) FROM REPOSX3.DENORMALIZEDPARENT t1 WHERE  t1.ID_0 = t0.ID_0 AND (t1.DIM_0 = @p0 OR t1.DIM_1 = @p0 OR t1.DIM_2 = @p0 OR t1.DIM_3 = @p0 OR t1.DIM_4 = @p0)) >= @p1)"},nodes_1.TestDenormalizedParent,{args:["VALUE",1]}),test("Query reference with empty value",{document:{parentDocument:{code:{_in:["DOCA",null]}}}},T,{postgres:'SELECT  t0.DES_0 AS "T_0_DES_0", t0.NUMLIG_0 AS "T_0_NUMLIG_0", t0.DOC_0 AS "T_0_DOC_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE ((CASE WHEN (t2.COD_0 = \' \' OR t2.COD_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t2.COD_0 IN ($1)))',oracle:"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE ((CASE WHEN (t2.COD_0 = ' ' OR t2.COD_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t2.COD_0 IN (:v1)))",tedious:"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE ((CASE WHEN (t2.COD_0 = ' ' OR t2.COD_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t2.COD_0 IN (@p0)))"},nodes_1.TestDocumentLine,{args:["DOCA"]}),test("Query reference with empty null reference",{document:{parentDocument:{code:{_in:["DOCA",null]}}}},T,{postgres:'SELECT  t0.DES_0 AS "T_0_DES_0", t0.NUMLIG_0 AS "T_0_NUMLIG_0", t0.DOC_0 AS "T_0_DOC_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE ((CASE WHEN (t2.COD_0 = \' \' OR t2.COD_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t2.COD_0 IN ($1)))',oracle:"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE ((CASE WHEN (t2.COD_0 = ' ' OR t2.COD_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t2.COD_0 IN (:v1)))",tedious:"SELECT  t0.DES_0 AS T_0_DES_0, t0.NUMLIG_0 AS T_0_NUMLIG_0, t0.DOC_0 AS T_0_DOC_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOCLIN t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.DOC_0 INNER JOIN REPOSX3.TABDOC t2 ON t2.COD_0 = t1.MAINDOC_0 WHERE ((CASE WHEN (t2.COD_0 = ' ' OR t2.COD_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t2.COD_0 IN (@p0)))"},nodes_1.TestDocumentLine,{args:["DOCA"]})}),describe("Localized properties",()=>{test("Filter by localized string property",{description:{_regex:"Ring"}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ARRAY_LENGTH(REGEXP_MATCH((CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END)::TEXT, $1, $2), 1) > 0",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE REGEXP_LIKE(TO_CHAR((CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END)),:v1,:v2)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE CONVERT(VARCHAR(max),(CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END)) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'"},document_1.TestDocument,{args:["Ring",""],driverArgs:{tedious:["%Ring%"]}}),test("Filter by localized composite string property",{parentDescription:{_regex:"Ring"}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ARRAY_LENGTH(REGEXP_MATCH((CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END)::TEXT, $1, $2), 1) > 0",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE REGEXP_LIKE(TO_CHAR((CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END)),:v1,:v2)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE CONVERT(VARCHAR(max),(CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END)) COLLATE Latin1_General_CS_AS LIKE @p0 escape '$'"},document_1.TestDocument,{args:["Ring",""],driverArgs:{tedious:["%Ring%"]}})}),describe("Boolean properties",()=>{test("Filter boolean property to true",{booleanVal:true},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = $1::INT8',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = :v1",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = @p0"},nodes_1.TestDatatypes,{args:[1]}),test("Filter boolean property to false",{booleanVal:false},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = $1::INT8',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = :v1",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = @p0"},nodes_1.TestDatatypes,{args:[0]}),test("Filter boolean property to null",{booleanVal:null},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) IS NULL) THEN 1 ELSE 0 END)=1',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) IS NULL) THEN 1 ELSE 0 END)=1",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) IS NULL) THEN 1 ELSE 0 END)=1"},nodes_1.TestDatatypes),test("Filter boolean getValue with ===",{eqBooleanGetValue:true},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE (NOT (((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = $1::INT8)::BOOLEAN))',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CAST(((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = :v1) AS BOOLEAN)",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE CAST(((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = @p0) AS BOOLEAN)"},nodes_1.TestDatatypes,{args:[1]}),test("Filter boolean getValue with !==",{neBooleanGetValue:false},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE (NOT (((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) != $1::INT8)::BOOLEAN))',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (NOT (CAST(((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) != :v1) AS BOOLEAN)))",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (NOT (CAST(((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) != @p0) AS BOOLEAN)))"},nodes_1.TestDatatypes,{args:[1,0]}),test("Filter boolean getValue with ternary that returns true or null",{nullBooleanGetValue:null},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN ((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = $1::INT8) THEN $1::INT8 ELSE NULL END)::BOOLEAN IS NULL) THEN 1 ELSE 0 END)=1',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN (CAST((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = :v1) THEN :v1 ELSE NULL END) AS BOOLEAN) IS NULL) THEN 1 ELSE 0 END)=1",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN (CAST((CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = @p0) THEN @p0 ELSE NULL END) AS BOOLEAN) IS NULL) THEN 1 ELSE 0 END)=1"},nodes_1.TestDatatypes,{args:[1]}),test("Filter boolean property in ternary that returns true or false",{_fn:"this.booleanVal &&  this.integerVal===1 ? true : false"},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0", t0.SHOVAL_0 AS "T_0_SHOVAL_0", t0.CVAL_0 AS "T_0_CVAL_0", t0.LOCMENVAL_0 AS "T_0_LOCMENVAL_0", t0.AVAL_0 AS "T_0_AVAL_0", t0.DCBVAL_0 AS "T_0_DCBVAL_0", t0.FLOATVAL_0 AS "T_0_FLOATVAL_0", t0.DOUBLEVAL_0 AS "T_0_DOUBLEVAL_0", t0.DATVAL_0 AS "T_0_DATVAL_0", t0.TIMVAL_0 AS "T_0_TIMVAL_0", t0.DATTIMVAL_0 AS "T_0_DATTIMVAL_0", t0.BLBVAL_0 AS "T_0_BLBVAL_0", t0.CLBVAL_0 AS "T_0_CLBVAL_0", t0.UUIDVAL_0 AS "T_0_UUIDVAL_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) AND (t0.CVAL_0 = $1::INT8) THEN $1::INT8 ELSE $2::INT8 END)',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, t0.DATVAL_0 AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) AND (t0.CVAL_0 = :v1) THEN :v1 ELSE :v2 END)",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0, t0.SHOVAL_0 AS T_0_SHOVAL_0, t0.CVAL_0 AS T_0_CVAL_0, t0.LOCMENVAL_0 AS T_0_LOCMENVAL_0, t0.AVAL_0 AS T_0_AVAL_0, t0.DCBVAL_0 AS T_0_DCBVAL_0, t0.FLOATVAL_0 AS T_0_FLOATVAL_0, t0.DOUBLEVAL_0 AS T_0_DOUBLEVAL_0, CAST(t0.DATVAL_0 AS DATE) AS T_0_DATVAL_0, t0.TIMVAL_0 AS T_0_TIMVAL_0, t0.DATTIMVAL_0 AS T_0_DATTIMVAL_0, t0.BLBVAL_0 AS T_0_BLBVAL_0, t0.CLBVAL_0 AS T_0_CLBVAL_0, t0.UUIDVAL_0 AS T_0_UUIDVAL_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TESTDAT t0 WHERE (CASE WHEN ((CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) = 1) AND (t0.CVAL_0 = @p0) THEN @p0 ELSE @p1 END)"},nodes_1.TestDatatypes,{args:[1,0]})}),describe("Composite keys",()=>{test("Filter by _id (read)",{_id:"ART_TITRE|SITEA"},T,{postgres:"SELECT  t0.ITMREF_0 AS \"T_0_ITMREF_0\", 'PLACEHOLDER' AS \"THIS_STANDALONE_PRODUCT\", t1.ITMDES1_0 AS \"T_1_ITMDES_1_0\", t1.ITMDES2_0 AS \"T_1_ITMDES_2_0\", t1.ITMDES3_0 AS \"T_1_ITMDES_3_0\", t2.ITMWEI_0 AS \"T_2_ITMWEI_0\", t2.ITMVOU_0 AS \"T_2_ITMVOU_0\", t0.STOFCY_0 AS \"T_0_STOFCY_0\", (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LOCMGTCOD_0\", (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LPNMGTCOD_0\", (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_PCKFLG_0\", t4.LEG_0 AS \"T_4_LEG_0\", (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS \"T_1_DES_1_AXX_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_1_DES_2_AXX_0\", (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS \"T_1_DES_3_AXX_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = t1.ITMREF_0::TEXT AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = t1.ITMREF_0::TEXT AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = t1.ITMREF_0::TEXT AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = t1.ITMREF_0::TEXT AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = t1.ITMREF_0::TEXT AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = t1.ITMREF_0::TEXT AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE t0.ITMREF_0 = $1 AND t0.STOFCY_0 = $2",oracle:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE t0.ITMREF_0 = :v1 AND t0.STOFCY_0 = :v2",tedious:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE t0.ITMREF_0 = @p0 AND t0.STOFCY_0 = @p1"},nodes_1.TestProductSite,{args:["ART_TITRE","SITEA"]}),test("Filter by _id (read) starting with #",{_id:`${x3_storage_manager_1.X3StorageManager.hashtagPlaceholder}ART_TITRE|${x3_storage_manager_1.X3StorageManager.hashtagPlaceholder}SITEA`},T,{postgres:"SELECT  t0.ITMREF_0 AS \"T_0_ITMREF_0\", 'PLACEHOLDER' AS \"THIS_STANDALONE_PRODUCT\", t1.ITMDES1_0 AS \"T_1_ITMDES_1_0\", t1.ITMDES2_0 AS \"T_1_ITMDES_2_0\", t1.ITMDES3_0 AS \"T_1_ITMDES_3_0\", t2.ITMWEI_0 AS \"T_2_ITMWEI_0\", t2.ITMVOU_0 AS \"T_2_ITMVOU_0\", t0.STOFCY_0 AS \"T_0_STOFCY_0\", (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LOCMGTCOD_0\", (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LPNMGTCOD_0\", (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_PCKFLG_0\", t4.LEG_0 AS \"T_4_LEG_0\", (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS \"T_1_DES_1_AXX_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_1_DES_2_AXX_0\", (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS \"T_1_DES_3_AXX_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = t1.ITMREF_0::TEXT AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = t1.ITMREF_0::TEXT AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = t1.ITMREF_0::TEXT AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = t1.ITMREF_0::TEXT AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = t1.ITMREF_0::TEXT AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = t1.ITMREF_0::TEXT AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE t0.ITMREF_0 = $1 AND t0.STOFCY_0 = $2",oracle:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE t0.ITMREF_0 = :v1 AND t0.STOFCY_0 = :v2",tedious:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE t0.ITMREF_0 = @p0 AND t0.STOFCY_0 = @p1"},nodes_1.TestProductSite,{args:["#ART_TITRE","#SITEA"]}),test("Filter by _id (query with _in)",{_id:{_in:["ART_TITRE|SITEA","ART_TITRE2|SITEA2"]}},T,{postgres:"SELECT  t0.ITMREF_0 AS \"T_0_ITMREF_0\", 'PLACEHOLDER' AS \"THIS_STANDALONE_PRODUCT\", t1.ITMDES1_0 AS \"T_1_ITMDES_1_0\", t1.ITMDES2_0 AS \"T_1_ITMDES_2_0\", t1.ITMDES3_0 AS \"T_1_ITMDES_3_0\", t2.ITMWEI_0 AS \"T_2_ITMWEI_0\", t2.ITMVOU_0 AS \"T_2_ITMVOU_0\", t0.STOFCY_0 AS \"T_0_STOFCY_0\", (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LOCMGTCOD_0\", (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LPNMGTCOD_0\", (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_PCKFLG_0\", t4.LEG_0 AS \"T_4_LEG_0\", (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS \"T_1_DES_1_AXX_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_1_DES_2_AXX_0\", (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS \"T_1_DES_3_AXX_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = t1.ITMREF_0::TEXT AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = t1.ITMREF_0::TEXT AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = t1.ITMREF_0::TEXT AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = t1.ITMREF_0::TEXT AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = t1.ITMREF_0::TEXT AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = t1.ITMREF_0::TEXT AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE (CONCAT(t0.ITMREF_0::TEXT,CONCAT('|',t0.STOFCY_0::TEXT)) IN ($1,$2))",oracle:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE (CONCAT(TO_CHAR(t0.ITMREF_0),CONCAT('|',TO_CHAR(t0.STOFCY_0))) IN (:v1,:v2))",tedious:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE (CONCAT(CONVERT(VARCHAR(max),t0.ITMREF_0),CONCAT('|',CONVERT(VARCHAR(max),t0.STOFCY_0))) IN (@p0,@p1))"},nodes_1.TestProductSite,{args:["ART_TITRE|SITEA","ART_TITRE2|SITEA2"]}),test("Filter by _id (query with _in)  starting with #",{_id:{_in:[`${x3_storage_manager_1.X3StorageManager.hashtagPlaceholder}ART_TITRE|SITEA`,`ART_TITRE2|${x3_storage_manager_1.X3StorageManager.hashtagPlaceholder}SITEA2`]}},T,{postgres:"SELECT  t0.ITMREF_0 AS \"T_0_ITMREF_0\", 'PLACEHOLDER' AS \"THIS_STANDALONE_PRODUCT\", t1.ITMDES1_0 AS \"T_1_ITMDES_1_0\", t1.ITMDES2_0 AS \"T_1_ITMDES_2_0\", t1.ITMDES3_0 AS \"T_1_ITMDES_3_0\", t2.ITMWEI_0 AS \"T_2_ITMWEI_0\", t2.ITMVOU_0 AS \"T_2_ITMVOU_0\", t0.STOFCY_0 AS \"T_0_STOFCY_0\", (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LOCMGTCOD_0\", (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LPNMGTCOD_0\", (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_PCKFLG_0\", t4.LEG_0 AS \"T_4_LEG_0\", (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS \"T_1_DES_1_AXX_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_1_DES_2_AXX_0\", (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS \"T_1_DES_3_AXX_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = t1.ITMREF_0::TEXT AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = t1.ITMREF_0::TEXT AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = t1.ITMREF_0::TEXT AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = t1.ITMREF_0::TEXT AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = t1.ITMREF_0::TEXT AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = t1.ITMREF_0::TEXT AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE (CONCAT(t0.ITMREF_0::TEXT,CONCAT('|',t0.STOFCY_0::TEXT)) IN ($1,$2))",oracle:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE (CONCAT(TO_CHAR(t0.ITMREF_0),CONCAT('|',TO_CHAR(t0.STOFCY_0))) IN (:v1,:v2))",tedious:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE (CONCAT(CONVERT(VARCHAR(max),t0.ITMREF_0),CONCAT('|',CONVERT(VARCHAR(max),t0.STOFCY_0))) IN (@p0,@p1))"},nodes_1.TestProductSite,{args:["#ART_TITRE|SITEA","ART_TITRE2|#SITEA2"]}),test("Filter by _id (query with regex)",{_id:{_regex:"SITEA",_options:"i"}},T,{postgres:"SELECT  t0.ITMREF_0 AS \"T_0_ITMREF_0\", 'PLACEHOLDER' AS \"THIS_STANDALONE_PRODUCT\", t1.ITMDES1_0 AS \"T_1_ITMDES_1_0\", t1.ITMDES2_0 AS \"T_1_ITMDES_2_0\", t1.ITMDES3_0 AS \"T_1_ITMDES_3_0\", t2.ITMWEI_0 AS \"T_2_ITMWEI_0\", t2.ITMVOU_0 AS \"T_2_ITMVOU_0\", t0.STOFCY_0 AS \"T_0_STOFCY_0\", (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LOCMGTCOD_0\", (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LPNMGTCOD_0\", (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_PCKFLG_0\", t4.LEG_0 AS \"T_4_LEG_0\", (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS \"T_1_DES_1_AXX_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_1_DES_2_AXX_0\", (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS \"T_1_DES_3_AXX_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = t1.ITMREF_0::TEXT AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = t1.ITMREF_0::TEXT AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = t1.ITMREF_0::TEXT AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = t1.ITMREF_0::TEXT AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = t1.ITMREF_0::TEXT AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = t1.ITMREF_0::TEXT AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE ARRAY_LENGTH(REGEXP_MATCH(CONCAT(t0.ITMREF_0::TEXT,CONCAT('|',t0.STOFCY_0::TEXT))::TEXT, $1, $2), 1) > 0",oracle:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE REGEXP_LIKE(TO_CHAR(CONCAT(TO_CHAR(t0.ITMREF_0),CONCAT('|',TO_CHAR(t0.STOFCY_0)))),:v1,:v2)",tedious:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE CONVERT(VARCHAR(max),CONCAT(CONVERT(VARCHAR(max),t0.ITMREF_0),CONCAT('|',CONVERT(VARCHAR(max),t0.STOFCY_0)))) COLLATE Latin1_General_CI_AS LIKE @p0 escape '$'"},nodes_1.TestProductSite,{args:["SITEA","i"],driverArgs:{tedious:["%SITEA%"]}}),test("Filter by _id (query with _ne)",{_id:{_ne:"ART_TITRE|SITEA"}},T,{postgres:"SELECT  t0.ITMREF_0 AS \"T_0_ITMREF_0\", 'PLACEHOLDER' AS \"THIS_STANDALONE_PRODUCT\", t1.ITMDES1_0 AS \"T_1_ITMDES_1_0\", t1.ITMDES2_0 AS \"T_1_ITMDES_2_0\", t1.ITMDES3_0 AS \"T_1_ITMDES_3_0\", t2.ITMWEI_0 AS \"T_2_ITMWEI_0\", t2.ITMVOU_0 AS \"T_2_ITMVOU_0\", t0.STOFCY_0 AS \"T_0_STOFCY_0\", (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LOCMGTCOD_0\", (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LPNMGTCOD_0\", (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_PCKFLG_0\", t4.LEG_0 AS \"T_4_LEG_0\", (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS \"T_1_DES_1_AXX_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_1_DES_2_AXX_0\", (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS \"T_1_DES_3_AXX_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = t1.ITMREF_0::TEXT AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = t1.ITMREF_0::TEXT AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = t1.ITMREF_0::TEXT AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = t1.ITMREF_0::TEXT AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = t1.ITMREF_0::TEXT AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = t1.ITMREF_0::TEXT AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE ((t0.ITMREF_0 != $1) AND (t0.STOFCY_0 != $2))",oracle:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE ((t0.ITMREF_0 != :v1) AND (t0.STOFCY_0 != :v2))",tedious:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE ((t0.ITMREF_0 != @p0) AND (t0.STOFCY_0 != @p1))"},nodes_1.TestProductSite,{args:["ART_TITRE","SITEA"]}),test("Filter by _id (query with _gte)",{_id:{_gte:"ART_TITRE|SITEA"}},T,{postgres:"SELECT  t0.ITMREF_0 AS \"T_0_ITMREF_0\", 'PLACEHOLDER' AS \"THIS_STANDALONE_PRODUCT\", t1.ITMDES1_0 AS \"T_1_ITMDES_1_0\", t1.ITMDES2_0 AS \"T_1_ITMDES_2_0\", t1.ITMDES3_0 AS \"T_1_ITMDES_3_0\", t2.ITMWEI_0 AS \"T_2_ITMWEI_0\", t2.ITMVOU_0 AS \"T_2_ITMVOU_0\", t0.STOFCY_0 AS \"T_0_STOFCY_0\", (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LOCMGTCOD_0\", (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_LPNMGTCOD_0\", (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS \"T_0_PCKFLG_0\", t4.LEG_0 AS \"T_4_LEG_0\", (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS \"T_1_DES_1_AXX_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_1_DES_2_AXX_0\", (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS \"T_1_DES_3_AXX_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = t1.ITMREF_0::TEXT AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = t1.ITMREF_0::TEXT AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = t1.ITMREF_0::TEXT AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = t1.ITMREF_0::TEXT AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = t1.ITMREF_0::TEXT AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = t1.ITMREF_0::TEXT AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE ((t0.ITMREF_0 >= $1) AND (t0.STOFCY_0 >= $2))",oracle:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = TO_CHAR(t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE ((t0.ITMREF_0 >= :v1) AND (t0.STOFCY_0 >= :v2))",tedious:"SELECT  t0.ITMREF_0 AS T_0_ITMREF_0, 'PLACEHOLDER' AS THIS_STANDALONE_PRODUCT, t1.ITMDES1_0 AS T_1_ITMDES_1_0, t1.ITMDES2_0 AS T_1_ITMDES_2_0, t1.ITMDES3_0 AS T_1_ITMDES_3_0, t2.ITMWEI_0 AS T_2_ITMWEI_0, t2.ITMVOU_0 AS T_2_ITMVOU_0, t0.STOFCY_0 AS T_0_STOFCY_0, (CASE WHEN t0.LOCMGTCOD_0 = 2 THEN 1 WHEN t0.LOCMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LOCMGTCOD_0, (CASE WHEN t0.LPNMGTCOD_0 = 2 THEN 1 WHEN t0.LPNMGTCOD_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LPNMGTCOD_0, (CASE WHEN t0.PCKFLG_0 = 2 THEN 1 WHEN t0.PCKFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PCKFLG_0, t4.LEG_0 AS T_4_LEG_0, (CASE WHEN (t5.TEXTE_0 IS NOT NULL) THEN t5.TEXTE_0 ELSE t6.TEXTE_0 END) AS T_1_DES_1_AXX_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_1_DES_2_AXX_0, (CASE WHEN (t9.TEXTE_0 IS NOT NULL) THEN t9.TEXTE_0 ELSE t10.TEXTE_0 END) AS T_1_DES_3_AXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'ITMMASTER' AND t5.ZONE_0 = 'DES1AXX' AND t5.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t5.IDENT2_0 = ' ' AND t5.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t6 ON t6.CODFIC_0 = 'ITMMASTER' AND t6.ZONE_0 = 'DES1AXX' AND t6.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t6.IDENT2_0 = ' ' AND t6.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'ITMMASTER' AND t7.ZONE_0 = 'DES2AXX' AND t7.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t7.IDENT2_0 = ' ' AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'ITMMASTER' AND t8.ZONE_0 = 'DES2AXX' AND t8.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t8.IDENT2_0 = ' ' AND t8.LANGUE_0 = 'FRA' LEFT JOIN REPOSX3.ATEXTRA t9 ON t9.CODFIC_0 = 'ITMMASTER' AND t9.ZONE_0 = 'DES3AXX' AND t9.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t9.IDENT2_0 = ' ' AND t9.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t10 ON t10.CODFIC_0 = 'ITMMASTER' AND t10.ZONE_0 = 'DES3AXX' AND t10.IDENT1_0 = CONVERT(VARCHAR(max),t1.ITMREF_0) AND t10.IDENT2_0 = ' ' AND t10.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.ITMMASTER t2 ON t2.ITMREF_0 = t0.ITMREF_0 INNER JOIN REPOSX3.FACILITY t3 ON t3.FCY_0 = t0.STOFCY_0 INNER JOIN REPOSX3.COMPANY t4 ON t4.CPY_0 = t3.LEGCPY_0 WHERE ((t0.ITMREF_0 >= @p0) AND (t0.STOFCY_0 >= @p1))"},nodes_1.TestProductSite,{args:["ART_TITRE","SITEA"]})}),describe("Aggregates",()=>{it(`can aggregate - ${T}`,async()=>{const A={response:{locals:{config:{x3:{sql:{driver:T,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com",database:"fakeDatabase",password:"fakePassword"}}}}}};await xtrem_core_1.Test.withContext(A=>{const _=A.application.getFactoryByConstructor(nodes_1.TestProductSite),C=new sql_query_1.SqlQuery(A,_,{first:21,aggregate:{groups:[{path:["product","code"],groupedBy:"value"}],values:[{path:["stockSite"],operator:"distinctCount"}]},filters:[]},"REPOSX3").getSqlQuery().sql,E={postgres:'SELECT  COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = \' \' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS "T_0_STOFCY_0_DISTINCT_COUNT", t1.ITMREF_0 AS "T_1_ITMREF_0_VALUE" FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 WHERE 1=1 GROUP BY t1.ITMREF_0 ORDER BY "T_1_ITMREF_0_VALUE" ASC LIMIT 21',oracle:"SELECT  COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, t1.ITMREF_0 AS T_1_ITMREF_0_VALUE FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 WHERE 1=1 GROUP BY t1.ITMREF_0 ORDER BY T_1_ITMREF_0_VALUE ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY",tedious:"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, t1.ITMREF_0 AS T_1_ITMREF_0_VALUE FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 WHERE 1=1 GROUP BY t1.ITMREF_0 ORDER BY T_1_ITMREF_0_VALUE ASC"};chai_1.assert.equal(C.trim(),E[T])},{config:A})}),it(`can aggregate with order by- ${T}`,async()=>{const A={response:{locals:{config:{x3:{sql:{driver:T,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com",database:"fakeDatabase",password:"fakePassword"}}}}}};await xtrem_core_1.Test.withContext(A=>{const _=A.application.getFactoryByConstructor(nodes_1.TestProductSite),C=new sql_query_1.SqlQuery(A,_,{first:21,aggregate:{groups:[{path:["product","code"],groupedBy:"value"}],values:[{path:["stockSite"],operator:"distinctCount"}]},filters:[],orderBy:{product:{code:1}}},"REPOSX3").getSqlQuery().sql,E={postgres:'SELECT  COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = \' \' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS "T_0_STOFCY_0_DISTINCT_COUNT", t1.ITMREF_0 AS "T_1_ITMREF_0_VALUE" FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 WHERE 1=1 GROUP BY t1.ITMREF_0 ORDER BY "T_1_ITMREF_0" ASC LIMIT 21',oracle:"SELECT  COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, t1.ITMREF_0 AS T_1_ITMREF_0_VALUE FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 WHERE 1=1 GROUP BY t1.ITMREF_0 ORDER BY T_1_ITMREF_0_VALUE ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY",tedious:"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, t1.ITMREF_0 AS T_1_ITMREF_0_VALUE FROM REPOSX3.ITMFACILIT t0 INNER JOIN REPOSX3.ITMMASTER t1 ON t1.ITMREF_0 = t0.ITMREF_0 WHERE 1=1 GROUP BY t1.ITMREF_0 ORDER BY T_1_ITMREF_0_VALUE ASC"};chai_1.assert.equal(C.trim(),E[T])},{config:A})}),it(`can aggregate by _id - ${T}`,async()=>{const A={response:{locals:{config:{x3:{sql:{driver:T,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com",database:"fakeDatabase",password:"fakePassword"}}}}}};await xtrem_core_1.Test.withContext(A=>{const _=A.application.getFactoryByConstructor(nodes_1.TestProductSite),C=new sql_query_1.SqlQuery(A,_,{first:21,aggregate:{groups:[{path:["_id"],groupedBy:"value"}],values:[{path:["stockSite"],operator:"distinctCount"}]},filters:[]},"REPOSX3").getSqlQuery().sql,E={postgres:"SELECT  COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS \"T_0_STOFCY_0_DISTINCT_COUNT\", CONCAT(t0.ITMREF_0::TEXT,CONCAT('|',t0.STOFCY_0::TEXT)) AS \"T_0_ID_0_VALUE\" FROM REPOSX3.ITMFACILIT t0 WHERE 1=1 GROUP BY CONCAT(t0.ITMREF_0::TEXT,CONCAT('|',t0.STOFCY_0::TEXT)) ORDER BY \"T_0_ID_0_VALUE\" ASC LIMIT 21",oracle:"SELECT  COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, CONCAT(TO_CHAR(t0.ITMREF_0),CONCAT('|',TO_CHAR(t0.STOFCY_0))) AS T_0_ID_0_VALUE FROM REPOSX3.ITMFACILIT t0 WHERE 1=1 GROUP BY CONCAT(TO_CHAR(t0.ITMREF_0),CONCAT('|',TO_CHAR(t0.STOFCY_0))) ORDER BY T_0_ID_0_VALUE ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY",tedious:"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN (t0.STOFCY_0 = ' ' OR t0.STOFCY_0 IS NULL) THEN NULL ELSE t0.STOFCY_0 END)) AS T_0_STOFCY_0_DISTINCT_COUNT, CONCAT(CONVERT(VARCHAR(max),t0.ITMREF_0),CONCAT('|',CONVERT(VARCHAR(max),t0.STOFCY_0))) AS T_0_ID_0_VALUE FROM REPOSX3.ITMFACILIT t0 WHERE 1=1 GROUP BY CONCAT(CONVERT(VARCHAR(max),t0.ITMREF_0),CONCAT('|',CONVERT(VARCHAR(max),t0.STOFCY_0))) ORDER BY T_0_ID_0_VALUE ASC"};chai_1.assert.equal(C.trim(),E[T])},{config:A})}),it(`can aggregate with order by using composite reference- ${T}`,async()=>{const A={response:{locals:{config:{x3:{sql:{driver:T,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com",database:"fakeDatabase",password:"fakePassword"}}}}}};await xtrem_core_1.Test.withContext(A=>{const _=A.application.getFactoryByConstructor(document_1.TestDocument),C=new sql_query_1.SqlQuery(A,_,{first:21,aggregate:{groups:[{path:["parentCode"],groupedBy:"value"}],values:[{path:["parentDescription"],operator:"distinctCount"}]},filters:[],orderBy:{parentCode:1}},"REPOSX3").getSqlQuery().sql,E={postgres:"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS \"T_1_DES_0_DISTINCT_COUNT\", t1.COD_0 AS \"T_1_COD_0_VALUE\" FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t1.COD_0::TEXT,CONCAT('~',TO_CHAR(t1.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')::TEXT,CONCAT('~',t1.COD_0::TEXT)) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(t1.COD_0::TEXT,CONCAT('~',TO_CHAR(t1.DAT_0,'YYYYMMDD')::TEXT)) AND t3.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')::TEXT,CONCAT('~',t1.COD_0::TEXT)) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY t1.COD_0 ORDER BY \"T_1_COD_0\" ASC LIMIT 21",oracle:"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, t1.COD_0 AS T_1_COD_0_VALUE FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t3.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY t1.COD_0 ORDER BY T_1_COD_0_VALUE ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY",tedious:"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, t1.COD_0 AS T_1_COD_0_VALUE FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t1.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t1.DAT_0 DATE)),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t1.DAT_0 DATE),112)))) AND t3.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t1.DAT_0 DATE)),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY t1.COD_0 ORDER BY T_1_COD_0_VALUE ASC"};chai_1.assert.equal(C.trim(),E[T])},{config:A})}),it(`can aggregate with order by using values part- ${T}`,async()=>{const A={response:{locals:{config:{x3:{sql:{driver:T,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com",database:"fakeDatabase",password:"fakePassword"}}}}}};await xtrem_core_1.Test.withContext(A=>{const _=A.application.getFactoryByConstructor(document_1.TestDocument),C=new sql_query_1.SqlQuery(A,_,{first:21,aggregate:{groups:[{path:["parentCode"],groupedBy:"value"}],values:[{path:["parentDescription"],operator:"distinctCount"}]},filters:[],orderBy:{parentDescription:1}},"REPOSX3").getSqlQuery().sql,E={postgres:"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS \"T_1_DES_0_DISTINCT_COUNT\", t1.COD_0 AS \"T_1_COD_0_VALUE\" FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t1.COD_0::TEXT,CONCAT('~',TO_CHAR(t1.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')::TEXT,CONCAT('~',t1.COD_0::TEXT)) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(t1.COD_0::TEXT,CONCAT('~',TO_CHAR(t1.DAT_0,'YYYYMMDD')::TEXT)) AND t3.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')::TEXT,CONCAT('~',t1.COD_0::TEXT)) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY t1.COD_0 ORDER BY \"T_1_DES_0\" ASC LIMIT 21",oracle:"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, t1.COD_0 AS T_1_COD_0_VALUE FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t3.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY t1.COD_0 ORDER BY T_1_DES_0 ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY",tedious:"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, t1.COD_0 AS T_1_COD_0_VALUE FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t1.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t1.DAT_0 DATE)),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t1.DAT_0 DATE),112)))) AND t3.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t1.DAT_0 DATE)),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY t1.COD_0 ORDER BY T_1_DES_0 ASC"};chai_1.assert.equal(C.trim(),E[T])},{config:A})}),it(`can group by date - ${T}`,async()=>{const A={response:{locals:{config:{x3:{sql:{driver:T,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com",database:"fakeDatabase",password:"fakePassword"}}}}}};await xtrem_core_1.Test.withContext(A=>{const _=A.application.getFactoryByConstructor(document_1.TestDocument),testGroupBy=(C,E)=>{const N=new sql_query_1.SqlQuery(A,_,{first:21,aggregate:{groups:[{path:["date"],groupedBy:C}],values:[{path:["parentDescription"],operator:"distinctCount"}]},filters:[],orderBy:{parentDescription:1}},"REPOSX3").getSqlQuery().sql;chai_1.assert.strictEqual(N.trim(),E[T])};testGroupBy("year",{postgres:"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS \"T_1_DES_0_DISTINCT_COUNT\", TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY') AS \"T_0_DAT_0_YEAR\" FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t1.COD_0::TEXT,CONCAT('~',TO_CHAR(t1.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')::TEXT,CONCAT('~',t1.COD_0::TEXT)) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(t1.COD_0::TEXT,CONCAT('~',TO_CHAR(t1.DAT_0,'YYYYMMDD')::TEXT)) AND t3.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')::TEXT,CONCAT('~',t1.COD_0::TEXT)) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY') ORDER BY \"T_1_DES_0\" ASC LIMIT 21",oracle:"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY') AS T_0_DAT_0_YEAR FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t3.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY') ORDER BY T_1_DES_0 ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY",tedious:"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, FORMAT((CASE WHEN (CAST(t0.DAT_0 AS DATE) = CONVERT(DATE,'1753-01-01',20) OR CAST(t0.DAT_0 AS DATE) IS NULL) THEN NULL ELSE CAST(t0.DAT_0 AS DATE) END),'yyyy') AS T_0_DAT_0_YEAR FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t1.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t1.DAT_0 DATE)),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t1.DAT_0 DATE),112)))) AND t3.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t1.DAT_0 DATE)),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY FORMAT((CASE WHEN (CAST(t0.DAT_0 AS DATE) = CONVERT(DATE,'1753-01-01',20) OR CAST(t0.DAT_0 AS DATE) IS NULL) THEN NULL ELSE CAST(t0.DAT_0 AS DATE) END),'yyyy') ORDER BY T_1_DES_0 ASC"}),testGroupBy("month",{postgres:"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS \"T_1_DES_0_DISTINCT_COUNT\", TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY-MM') AS \"T_0_DAT_0_MONTH\" FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t1.COD_0::TEXT,CONCAT('~',TO_CHAR(t1.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')::TEXT,CONCAT('~',t1.COD_0::TEXT)) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(t1.COD_0::TEXT,CONCAT('~',TO_CHAR(t1.DAT_0,'YYYYMMDD')::TEXT)) AND t3.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')::TEXT,CONCAT('~',t1.COD_0::TEXT)) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY-MM') ORDER BY \"T_1_DES_0\" ASC LIMIT 21",oracle:"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY-MM') AS T_0_DAT_0_MONTH FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t3.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY-MM') ORDER BY T_1_DES_0 ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY",tedious:"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, FORMAT((CASE WHEN (CAST(t0.DAT_0 AS DATE) = CONVERT(DATE,'1753-01-01',20) OR CAST(t0.DAT_0 AS DATE) IS NULL) THEN NULL ELSE CAST(t0.DAT_0 AS DATE) END),'yyyy-MM') AS T_0_DAT_0_MONTH FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t1.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t1.DAT_0 DATE)),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t1.DAT_0 DATE),112)))) AND t3.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t1.DAT_0 DATE)),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY FORMAT((CASE WHEN (CAST(t0.DAT_0 AS DATE) = CONVERT(DATE,'1753-01-01',20) OR CAST(t0.DAT_0 AS DATE) IS NULL) THEN NULL ELSE CAST(t0.DAT_0 AS DATE) END),'yyyy-MM') ORDER BY T_1_DES_0 ASC"}),testGroupBy("day",{postgres:"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS \"T_1_DES_0_DISTINCT_COUNT\", TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY-MM-DD') AS \"T_0_DAT_0_DAY\" FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t1.COD_0::TEXT,CONCAT('~',TO_CHAR(t1.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')::TEXT,CONCAT('~',t1.COD_0::TEXT)) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(t1.COD_0::TEXT,CONCAT('~',TO_CHAR(t1.DAT_0,'YYYYMMDD')::TEXT)) AND t3.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')::TEXT,CONCAT('~',t1.COD_0::TEXT)) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY-MM-DD') ORDER BY \"T_1_DES_0\" ASC LIMIT 21",oracle:"SELECT  COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY-MM-DD') AS T_0_DAT_0_DAY FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(TO_CHAR(t1.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t1.DAT_0,'YYYYMMDD')))) AND t3.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t1.DAT_0),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY TO_CHAR((CASE WHEN (t0.DAT_0 = TO_DATE('1599-12-31','YYYY-MM-DD') OR t0.DAT_0 IS NULL) THEN NULL ELSE t0.DAT_0 END),'YYYY-MM-DD') ORDER BY T_1_DES_0 ASC NULLS FIRST FETCH NEXT 21 ROWS ONLY",tedious:"SELECT TOP 21 COUNT(DISTINCT (CASE WHEN ((CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) = ' ' OR (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) IS NULL) THEN NULL ELSE (CASE WHEN (t2.TEXTE_0 IS NOT NULL) THEN t2.TEXTE_0 ELSE t3.TEXTE_0 END) END)) AS T_1_DES_0_DISTINCT_COUNT, FORMAT((CASE WHEN (CAST(t0.DAT_0 AS DATE) = CONVERT(DATE,'1753-01-01',20) OR CAST(t0.DAT_0 AS DATE) IS NULL) THEN NULL ELSE CAST(t0.DAT_0 AS DATE) END),'yyyy-MM-dd') AS T_0_DAT_0_DAY FROM REPOSX3.TABDOC t0 INNER JOIN REPOSX3.TABDOC t1 ON t1.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t1.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t1.DAT_0 DATE)),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t2.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t3 ON t3.CODFIC_0 = 'TABLE' AND t3.ZONE_0 = 'DES' AND t3.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t1.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t1.DAT_0 DATE),112)))) AND t3.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t1.DAT_0 DATE)),'XXX'),t1.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t1.COD_0))) AND t3.LANGUE_0 = 'FRA' WHERE 1=1 GROUP BY FORMAT((CASE WHEN (CAST(t0.DAT_0 AS DATE) = CONVERT(DATE,'1753-01-01',20) OR CAST(t0.DAT_0 AS DATE) IS NULL) THEN NULL ELSE CAST(t0.DAT_0 AS DATE) END),'yyyy-MM-dd') ORDER BY T_1_DES_0 ASC"})},{config:A})}),it(`reject with order by a column not in group clause- ${T}`,async()=>{const A={response:{locals:{config:{x3:{sql:{driver:T,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com",database:"fakeDatabase",password:"fakePassword"}}}}}};await xtrem_core_1.Test.withContext(T=>{const A=T.application.getFactoryByConstructor(document_1.TestDocument),_=new sql_query_1.SqlQuery(T,A,{first:21,aggregate:{groups:[{path:["parentCode"],groupedBy:"value"}],values:[{path:["date"],operator:"distinctCount"}]},filters:[],orderBy:{parentDescription:1}},"REPOSX3");chai_1.assert.Throw(()=>_.getSqlQuery(),"parentDescription not contained in either an aggregate function or the GROUP BY clause")},{config:A})})}),describe("Service Options",()=>{test("Will only select columns of active service options",{},T,{postgres:"SELECT  t0.CODMET_0 AS \"T_0_CODMET_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_INTMET_0\", t0.PRFXTD_0 AS \"T_0_PRFXTD_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.AMETUTI t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'AMETUTI' AND t1.ZONE_0 = 'INTMET' AND t1.IDENT1_0 = t0.CODMET_0::TEXT AND t1.IDENT2_0 = ' ' AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'AMETUTI' AND t2.ZONE_0 = 'INTMET' AND t2.IDENT1_0 = t0.CODMET_0::TEXT AND t2.IDENT2_0 = ' ' AND t2.LANGUE_0 = 'FRA' WHERE 1=1",oracle:"SELECT  t0.CODMET_0 AS T_0_CODMET_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_INTMET_0, t0.PRFXTD_0 AS T_0_PRFXTD_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.AMETUTI t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'AMETUTI' AND t1.ZONE_0 = 'INTMET' AND t1.IDENT1_0 = TO_CHAR(t0.CODMET_0) AND t1.IDENT2_0 = ' ' AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'AMETUTI' AND t2.ZONE_0 = 'INTMET' AND t2.IDENT1_0 = TO_CHAR(t0.CODMET_0) AND t2.IDENT2_0 = ' ' AND t2.LANGUE_0 = 'FRA' WHERE 1=1",tedious:"SELECT  t0.CODMET_0 AS T_0_CODMET_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_INTMET_0, t0.PRFXTD_0 AS T_0_PRFXTD_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.AMETUTI t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'AMETUTI' AND t1.ZONE_0 = 'INTMET' AND t1.IDENT1_0 = CONVERT(VARCHAR(max),t0.CODMET_0) AND t1.IDENT2_0 = ' ' AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'AMETUTI' AND t2.ZONE_0 = 'INTMET' AND t2.IDENT1_0 = CONVERT(VARCHAR(max),t0.CODMET_0) AND t2.IDENT2_0 = ' ' AND t2.LANGUE_0 = 'FRA' WHERE 1=1"},test_syracuse_method_1.TestSyracusMethod)}),describe("Fallback joins",()=>{test("will generate correct query for node fallback join property - simulating a read",{code:"FOO",legislation:"FRA"},T,{postgres:'SELECT  t0.VACBPR_0 AS "T_0_VACBPR_0", t0.LEG_0 AS "T_0_LEG_0", t0.DESAXX_0 AS "T_0_DESAXX_0", t0.SHOAXX_0 AS "T_0_SHOAXX_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0" FROM REPOSX3.TABVACBPR t0 WHERE t0.VACBPR_0 = $1 AND ((CASE WHEN (t0.LEG_0 = \' \' OR t0.LEG_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t0.LEG_0 IN ($2)))  ORDER BY "T_0_LEG_0" DESC LIMIT 1',oracle:"SELECT  t0.VACBPR_0 AS T_0_VACBPR_0, t0.LEG_0 AS T_0_LEG_0, t0.DESAXX_0 AS T_0_DESAXX_0, t0.SHOAXX_0 AS T_0_SHOAXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABVACBPR t0 WHERE t0.VACBPR_0 = :v1 AND ((CASE WHEN (t0.LEG_0 = ' ' OR t0.LEG_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t0.LEG_0 IN (:v2)))  ORDER BY T_0_LEG_0 DESC NULLS LAST FETCH NEXT 1 ROWS ONLY",tedious:"SELECT TOP 1 t0.VACBPR_0 AS T_0_VACBPR_0, t0.LEG_0 AS T_0_LEG_0, t0.DESAXX_0 AS T_0_DESAXX_0, t0.SHOAXX_0 AS T_0_SHOAXX_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABVACBPR t0 WHERE t0.VACBPR_0 = @p0 AND ((CASE WHEN (t0.LEG_0 = ' ' OR t0.LEG_0 IS NULL) THEN 1 ELSE 0 END)=1 OR (t0.LEG_0 IN (@p1)))  ORDER BY T_0_LEG_0 DESC"},nodes_1.TestTaxRule,{singleResultRequest:true,args:["FOO","FRA"]}),test("will generate correct query for node fallback join property - simulating a query where fallback is on reference node but not included in reference join",{taxRule:{code:"FOO"}},T,{postgres:'SELECT  t0.BPCNUM_0 AS "T_0_BPCNUM_0", t0.BPCNAM_0 AS "T_0_BPCNAM_0", t0.BPCSHO_0 AS "T_0_BPCSHO_0", t0.BCGCOD_0 AS "T_0_BCGCOD_0", t0.BPCTYP_0 AS "T_0_BPCTYP_0", t0.BPCINV_0 AS "T_0_BPCINV_0", t0.BPCGRU_0 AS "T_0_BPCGRU_0", t0.BPCRSK_0 AS "T_0_BPCRSK_0", (CASE WHEN t0.BPCSTA_0 = 2 THEN 1 WHEN t0.BPCSTA_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BPCSTA_0", (CASE WHEN t0.PPTFLG_0 = 2 THEN 1 WHEN t0.PPTFLG_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_PPTFLG_0", t0.CUR_0 AS "T_0_CUR_0", t0.VACBPR_0 AS "T_0_VACBPR_0", t0.CDTISRDAT_0 AS "T_0_CDTISRDAT_0", (CASE WHEN t0.MTCFLG_0 = 2 THEN 1 WHEN t0.MTCFLG_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_MTCFLG_0", (CASE WHEN t0.LNDAUZ_0 = 2 THEN 1 WHEN t0.LNDAUZ_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_LNDAUZ_0", (CASE WHEN t0.OCNFLG_0 = 2 THEN 1 WHEN t0.OCNFLG_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_OCNFLG_0", (CASE WHEN t0.ORDCLE_0 = 2 THEN 1 WHEN t0.ORDCLE_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_ORDCLE_0", (CASE WHEN t0.ODL_0 = 2 THEN 1 WHEN t0.ODL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_ODL_0", t0.BUS_0 AS "T_0_BUS_0", t0.ORIPPT_0 AS "T_0_ORIPPT_0", t0.PITCDT_0 AS "T_0_PITCDT_0", t0.PITCPT_0 AS "T_0_PITCPT_0", t0.TOTPIT_0 AS "T_0_TOTPIT_0", t0.COTPITRQD_0 AS "T_0_COTPITRQD_0", t0.CNTFIRDAT_0 AS "T_0_CNTFIRDAT_0", t0.ORDFIRDAT_0 AS "T_0_ORDFIRDAT_0", t0.QUOLASDAT_0 AS "T_0_QUOLASDAT_0", t0.CNTLASDAT_0 AS "T_0_CNTLASDAT_0", t0.CNTNEXDAT_0 AS "T_0_CNTNEXDAT_0", (CASE WHEN t0.BELVATSUB_0 = 2 THEN 1 WHEN t0.BELVATSUB_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BELVATSUB_0", t0.BPCSNCDAT_0 AS "T_0_BPCSNCDAT_0", (CASE WHEN t0.ELECTINV_0 = 2 THEN 1 WHEN t0.ELECTINV_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_ELECTINV_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0", t1.VACBPR_0 AS "T_1_VACBPR_0" FROM REPOSX3.BPCUSTOMER t0 LEFT JOIN REPOSX3.TABVACBPR t1 ON t1.VACBPR_0 = t0.VACBPR_0 AND EXISTS(SELECT  * FROM REPOSX3.TABVACBPR r0 WHERE r0.VACBPR_0 = t0.VACBPR_0 AND t1.VACBPR_0 = r0.VACBPR_0 AND t1.LEG_0 = r0.LEG_0 ORDER BY r0.LEG_0 ASC LIMIT 1) WHERE t1.VACBPR_0 = $1  ORDER BY "T_1_VACBPR_0" ASC',oracle:"SELECT  t0.BPCNUM_0 AS T_0_BPCNUM_0, t0.BPCNAM_0 AS T_0_BPCNAM_0, t0.BPCSHO_0 AS T_0_BPCSHO_0, t0.BCGCOD_0 AS T_0_BCGCOD_0, t0.BPCTYP_0 AS T_0_BPCTYP_0, t0.BPCINV_0 AS T_0_BPCINV_0, t0.BPCGRU_0 AS T_0_BPCGRU_0, t0.BPCRSK_0 AS T_0_BPCRSK_0, (CASE WHEN t0.BPCSTA_0 = 2 THEN 1 WHEN t0.BPCSTA_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BPCSTA_0, (CASE WHEN t0.PPTFLG_0 = 2 THEN 1 WHEN t0.PPTFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PPTFLG_0, t0.CUR_0 AS T_0_CUR_0, t0.VACBPR_0 AS T_0_VACBPR_0, t0.CDTISRDAT_0 AS T_0_CDTISRDAT_0, (CASE WHEN t0.MTCFLG_0 = 2 THEN 1 WHEN t0.MTCFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_MTCFLG_0, (CASE WHEN t0.LNDAUZ_0 = 2 THEN 1 WHEN t0.LNDAUZ_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LNDAUZ_0, (CASE WHEN t0.OCNFLG_0 = 2 THEN 1 WHEN t0.OCNFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_OCNFLG_0, (CASE WHEN t0.ORDCLE_0 = 2 THEN 1 WHEN t0.ORDCLE_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ORDCLE_0, (CASE WHEN t0.ODL_0 = 2 THEN 1 WHEN t0.ODL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ODL_0, t0.BUS_0 AS T_0_BUS_0, t0.ORIPPT_0 AS T_0_ORIPPT_0, t0.PITCDT_0 AS T_0_PITCDT_0, t0.PITCPT_0 AS T_0_PITCPT_0, t0.TOTPIT_0 AS T_0_TOTPIT_0, t0.COTPITRQD_0 AS T_0_COTPITRQD_0, t0.CNTFIRDAT_0 AS T_0_CNTFIRDAT_0, t0.ORDFIRDAT_0 AS T_0_ORDFIRDAT_0, t0.QUOLASDAT_0 AS T_0_QUOLASDAT_0, t0.CNTLASDAT_0 AS T_0_CNTLASDAT_0, t0.CNTNEXDAT_0 AS T_0_CNTNEXDAT_0, (CASE WHEN t0.BELVATSUB_0 = 2 THEN 1 WHEN t0.BELVATSUB_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BELVATSUB_0, t0.BPCSNCDAT_0 AS T_0_BPCSNCDAT_0, (CASE WHEN t0.ELECTINV_0 = 2 THEN 1 WHEN t0.ELECTINV_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ELECTINV_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t1.VACBPR_0 AS T_1_VACBPR_0 FROM REPOSX3.BPCUSTOMER t0 LEFT JOIN REPOSX3.TABVACBPR t1 ON t1.VACBPR_0 = t0.VACBPR_0 AND EXISTS(SELECT  * FROM REPOSX3.TABVACBPR r0 WHERE r0.VACBPR_0 = t0.VACBPR_0 AND t1.VACBPR_0 = r0.VACBPR_0 AND t1.LEG_0 = r0.LEG_0 ORDER BY r0.LEG_0 ASC NULLS FIRST FETCH NEXT 1 ROWS ONLY) WHERE t1.VACBPR_0 = :v1  ORDER BY T_1_VACBPR_0 ASC NULLS FIRST",tedious:"SELECT  t0.BPCNUM_0 AS T_0_BPCNUM_0, t0.BPCNAM_0 AS T_0_BPCNAM_0, t0.BPCSHO_0 AS T_0_BPCSHO_0, t0.BCGCOD_0 AS T_0_BCGCOD_0, t0.BPCTYP_0 AS T_0_BPCTYP_0, t0.BPCINV_0 AS T_0_BPCINV_0, t0.BPCGRU_0 AS T_0_BPCGRU_0, t0.BPCRSK_0 AS T_0_BPCRSK_0, (CASE WHEN t0.BPCSTA_0 = 2 THEN 1 WHEN t0.BPCSTA_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BPCSTA_0, (CASE WHEN t0.PPTFLG_0 = 2 THEN 1 WHEN t0.PPTFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_PPTFLG_0, t0.CUR_0 AS T_0_CUR_0, t0.VACBPR_0 AS T_0_VACBPR_0, CAST(t0.CDTISRDAT_0 AS DATE) AS T_0_CDTISRDAT_0, (CASE WHEN t0.MTCFLG_0 = 2 THEN 1 WHEN t0.MTCFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_MTCFLG_0, (CASE WHEN t0.LNDAUZ_0 = 2 THEN 1 WHEN t0.LNDAUZ_0 IS NULL THEN NULL ELSE 0 END) AS T_0_LNDAUZ_0, (CASE WHEN t0.OCNFLG_0 = 2 THEN 1 WHEN t0.OCNFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_OCNFLG_0, (CASE WHEN t0.ORDCLE_0 = 2 THEN 1 WHEN t0.ORDCLE_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ORDCLE_0, (CASE WHEN t0.ODL_0 = 2 THEN 1 WHEN t0.ODL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ODL_0, t0.BUS_0 AS T_0_BUS_0, t0.ORIPPT_0 AS T_0_ORIPPT_0, t0.PITCDT_0 AS T_0_PITCDT_0, t0.PITCPT_0 AS T_0_PITCPT_0, t0.TOTPIT_0 AS T_0_TOTPIT_0, t0.COTPITRQD_0 AS T_0_COTPITRQD_0, CAST(t0.CNTFIRDAT_0 AS DATE) AS T_0_CNTFIRDAT_0, CAST(t0.ORDFIRDAT_0 AS DATE) AS T_0_ORDFIRDAT_0, CAST(t0.QUOLASDAT_0 AS DATE) AS T_0_QUOLASDAT_0, CAST(t0.CNTLASDAT_0 AS DATE) AS T_0_CNTLASDAT_0, CAST(t0.CNTNEXDAT_0 AS DATE) AS T_0_CNTNEXDAT_0, (CASE WHEN t0.BELVATSUB_0 = 2 THEN 1 WHEN t0.BELVATSUB_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BELVATSUB_0, CAST(t0.BPCSNCDAT_0 AS DATE) AS T_0_BPCSNCDAT_0, (CASE WHEN t0.ELECTINV_0 = 2 THEN 1 WHEN t0.ELECTINV_0 IS NULL THEN NULL ELSE 0 END) AS T_0_ELECTINV_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t1.VACBPR_0 AS T_1_VACBPR_0 FROM REPOSX3.BPCUSTOMER t0 LEFT JOIN REPOSX3.TABVACBPR t1 ON t1.VACBPR_0 = t0.VACBPR_0 AND EXISTS(SELECT TOP 1 * FROM REPOSX3.TABVACBPR r0 WHERE r0.VACBPR_0 = t0.VACBPR_0 AND t1.VACBPR_0 = r0.VACBPR_0 AND t1.LEG_0 = r0.LEG_0 ORDER BY r0.LEG_0 ASC ) WHERE t1.VACBPR_0 = @p0  ORDER BY T_1_VACBPR_0 ASC"},nodes_1.TestCustomer,{orderBy:{taxRule:{code:1}},args:["FOO"]}),test("will generate correct query for node fallback join property - simulating a query where fallback is on reference node and included in reference join (with multi-level join)",{taxRule:{code:"FOO"}},T,{postgres:'SELECT  t0.POHNUM_0 AS "T_0_POHNUM_0", t0.POHFCY_0 AS "T_0_POHFCY_0", t0.ORDREF_0 AS "T_0_ORDREF_0", t0.BPSNUM_0 AS "T_0_BPSNUM_0", (CASE WHEN t0.CLEFLG_0 = 2 THEN 1 WHEN t0.CLEFLG_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_CLEFLG_0", t0.RCPFCY_0 AS "T_0_RCPFCY_0", (CASE WHEN t0.BETFCY_0 = 2 THEN 1 WHEN t0.BETFCY_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BETFCY_0", t0.VACBPR_0 AS "T_0_VACBPR_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0", t1.VACBPR_0 AS "T_1_VACBPR_0" FROM REPOSX3.PORDER t0 INNER JOIN REPOSX3.FACILITY t2 ON t2.FCY_0 = t0.POHFCY_0 INNER JOIN REPOSX3.COMPANY t3 ON t3.CPY_0 = t2.LEGCPY_0 INNER JOIN REPOSX3.ATABDIV t4 ON t4.NUMTAB_0 = $1::INT8 AND t4.CODE_0 = t3.LEG_0 LEFT JOIN REPOSX3.TABVACBPR t1 ON t1.VACBPR_0 = t0.VACBPR_0 AND EXISTS(SELECT  * FROM REPOSX3.TABVACBPR r0 WHERE r0.VACBPR_0 = t0.VACBPR_0 AND (r0.LEG_0 = \' \' OR r0.LEG_0 = t4.CODE_0) AND t1.VACBPR_0 = r0.VACBPR_0 AND t1.LEG_0 = r0.LEG_0 ORDER BY r0.LEG_0 DESC LIMIT 1) WHERE t1.VACBPR_0 = $2  ORDER BY "T_1_VACBPR_0" ASC',oracle:"SELECT  t0.POHNUM_0 AS T_0_POHNUM_0, t0.POHFCY_0 AS T_0_POHFCY_0, t0.ORDREF_0 AS T_0_ORDREF_0, t0.BPSNUM_0 AS T_0_BPSNUM_0, (CASE WHEN t0.CLEFLG_0 = 2 THEN 1 WHEN t0.CLEFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_CLEFLG_0, t0.RCPFCY_0 AS T_0_RCPFCY_0, (CASE WHEN t0.BETFCY_0 = 2 THEN 1 WHEN t0.BETFCY_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BETFCY_0, t0.VACBPR_0 AS T_0_VACBPR_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t1.VACBPR_0 AS T_1_VACBPR_0 FROM REPOSX3.PORDER t0 INNER JOIN REPOSX3.FACILITY t2 ON t2.FCY_0 = t0.POHFCY_0 INNER JOIN REPOSX3.COMPANY t3 ON t3.CPY_0 = t2.LEGCPY_0 INNER JOIN REPOSX3.ATABDIV t4 ON t4.NUMTAB_0 = :v1 AND t4.CODE_0 = t3.LEG_0 LEFT JOIN REPOSX3.TABVACBPR t1 ON t1.VACBPR_0 = t0.VACBPR_0 AND EXISTS(SELECT  * FROM REPOSX3.TABVACBPR r0 WHERE r0.VACBPR_0 = t0.VACBPR_0 AND (r0.LEG_0 = ' ' OR r0.LEG_0 = t4.CODE_0) AND t1.VACBPR_0 = r0.VACBPR_0 AND t1.LEG_0 = r0.LEG_0 ORDER BY r0.LEG_0 DESC NULLS LAST FETCH NEXT 1 ROWS ONLY) WHERE t1.VACBPR_0 = :v2  ORDER BY T_1_VACBPR_0 ASC NULLS FIRST",tedious:"SELECT  t0.POHNUM_0 AS T_0_POHNUM_0, t0.POHFCY_0 AS T_0_POHFCY_0, t0.ORDREF_0 AS T_0_ORDREF_0, t0.BPSNUM_0 AS T_0_BPSNUM_0, (CASE WHEN t0.CLEFLG_0 = 2 THEN 1 WHEN t0.CLEFLG_0 IS NULL THEN NULL ELSE 0 END) AS T_0_CLEFLG_0, t0.RCPFCY_0 AS T_0_RCPFCY_0, (CASE WHEN t0.BETFCY_0 = 2 THEN 1 WHEN t0.BETFCY_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BETFCY_0, t0.VACBPR_0 AS T_0_VACBPR_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, t1.VACBPR_0 AS T_1_VACBPR_0 FROM REPOSX3.PORDER t0 INNER JOIN REPOSX3.FACILITY t2 ON t2.FCY_0 = t0.POHFCY_0 INNER JOIN REPOSX3.COMPANY t3 ON t3.CPY_0 = t2.LEGCPY_0 INNER JOIN REPOSX3.ATABDIV t4 ON t4.NUMTAB_0 = @p0 AND t4.CODE_0 = t3.LEG_0 LEFT JOIN REPOSX3.TABVACBPR t1 ON t1.VACBPR_0 = t0.VACBPR_0 AND EXISTS(SELECT TOP 1 * FROM REPOSX3.TABVACBPR r0 WHERE r0.VACBPR_0 = t0.VACBPR_0 AND (r0.LEG_0 = ' ' OR r0.LEG_0 = t4.CODE_0) AND t1.VACBPR_0 = r0.VACBPR_0 AND t1.LEG_0 = r0.LEG_0 ORDER BY r0.LEG_0 DESC ) WHERE t1.VACBPR_0 = @p1  ORDER BY T_1_VACBPR_0 ASC"},nodes_1.TestPurchaseOrder,{orderBy:{taxRule:{code:1}},args:[909,"FOO"]})}),describe("Selector queries",()=>{test("select when selector is true",{},T,{postgres:'SELECT  t0.ID_0::TEXT AS "T_0__ID_0" FROM REPOSX3.TESTDAT t0 WHERE 1=1',oracle:"SELECT  TO_CHAR(t0.ID_0) AS T_0__ID_0 FROM REPOSX3.TESTDAT t0 WHERE 1=1",tedious:"SELECT  CONVERT(VARCHAR(max),t0.ID_0) AS T_0__ID_0 FROM REPOSX3.TESTDAT t0 WHERE 1=1"},nodes_1.TestDatatypes,{selector:true}),test("select when selector has simple properties",{},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS "T_0_BOOVAL_0" FROM REPOSX3.TESTDAT t0 WHERE 1=1',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0 FROM REPOSX3.TESTDAT t0 WHERE 1=1",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, (CASE WHEN t0.BOOVAL_0 = 2 THEN 1 WHEN t0.BOOVAL_0 IS NULL THEN NULL ELSE 0 END) AS T_0_BOOVAL_0 FROM REPOSX3.TESTDAT t0 WHERE 1=1"},nodes_1.TestDatatypes,{selector:{id:true,booleanVal:true}}),test("select when selector has complex properties",{},T,{postgres:'SELECT  t0.COD_0 AS "T_0_COD_0", t0.REF_0 AS "T_0_REF_0", t1.COD_0 AS "T_1_COD_0" FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REF_0 AND t1.DES3AEX_0 = \' \' WHERE 1=1',oracle:"SELECT  t0.COD_0 AS T_0_COD_0, t0.REF_0 AS T_0_REF_0, t1.COD_0 AS T_1_COD_0 FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REF_0 AND t1.DES3AEX_0 = ' ' WHERE 1=1",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, t0.REF_0 AS T_0_REF_0, t1.COD_0 AS T_1_COD_0 FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REF_0 AND t1.DES3AEX_0 = ' ' WHERE 1=1"},nodes_1.TestReferencing,{selector:{code:true,reference:{code:true}}}),test("select denormalized",{},T,{postgres:'SELECT  t0.ID_0 AS "T_0_ID_0", CONCAT(t0.ID_0::TEXT,CONCAT(\'|\',\'1\')) AS "T_0__ID_0", CONCAT(t0.ID_0::TEXT,CONCAT(\'|\',\'2\')) AS "T_0__ID_1", CONCAT(t0.ID_0::TEXT,CONCAT(\'|\',\'3\')) AS "T_0__ID_2", CONCAT(t0.ID_0::TEXT,CONCAT(\'|\',\'4\')) AS "T_0__ID_3", CONCAT(t0.ID_0::TEXT,CONCAT(\'|\',\'5\')) AS "T_0__ID_4", t0.DIM_0 AS "T_0_DIM_0", t0.DIM_1 AS "T_0_DIM_1", t0.DIM_2 AS "T_0_DIM_2", t0.DIM_3 AS "T_0_DIM_3", t0.DIM_4 AS "T_0_DIM_4", 1 AS "T_0_DENORMALIZED_INDEX_0", 2 AS "T_0_DENORMALIZED_INDEX_1", 3 AS "T_0_DENORMALIZED_INDEX_2", 4 AS "T_0_DENORMALIZED_INDEX_3", 5 AS "T_0_DENORMALIZED_INDEX_4" FROM REPOSX3.DENORMALIZEDPARENT t0 WHERE 1=1  ORDER BY "T_0_ID_0" ASC',oracle:"SELECT  t0.ID_0 AS T_0_ID_0, CONCAT(TO_CHAR(t0.ID_0),CONCAT('|','1')) AS T_0__ID_0, CONCAT(TO_CHAR(t0.ID_0),CONCAT('|','2')) AS T_0__ID_1, CONCAT(TO_CHAR(t0.ID_0),CONCAT('|','3')) AS T_0__ID_2, CONCAT(TO_CHAR(t0.ID_0),CONCAT('|','4')) AS T_0__ID_3, CONCAT(TO_CHAR(t0.ID_0),CONCAT('|','5')) AS T_0__ID_4, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, 1 AS T_0_DENORMALIZED_INDEX_0, 2 AS T_0_DENORMALIZED_INDEX_1, 3 AS T_0_DENORMALIZED_INDEX_2, 4 AS T_0_DENORMALIZED_INDEX_3, 5 AS T_0_DENORMALIZED_INDEX_4 FROM REPOSX3.DENORMALIZEDPARENT t0 WHERE 1=1  ORDER BY T_0_ID_0 ASC NULLS FIRST",tedious:"SELECT  t0.ID_0 AS T_0_ID_0, CONCAT(CONVERT(VARCHAR(max),t0.ID_0),CONCAT('|','1')) AS T_0__ID_0, CONCAT(CONVERT(VARCHAR(max),t0.ID_0),CONCAT('|','2')) AS T_0__ID_1, CONCAT(CONVERT(VARCHAR(max),t0.ID_0),CONCAT('|','3')) AS T_0__ID_2, CONCAT(CONVERT(VARCHAR(max),t0.ID_0),CONCAT('|','4')) AS T_0__ID_3, CONCAT(CONVERT(VARCHAR(max),t0.ID_0),CONCAT('|','5')) AS T_0__ID_4, t0.DIM_0 AS T_0_DIM_0, t0.DIM_1 AS T_0_DIM_1, t0.DIM_2 AS T_0_DIM_2, t0.DIM_3 AS T_0_DIM_3, t0.DIM_4 AS T_0_DIM_4, 1 AS T_0_DENORMALIZED_INDEX_0, 2 AS T_0_DENORMALIZED_INDEX_1, 3 AS T_0_DENORMALIZED_INDEX_2, 4 AS T_0_DENORMALIZED_INDEX_3, 5 AS T_0_DENORMALIZED_INDEX_4 FROM REPOSX3.DENORMALIZEDPARENT t0 WHERE 1=1  ORDER BY T_0_ID_0 ASC"},nodes_1.TestDenormalized,{selector:{_id:true,id:true,denormalized:true,denormalizedIndex:true}})}),describe("can filter with date functions",()=>{test("date.year",{date:{year:2018}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE date_part('year', t0.DAT_0) = $1::INT8",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE EXTRACT(YEAR FROM t0.DAT_0) = :v1",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEPART(yy FROM CAST(t0.DAT_0 AS DATE)) = @p0"},document_1.TestDocument,{args:[2018]}),test("date.month",{date:{month:4}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE date_part('month', t0.DAT_0) = $1::INT8",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE EXTRACT(MONTH FROM t0.DAT_0) = :v1",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEPART(mm FROM CAST(t0.DAT_0 AS DATE)) = @p0"},document_1.TestDocument,{args:[4]}),test("date.day",{date:{day:15}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE date_part('day', t0.DAT_0) = $1::INT8",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE EXTRACT(DAY FROM t0.DAT_0) = :v1",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEPART(dd FROM CAST(t0.DAT_0 AS DATE)) = @p0"},document_1.TestDocument,{args:[15]}),test("date.week",{date:{week:24}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE date_part('week', t0.DAT_0) = $1::INT8",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE TO_NUMBER(TO_CHAR(t0.DAT_0, 'WW')) = :v1",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEPART(isowk FROM CAST(t0.DAT_0 AS DATE)) = @p0"},document_1.TestDocument,{args:[24]}),test("date.weekDay",{date:{weekDay:1}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE date_part('dow', t0.DAT_0) = $1::INT8",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (CASE TO_CHAR(t0.DAT_0,'fmDY','nls_date_language=English') WHEN 'SUN' THEN 0 WHEN 'MON' THEN 1 WHEN 'TUE' THEN 2 WHEN 'WED' THEN 3 WHEN 'THU' THEN 4 WHEN 'FRI' THEN 5 WHEN 'SAT' THEN 6 END) = :v1",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((DATEPART(dw FROM CAST(t0.DAT_0 AS DATE)) + @@DATEFIRST + 6) % 7 ) = @p0"},document_1.TestDocument,{args:[1]}),test("date.yearDay",{date:{yearDay:46}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE date_part('doy', t0.DAT_0) = $1::INT8",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE TO_NUMBER(TO_CHAR(t0.DAT_0, 'DDD')) = :v1",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEPART(dy FROM CAST(t0.DAT_0 AS DATE)) = @p0"},document_1.TestDocument,{args:[46]}),test("date.value",{date:{value:20180215}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('year', t0.DAT_0) * 10000 + date_part('month', t0.DAT_0) * 100 + date_part('day', t0.DAT_0)) = $1::INT8",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(YEAR FROM t0.DAT_0) * 10000 + EXTRACT(MONTH FROM t0.DAT_0) * 100 + EXTRACT(DAY FROM t0.DAT_0)) = :v1",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(yy FROM CAST(t0.DAT_0 AS DATE)) * 10000 + DATEPART(mm FROM CAST(t0.DAT_0 AS DATE)) * 100 + DATEPART(dd FROM CAST(t0.DAT_0 AS DATE))) = @p0"},document_1.TestDocument,{args:[20180215]}),test("date.epoch",{date:{epoch:1518652800}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE date_part('epoch', t0.DAT_0) = $1::INT8",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 - TO_DATE('1970-01-01','YYYY-MM-DD')) * 86400) = :v1",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE DATEDIFF(SECOND, '1970-01-01', CAST(t0.DAT_0 AS DATE)) = @p0"},document_1.TestDocument,{args:[1518652800]})}),describe("can filter with date functions using _fn",()=>{test("date._fn.year",{_fn:"this.date.year === 2018"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('year', t0.DAT_0) = $1::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(YEAR FROM t0.DAT_0) = :v1)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(yy FROM CAST(t0.DAT_0 AS DATE)) = @p0)"},document_1.TestDocument,{args:[2018]}),test("date._fn.month",{_fn:"this.date.month === 4"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('month', t0.DAT_0) = $1::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(MONTH FROM t0.DAT_0) = :v1)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(mm FROM CAST(t0.DAT_0 AS DATE)) = @p0)"},document_1.TestDocument,{args:[4]}),test("date._fn.day",{_fn:"this.date.day === 15"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('day', t0.DAT_0) = $1::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(DAY FROM t0.DAT_0) = :v1)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(dd FROM CAST(t0.DAT_0 AS DATE)) = @p0)"},document_1.TestDocument,{args:[15]}),test("date._fn.week",{_fn:"this.date.week === 24"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('week', t0.DAT_0) = $1::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TO_NUMBER(TO_CHAR(t0.DAT_0, 'WW')) = :v1)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(isowk FROM CAST(t0.DAT_0 AS DATE)) = @p0)"},document_1.TestDocument,{args:[24]}),test("date._fn.weekDay",{_fn:"this.date.weekDay === 1"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('dow', t0.DAT_0) = $1::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((CASE TO_CHAR(t0.DAT_0,'fmDY','nls_date_language=English') WHEN 'SUN' THEN 0 WHEN 'MON' THEN 1 WHEN 'TUE' THEN 2 WHEN 'WED' THEN 3 WHEN 'THU' THEN 4 WHEN 'FRI' THEN 5 WHEN 'SAT' THEN 6 END) = :v1)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (((DATEPART(dw FROM CAST(t0.DAT_0 AS DATE)) + @@DATEFIRST + 6) % 7 ) = @p0)"},document_1.TestDocument,{args:[1]}),test("date._fn.yearDay",{_fn:"this.date.yearDay === 46"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('doy', t0.DAT_0) = $1::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TO_NUMBER(TO_CHAR(t0.DAT_0, 'DDD')) = :v1)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(dy FROM CAST(t0.DAT_0 AS DATE)) = @p0)"},document_1.TestDocument,{args:[46]}),test("date._fn.value",{_fn:"this.date.value === 20180215"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((date_part('year', t0.DAT_0) * 10000 + date_part('month', t0.DAT_0) * 100 + date_part('day', t0.DAT_0)) = $1::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((EXTRACT(YEAR FROM t0.DAT_0) * 10000 + EXTRACT(MONTH FROM t0.DAT_0) * 100 + EXTRACT(DAY FROM t0.DAT_0)) = :v1)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((DATEPART(yy FROM CAST(t0.DAT_0 AS DATE)) * 10000 + DATEPART(mm FROM CAST(t0.DAT_0 AS DATE)) * 100 + DATEPART(dd FROM CAST(t0.DAT_0 AS DATE))) = @p0)"},document_1.TestDocument,{args:[20180215]}),test("date._fn.epoch",{_fn:"this.date.epoch === 1518652800"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('epoch', t0.DAT_0) = $1::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (((t0.DAT_0 - TO_DATE('1970-01-01','YYYY-MM-DD')) * 86400) = :v1)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEDIFF(SECOND, '1970-01-01', CAST(t0.DAT_0 AS DATE)) = @p0)"},document_1.TestDocument,{args:[1518652800]})}),describe("can filter date methods with _fn",()=>{test("date._fn.compare && date._fn.parse",{_fn:'this.date.compare(date.parse("2018-01-15")) < 0'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 - $1::DATE) < $2::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 - TO_DATE(:v1,'YYYY-MM-DD')) < :v2)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEDIFF(day, CAST(@p0 AS DATE), CAST(t0.DAT_0 AS DATE)) < @p1)"},document_1.TestDocument,{args:["2018-01-15",0]}),test("date._fn.compare && date._fn.parse multi-level",{_fn:'this.parentDocument.date.compare(date.parse("2018-01-15")) < 0'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((t3.DAT_0 - $1::DATE) < $2::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t3.DAT_0 - TO_DATE(:v1,'YYYY-MM-DD')) < :v2)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEDIFF(day, CAST(@p0 AS DATE), CAST(t3.DAT_0 AS DATE)) < @p1)"},document_1.TestDocument,{args:["2018-01-15",0]}),test("date._fn.equals && date._fn.parse",{_fn:'this.date.equals(date.parse("2018-01-15"))'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (t0.DAT_0 = $1::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (t0.DAT_0 = TO_DATE(:v1,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (CAST(t0.DAT_0 AS DATE) = CAST(@p0 AS DATE))"},document_1.TestDocument,{args:["2018-01-15"]}),test("date._fn.equals && date._fn.parse multi-level",{_fn:'this.parentDocument.date.equals(date.parse("2018-01-15"))'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (t3.DAT_0 = $1::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (t3.DAT_0 = TO_DATE(:v1,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (CAST(t3.DAT_0 AS DATE) = CAST(@p0 AS DATE))"},document_1.TestDocument,{args:["2018-01-15"]}),test("date._fn.isBetween && date._fn.parse multi-level",{_fn:'this.date.isBetween(date.parse("2018-01-15"), date.parse("2018-03-15"))'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (t0.DAT_0 BETWEEN $1::DATE AND  $2::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (t0.DAT_0 BETWEEN TO_DATE(:v1,'YYYY-MM-DD') AND  TO_DATE(:v2,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (CAST(t0.DAT_0 AS DATE) BETWEEN CAST(@p0 AS DATE) AND  CAST(@p1 AS DATE))"},document_1.TestDocument,{args:["2018-01-15","2018-03-15"]}),test("date._fn.addYears",{_fn:'this.date.addYears(1) === date.parse("2018-05-15")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 + ($1::INT8::INT4 || ' ' || 'year')::interval)::DATE = $2::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (ADD_MONTHS(t0.DAT_0, :v1 * 12) = TO_DATE(:v2,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(year, @p0, CAST(t0.DAT_0 AS DATE)) = CAST(@p1 AS DATE))"},document_1.TestDocument,{args:[1,"2018-05-15"]}),test("date._fn.addYears -1",{_fn:'this.date.addYears(-1) === date.parse("2018-05-15")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 + ((- $1::INT8::INT8)::INT4 || ' ' || 'year')::interval)::DATE = $2::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (ADD_MONTHS(t0.DAT_0, (- CAST(:v1 AS INTEGER)) * 12) = TO_DATE(:v2,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(year, (- CAST(@p0 AS INTEGER)), CAST(t0.DAT_0 AS DATE)) = CAST(@p1 AS DATE))"},document_1.TestDocument,{args:[1,"2018-05-15"]}),test("date._fn.addMonths",{_fn:'this.date.addMonths(4) === date.parse("2018-05-15")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 + ($1::INT8::INT4 || ' ' || 'month')::interval)::DATE = $2::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (ADD_MONTHS(t0.DAT_0, :v1) = TO_DATE(:v2,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(month, @p0, CAST(t0.DAT_0 AS DATE)) = CAST(@p1 AS DATE))"},document_1.TestDocument,{args:[4,"2018-05-15"]}),test("date._fn.addDays",{_fn:'this.date.addDays(3) === date.parse("2018-05-15")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 + $1::INT8::INT4)::DATE = $2::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 + :v1) = TO_DATE(:v2,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(day, @p0, CAST(t0.DAT_0 AS DATE)) = CAST(@p1 AS DATE))"},document_1.TestDocument,{args:[3,"2018-05-15"]}),test("date._fn.addWeeks",{_fn:'this.date.addWeeks(4) === date.parse("2018-05-15")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0 + ($1::INT8::INT4 || ' ' || 'week')::interval)::DATE = $2::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((t0.DAT_0+(:v1*7)) = TO_DATE(:v2,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(week, @p0, CAST(t0.DAT_0 AS DATE)) = CAST(@p1 AS DATE))"},document_1.TestDocument,{args:[4,"2018-05-15"]}),test("date._fn.addWeeks.addDays",{_fn:'this.date.addWeeks(4).addDays(1) === date.parse("2018-05-15")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (((t0.DAT_0 + ($1::INT8::INT4 || ' ' || 'week')::interval)::DATE + $2::INT8::INT4)::DATE = $3::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (((t0.DAT_0+(:v1*7)) + :v2) = TO_DATE(:v3,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(day, @p1, DATEADD(week, @p0, CAST(t0.DAT_0 AS DATE))) = CAST(@p2 AS DATE))"},document_1.TestDocument,{args:[4,1,"2018-05-15"]}),test("date._fn.isLeapYear",{_fn:"this.date.isLeapYear()"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('day', make_date(date_part('year', t0.DAT_0)::int, 3, 1) - '1 day'::interval) = 29)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (ADD_MONTHS(TRUNC(t0.DAT_0,'YEAR'),12)-TRUNC(t0.DAT_0,'YEAR')=366)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((DATEPART(yy FROM CAST(t0.DAT_0 AS DATE)) % 4 = 0 AND DATEPART(yy FROM CAST(t0.DAT_0 AS DATE)) % 100 <> 0) OR DATEPART(yy FROM CAST(t0.DAT_0 AS DATE)) % 400 = 0)"},document_1.TestDocument),test("date._fn.weekDay",{_fn:"this.date.weekDay===0"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('dow', t0.DAT_0) = $1::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((CASE TO_CHAR(t0.DAT_0,'fmDY','nls_date_language=English') WHEN 'SUN' THEN 0 WHEN 'MON' THEN 1 WHEN 'TUE' THEN 2 WHEN 'WED' THEN 3 WHEN 'THU' THEN 4 WHEN 'FRI' THEN 5 WHEN 'SAT' THEN 6 END) = :v1)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (((DATEPART(dw FROM CAST(t0.DAT_0 AS DATE)) + @@DATEFIRST + 6) % 7 ) = @p0)"},document_1.TestDocument,{args:[0]}),test("date._fn.isWorkDay",{_fn:"this.date.isWorkDay()"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('dow', t0.DAT_0) NOT IN (0, 6))",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((CASE TO_CHAR(t0.DAT_0,'fmDY','nls_date_language=English') WHEN 'SUN' THEN 0 WHEN 'MON' THEN 1 WHEN 'TUE' THEN 2 WHEN 'WED' THEN 3 WHEN 'THU' THEN 4 WHEN 'FRI' THEN 5 WHEN 'SAT' THEN 6 END) NOT IN (0, 6))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (((DATEPART(dw FROM CAST(t0.DAT_0 AS DATE)) + @@DATEFIRST + 6) % 7 ) NOT IN (0, 6))"},document_1.TestDocument),test("date._fn.daysInMonth",{_fn:"this.date.daysInMonth() === 30"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((date_part('day', date_trunc('month', t0.DAT_0) + interval '1 month - 1 day')) = $1::INT8)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((1+TRUNC(LAST_DAY(t0.DAT_0))-TRUNC(t0.DAT_0,'MM')) = :v1)",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DAY(DATEADD(DD,-1,DATEADD(MM,DATEDIFF(MM,-1,CAST(t0.DAT_0 AS DATE)),0))) = @p0)"},document_1.TestDocument,{args:[30]}),test("date._fn.begOfYear",{_fn:'this.date.begOfYear() === date.parse("2018-01-01")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_trunc('year', t0.DAT_0)::DATE = $1::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TRUNC(t0.DAT_0,'YEAR') = TO_DATE(:v1,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(YEAR, DATEDIFF(YEAR, 0, CAST(t0.DAT_0 AS DATE)), 0) = CAST(@p0 AS DATE))"},document_1.TestDocument,{args:["2018-01-01"]}),test("date._fn.begOfQuarter",{_fn:'this.date.begOfQuarter() === date.parse("2018-01-01")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_trunc('quarter', t0.DAT_0)::DATE = $1::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TRUNC(t0.DAT_0,'Q') = TO_DATE(:v1,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(QUARTER, DATEDIFF(QUARTER, 0, CAST(t0.DAT_0 AS DATE)), 0) = CAST(@p0 AS DATE))"},document_1.TestDocument,{args:["2018-01-01"]}),test("date._fn.begOfMonth",{_fn:'this.date.begOfMonth() === date.parse("2018-01-01")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_trunc('month', t0.DAT_0)::DATE = $1::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TRUNC(t0.DAT_0,'MONTH') = TO_DATE(:v1,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(MONTH, DATEDIFF(MONTH, 0, CAST(t0.DAT_0 AS DATE)), 0) = CAST(@p0 AS DATE))"},document_1.TestDocument,{args:["2018-01-01"]}),test("date._fn.begOfWeek",{_fn:'this.date.begOfWeek() === date.parse("2018-01-01")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_trunc('week', t0.DAT_0)::DATE = $1::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (TRUNC(t0.DAT_0,'IW') = TO_DATE(:v1,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(WEEK, DATEDIFF(WEEK, 0, CAST(t0.DAT_0 AS DATE)), 0) = CAST(@p0 AS DATE))"},document_1.TestDocument,{args:["2018-01-01"]}),test("date._fn.endOfYear",{_fn:'this.date.endOfYear() === date.parse("2018-01-01")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((date_trunc('year', t0.DAT_0) + interval '1 year - 1 day') = $1::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (ADD_MONTHS(TRUNC(t0.DAT_0, 'Y'), 12) - 1 = TO_DATE(:v1,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(YEAR, DATEDIFF(YEAR, 0, CAST(t0.DAT_0 AS DATE)) + 1, -1) = CAST(@p0 AS DATE))"},document_1.TestDocument,{args:["2018-01-01"]}),test("date._fn.endOfQuarter",{_fn:'this.date.endOfQuarter() === date.parse("2018-01-01")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((date_trunc('quarter', t0.DAT_0) + interval '3 months - 1 day') = $1::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((ADD_MONTHS(TRUNC(t0.DAT_0,'Q'),3)-1) = TO_DATE(:v1,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(QUARTER, DATEDIFF(QUARTER, 0, CAST(t0.DAT_0 AS DATE)) + 1, -1) = CAST(@p0 AS DATE))"},document_1.TestDocument,{args:["2018-01-01"]}),test("date._fn.endOfMonth",{_fn:'this.date.endOfMonth() === date.parse("2018-01-01")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((date_trunc('month', t0.DAT_0) + interval '1 month - 1 day') = $1::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (LAST_DAY(t0.DAT_0) = TO_DATE(:v1,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(MONTH, DATEDIFF(MONTH, 0, CAST(t0.DAT_0 AS DATE)) + 1, -1) = CAST(@p0 AS DATE))"},document_1.TestDocument,{args:["2018-01-01"]}),test("date._fn.endOfWeek",{_fn:'this.date.endOfWeek() === date.parse("2018-01-01")'},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE ((date_trunc('week', t0.DAT_0) + interval '1 week - 1 day') = $1::DATE)",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE ((TRUNC(t0.DAT_0,'IW')+6) = TO_DATE(:v1,'YYYY-MM-DD'))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEADD(WEEK, DATEDIFF(WEEK, 0, CAST(t0.DAT_0 AS DATE)) + 1, -1) = CAST(@p0 AS DATE))"},document_1.TestDocument,{args:["2018-01-01"]}),test("complex date filter with _fn",{_fn:"this.date.year === this.date.month + 2014"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('year', t0.DAT_0) = (date_part('month', t0.DAT_0) + $1::INT8))",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(YEAR FROM t0.DAT_0) = (EXTRACT(MONTH FROM t0.DAT_0) + :v1))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(yy FROM CAST(t0.DAT_0 AS DATE)) = (DATEPART(mm FROM CAST(t0.DAT_0 AS DATE)) + @p0))"},document_1.TestDocument,{args:[2014]}),test("nested _fn in filter",{parentDocument:{_fn:"this.date.year === this.date.month + 2014"}},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE (date_part('year', t3.DAT_0) = (date_part('month', t3.DAT_0) + $1::INT8))",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (EXTRACT(YEAR FROM t3.DAT_0) = (EXTRACT(MONTH FROM t3.DAT_0) + :v1))",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE (DATEPART(yy FROM CAST(t3.DAT_0 AS DATE)) = (DATEPART(mm FROM CAST(t3.DAT_0 AS DATE)) + @p0))"},document_1.TestDocument,{args:[2014]}),test("date is datetime string literal",{date:"2025-05-13T23:00:00.000Z"},T,{postgres:"SELECT  t0.COD_0 AS \"T_0_COD_0\", (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS \"T_0_DES_0\", t0.DAT_0 AS \"T_0_DAT_0\", t0.MAINDOC_0 AS \"T_0_MAINDOC_0\", t3.COD_0 AS \"T_3_COD_0\", (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS \"T_3_DES_0\", t3.DAT_0 AS \"T_3_DAT_0\", t3.MAINDOC_0 AS \"T_3_MAINDOC_0\", t6.COD_0 AS \"T_6_COD_0\", (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS \"T_6_DES_0\", t6.DAT_0 AS \"T_6_DAT_0\", t0.CREDATTIM_0 AS \"T_0_CREDATTIM_0\", t0.UPDDATTIM_0 AS \"T_0_UPDDATTIM_0\", t0.UPDTICK_0 AS \"T_0_UPDTICK_0\", t0.CREUSR_0 AS \"T_0_CREUSR_0\", t0.UPDUSR_0 AS \"T_0_UPDUSR_0\" FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t1.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(t0.COD_0::TEXT,CONCAT('~',TO_CHAR(t0.DAT_0,'YYYYMMDD')::TEXT)) AND t2.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')::TEXT,CONCAT('~',t0.COD_0::TEXT)) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t4.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(t3.COD_0::TEXT,CONCAT('~',TO_CHAR(t3.DAT_0,'YYYYMMDD')::TEXT)) AND t5.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')::TEXT,CONCAT('~',t3.COD_0::TEXT)) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t7.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(t6.COD_0::TEXT,CONCAT('~',TO_CHAR(t6.DAT_0,'YYYYMMDD')::TEXT)) AND t8.IDENT2_0 = CONCAT(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')::TEXT,CONCAT('~',t6.COD_0::TEXT)) AND t8.LANGUE_0 = 'FRA' WHERE t0.DAT_0 = TO_DATE($1,'YYYY-MM-DD')",oracle:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, t0.DAT_0 AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, t3.DAT_0 AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, t6.DAT_0 AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t1.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(TO_CHAR(t0.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t0.DAT_0,'YYYYMMDD')))) AND t2.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t0.DAT_0),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t4.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(TO_CHAR(t3.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t3.DAT_0,'YYYYMMDD')))) AND t5.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t3.DAT_0),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t7.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(TO_CHAR(t6.COD_0),CONCAT('~',TO_CHAR(TO_CHAR(t6.DAT_0,'YYYYMMDD')))) AND t8.IDENT2_0 = CONCAT(TO_CHAR(CONCAT(CONCAT(CONCAT(CONCAT('',t6.DAT_0),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',TO_CHAR(t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE t0.DAT_0 = TO_DATE(:v1,'YYYY-MM-DD')",tedious:"SELECT  t0.COD_0 AS T_0_COD_0, (CASE WHEN (t1.TEXTE_0 IS NOT NULL) THEN t1.TEXTE_0 ELSE t2.TEXTE_0 END) AS T_0_DES_0, CAST(t0.DAT_0 AS DATE) AS T_0_DAT_0, t0.MAINDOC_0 AS T_0_MAINDOC_0, t3.COD_0 AS T_3_COD_0, (CASE WHEN (t4.TEXTE_0 IS NOT NULL) THEN t4.TEXTE_0 ELSE t5.TEXTE_0 END) AS T_3_DES_0, CAST(t3.DAT_0 AS DATE) AS T_3_DAT_0, t3.MAINDOC_0 AS T_3_MAINDOC_0, t6.COD_0 AS T_6_COD_0, (CASE WHEN (t7.TEXTE_0 IS NOT NULL) THEN t7.TEXTE_0 ELSE t8.TEXTE_0 END) AS T_6_DES_0, CAST(t6.DAT_0 AS DATE) AS T_6_DAT_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0 FROM REPOSX3.TABDOC t0 LEFT JOIN REPOSX3.ATEXTRA t1 ON t1.CODFIC_0 = 'TABLE' AND t1.ZONE_0 = 'DES' AND t1.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t1.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t1.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t2 ON t2.CODFIC_0 = 'TABLE' AND t2.ZONE_0 = 'DES' AND t2.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t0.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t0.DAT_0 DATE),112)))) AND t2.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t0.DAT_0 DATE)),'XXX'),t0.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t0.COD_0))) AND t2.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t3 ON t3.COD_0 = t0.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t4 ON t4.CODFIC_0 = 'TABLE' AND t4.ZONE_0 = 'DES' AND t4.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t4.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t4.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t5 ON t5.CODFIC_0 = 'TABLE' AND t5.ZONE_0 = 'DES' AND t5.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t3.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t3.DAT_0 DATE),112)))) AND t5.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t3.DAT_0 DATE)),'XXX'),t3.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t3.COD_0))) AND t5.LANGUE_0 = 'FRA' INNER JOIN REPOSX3.TABDOC t6 ON t6.COD_0 = t3.MAINDOC_0 LEFT JOIN REPOSX3.ATEXTRA t7 ON t7.CODFIC_0 = 'TABLE' AND t7.ZONE_0 = 'DES' AND t7.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t7.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t7.LANGUE_0 = 'ENG' LEFT JOIN REPOSX3.ATEXTRA t8 ON t8.CODFIC_0 = 'TABLE' AND t8.ZONE_0 = 'DES' AND t8.IDENT1_0 = CONCAT(CONVERT(VARCHAR(max),t6.COD_0),CONCAT('~',CONVERT(VARCHAR(max),CONVERT(VARCHAR,CAST(t6.DAT_0 DATE),112)))) AND t8.IDENT2_0 = CONCAT(CONVERT(VARCHAR(max),CONCAT(CONCAT(CONCAT(CONCAT('',CAST(t6.DAT_0 DATE)),'XXX'),t6.MAINDOC_0),'')),CONCAT('~',CONVERT(VARCHAR(max),t6.COD_0))) AND t8.LANGUE_0 = 'FRA' WHERE CAST(t0.DAT_0 AS DATE) = CONVERT(DATE,@p0,20)"},document_1.TestDocument,{args:["2025-05-13"]})})})});
//# sourceMappingURL=sql-test.js.map