/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),chai_1=require("chai"),sql_mapper_1=require("../../../lib/sql-mapper"),test_referencing_1=require("../../fixtures/nodes/test-referencing"),setup_1=require("../../fixtures/setup");describe("SQL Tests on getValue properties",()=>{before(setup_1.setupTest),["oracle","tedious","postgres"].forEach(e=>{it(`can order by computed property - ${e}`,async()=>{const _={response:{locals:{config:{x3:{sql:{driver:e,user:"REPOSX3",hostname:"scmx3-dev-dis.sagefr.adinternal.com",database:"fakeDatabase",password:"fakePassword"}}}}}};await xtrem_core_1.Test.withContext(_=>{if(!xtrem_x3_config_manager_1.X3ConfigManager.current.x3?.sql)throw new Error("X3 SQL config not found");xtrem_x3_config_manager_1.X3ConfigManager.current.x3.sql.driver=e;const r=_.application.getFactoryByConstructor(test_referencing_1.TestReferencing),t=new sql_mapper_1.SqlQuery(_,r,{orderBy:{reference:{computed:1}},filters:[]},"REPOSX3").getSqlQuery().sql;if("postgres"===e)chai_1.assert.equal(t.trim(),'SELECT  t0.COD_0 AS "T_0_COD_0", t0.REF_0 AS "T_0_REF_0", t0.REFNOJOIN_0 AS "T_0_REFNOJOIN_0", t0.CREDATTIM_0 AS "T_0_CREDATTIM_0", t0.UPDDATTIM_0 AS "T_0_UPDDATTIM_0", t0.UPDTICK_0 AS "T_0_UPDTICK_0", t0.CREUSR_0 AS "T_0_CREUSR_0", t0.UPDUSR_0 AS "T_0_UPDUSR_0", CONCAT(CONCAT(\'prefix-\',t1.COD_0),\'\') AS "THIS_REFERENCE_COMPUTED" FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REF_0 AND t1.DES3AEX_0 = \' \' WHERE 1=1  ORDER BY "THIS_REFERENCE_COMPUTED" ASC');else chai_1.assert.equal(t.trim(),"SELECT  t0.COD_0 AS T_0_COD_0, t0.REF_0 AS T_0_REF_0, t0.REFNOJOIN_0 AS T_0_REFNOJOIN_0, t0.CREDATTIM_0 AS T_0_CREDATTIM_0, t0.UPDDATTIM_0 AS T_0_UPDDATTIM_0, t0.UPDTICK_0 AS T_0_UPDTICK_0, t0.CREUSR_0 AS T_0_CREUSR_0, t0.UPDUSR_0 AS T_0_UPDUSR_0, CONCAT(CONCAT('prefix-',t1.COD_0),'') AS THIS_REFERENCE_COMPUTED FROM REPOSX3.REFING t0 INNER JOIN REPOSX3.REFED t1 ON t1.COD_0 = t0.REF_0 AND t1.DES3AEX_0 = ' ' WHERE 1=1  ORDER BY THIS_REFERENCE_COMPUTED ASC"+("oracle"===e?" NULLS FIRST":""))},{config:_})})})});
//# sourceMappingURL=sql-get-value-test.js.map