/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),xtrem_x3_config_manager_1=require("@sage/xtrem-x3-config-manager"),xtrem_x3_sql_manager_1=require("@sage/xtrem-x3-sql-manager"),chai_1=require("chai"),folder_manager_1=require("../../../lib/storage/folder-manager"),setup_1=require("../../fixtures/setup");async function withX3Config(e,r){const a=xtrem_x3_config_manager_1.X3ConfigManager.current,n=a.x3;a.x3=e;try{await r(a)}finally{a.x3=n}}xtrem_x3_config_manager_1.X3ConfigManager.load(__dirname),describe("Folder Manager",()=>{before(setup_1.setupTest),it("can get folder name",()=>withX3Config({development:{folderName:"TESTDEV"}},e=>xtrem_core_1.Test.withContext(r=>{chai_1.assert.equal(folder_manager_1.FolderManager.getFolderName({context:r,currentConfig:e}),"TEST"),chai_1.assert.equal(folder_manager_1.FolderManager.getFolderName({currentConfig:{...e,folderName:"TEST1"}}),"TEST1"),chai_1.assert.equal(folder_manager_1.FolderManager.getFolderName({currentConfig:{x3:{development:{folderName:"TEST2"}}}}),"TEST2"),chai_1.assert.equal(folder_manager_1.FolderManager.getFolderName(),"TESTDEV")},{config:{response:{constructor:{name:"ServerResponse"},cookie:()=>{},locals:{contextValues:{folderName:"TEST"}}}}}))),it("can get reference folder name",async()=>{const e=xtrem_x3_config_manager_1.X3ConfigManager.current;await xtrem_core_1.Test.withContext(async r=>{const a=xtrem_x3_sql_manager_1.PoolManager.getX3Pool(r);chai_1.assert.equal(await folder_manager_1.FolderManager.getReferenceFolderName(a,{context:r,currentConfig:{...e,x3:{development:{...e.x3?.development??{},referenceFolder:"TEST2"}}}}),"X3")})})});
//# sourceMappingURL=folder-manager-test.js.map