/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),chai_1=require("chai"),path=require("path"),nodes_1=require("../../fixtures/nodes"),bad_composite_nodes_1=require("../../fixtures/nodes/bad-composite-nodes"),test_project_1=require("../../fixtures/nodes/test-project"),setup_1=require("../../fixtures/setup");async function testError(e,t){await chai_1.assert.isRejected(xtrem_core_1.Test.createTestApplication({buildDir:path.join(__dirname,"..",".."),api:{nodes:{...e,TestReferenced:nodes_1.TestReferenced,TestReferencing:nodes_1.TestReferencing}}}),t)}describe("Composite references",()=>{before(setup_1.setupTest),it("throws error if the composite reference is not valid",()=>testError({TestComopositeInvalidReference:bad_composite_nodes_1.TestComopositeInvalidReference},"TestComopositeInvalidReference: TestComopositeInvalidReference.foo : property not found")),it("throws error if the composite reference local property is not valid",()=>testError({TestComopositeInvalidLocalProperty:bad_composite_nodes_1.TestComopositeInvalidLocalProperty},"TestComopositeInvalidLocalProperty: TestComopositeInvalidLocalProperty.foo : property not found")),it("throws error if the composite reference target property is not valid",()=>testError({TestComopositeInvalidTargetProperty:bad_composite_nodes_1.TestComopositeInvalidTargetProperty},"TestReferenced.bar: invalid target property in composite reference. Property does not exist in target node.")),it("throws error if the composite reference mapped property is not stored",()=>testError({TestComopositeInvalidStoredProperty:bad_composite_nodes_1.TestComopositeInvalidStoredProperty},"TestReferenced.computed: can only map composite reference to a stored property.")),it("throws error if the composite reference target and local properties are not the same type",()=>testError({TestComopositeInvalidPropertyType:bad_composite_nodes_1.TestComopositeInvalidPropertyType},"TestComopositeInvalidPropertyType.integerCode <=> TestReferenced.code(reference TestComopositeInvalidPropertyType.reference): property type mismatch in composite reference.")),it("throws error if the composite reference target and local properties are references and target nodes do match",()=>testError({TestComopositeInvalidReferenceNode:bad_composite_nodes_1.TestComopositeInvalidReferenceNode},"TestComopositeInvalidReferenceNode.mappedReference <=> TestReferencing.reference(reference TestComopositeInvalidReferenceNode.reference): target node mismatch in composite reference.")),it("throws error if the composite reference isVital",()=>testError({TestComopositeInvalidVitalReferenceNode:bad_composite_nodes_1.TestComopositeInvalidVitalReferenceNode,TestComopositeInvalidVitalReferenceChildNode:bad_composite_nodes_1.TestComopositeInvalidVitalReferenceChildNode},"TestComopositeInvalidVitalReferenceNode.mappedReference - composed properties cannot be vital, rather use isMutable")),it("can query a node with composite reference and get results",()=>xtrem_core_1.Test.withContext(async e=>{const t=(await e.query(nodes_1.TestProductSite,{first:1}).toArray())[0];chai_1.assert.equal(await t.compositeDescription1,await(await t.product).description1),chai_1.assert.equal(await t.compositeDescription2,await(await t.product).description2),chai_1.assert.equal(await t.compositeDescription3,await(await t.product).description3),chai_1.assert.equal(await t.compositeLocalizedDescription1,await(await t.product).localizedDescription1),chai_1.assert.equal(await t.compositeLocalizedDescription2,await(await t.product).localizedDescription2),chai_1.assert.equal(await t.compositeLocalizedDescription3,await(await t.product).localizedDescription3),chai_1.assert.equal(await t.legislation,await t.$.get("stockSite.legalCompany.legislation"));const o=await(await t.legislation).description;chai_1.assert.equal(o,await t.$.get("stockSite.legalCompany.legislation.description")),chai_1.assert.equal(await(await t.$.createdBy).code,t.$.getRawPropertyValue("_createUser")),chai_1.assert.equal(await(await t.$.updatedBy).code,t.$.getRawPropertyValue("_updateUser")),chai_1.assert.equal(await t.$.createStamp,t.$.getRawPropertyValue("_createStamp")),chai_1.assert.equal(await t.$.updateStamp,t.$.getRawPropertyValue("_updateStamp"))})),it("can query a node with composite standalone reference and get results",()=>xtrem_core_1.Test.withContext(async e=>{const t=(await e.query(nodes_1.TestProductSite,{first:1}).toArray())[0];chai_1.assert.instanceOf(await t.standaloneProduct,nodes_1.TestProduct),chai_1.assert.equal((await t.compositeProductVolume).toString(),(await(await t.standaloneProduct).productVolume).toString()),chai_1.assert.equal((await t.compositeProductWeight).toString(),(await(await t.standaloneProduct).productWeight).toString())})),it("can query a node with a vital composite denormalized collection",()=>xtrem_core_1.Test.withContext(async e=>{const t=await e.query(test_project_1.TestProject,{filter:{dimensions:{_atLeast:1}}}).toArray();chai_1.assert.isAtLeast(t.length,1);const o=t[0],a=(await o.dimensions.toArray()).map(e=>e._id),r=(await(await o.$.get("pjmProject.dimensions")).toArray()).map(e=>e._id);chai_1.assert.isAtLeast(a.length,1),chai_1.assert.isAtLeast(r.length,1),chai_1.assert.deepEqual(r,a)})),it("can query a node with a non-vital composite denormalized collection",()=>xtrem_core_1.Test.withContext(async e=>{const t=await e.query(test_project_1.TestProject,{filter:{dimensions:{_atLeast:1}}}).toArray();chai_1.assert.isAtLeast(t.length,1);const o=t[0],a=(await o.pjmDimensions.toArray()).map(e=>e._id),r=(await(await o.$.get("pjmProject.dimensions")).toArray()).map(e=>e._id);chai_1.assert.isAtLeast(a.length,1),chai_1.assert.isAtLeast(r.length,1),chai_1.assert.deepEqual(r,a)})),it("can query a node with a mutable composite denormalized collection",()=>xtrem_core_1.Test.withContext(async e=>{const t=await e.query(nodes_1.TestCustomerContact,{filter:{addressLines:{_atLeast:1,line:{_ne:null}}}}).toArray();chai_1.assert.isAtLeast(t.length,1);const o=t[0],a=await o.addressLines.map(e=>e.line).toArray(),r=await(await o.$.get("code.addressLines")).map(e=>e.line).toArray();chai_1.assert.isAtLeast(a.length,1),chai_1.assert.isAtLeast(r.length,1),chai_1.assert.deepEqual(a,r);const i=((await o.$.payload({returnEnumsAsNumber:true,withIds:true})).addressLines||[]).map(e=>e.line);chai_1.assert.isAtLeast(i.length,1),chai_1.assert.deepEqual(i,r)}))});
//# sourceMappingURL=composite-test.js.map