/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true});const xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),chai_1=require("chai"),api_helper_1=require("../../../lib/api/api-helper"),nodes_1=require("../../fixtures/nodes"),setup_1=require("../../fixtures/setup");describe("X3 API testing",()=>{before(setup_1.setupTest),it("can execute a node mutation, that executes api call",async()=>{const e={response:{cookie(){},constructor:{name:"ServerResponse"},locals:{contextValues:{token:"FAKE_TOKEN",apiUrl:"http://x3api-test4.sagex3rd.local:8124/xtrem/mutation",session:"FAKE_SESSION"}}}};await xtrem_core_1.Test.withContext(async e=>{const t=await nodes_1.TestDocument.apiOperation(e,{numero:1034,chaine:"API Test",datetest:[xtrem_date_time_1.DateValue.make(2023,4,27),xtrem_date_time_1.DateValue.make(2023,10,15)],dectest:xtrem_decimal_1.Decimal.make("10.5"),amltest:true,structures:[{test1:"line1",test2:"test2pourligne1"},{test1:"line2",test2:""}]});chai_1.assert.deepEqual(t,{retourmes:"Date and decimal : OK- Structures : OK",retourint:0}),chai_1.assert.equal(e.diagnoses.length,1),chai_1.assert.deepEqual(e.diagnoses,[{message:"Opération réussie",path:[],severity:1}])},{mocks:["axios"],directory:__dirname,scenario:"api-request1",config:e})}),it("can execute a node update mutation, and have the correct api payload with denormalization collection excluding deleted lines",async()=>{await xtrem_core_1.Test.withContext(async e=>{const t=await e.read(nodes_1.TestProject,{id:"J-NA32110050193"},{forUpdate:true});await((await t.dimensions.at(0))?.$.set({dimension:"TEST"})),await t.dimensions.delete(1,1);const a=(await api_helper_1.ApiHelper.parseNodeInputData(e,e.application.getFactoryByConstructor(nodes_1.TestProject),t)).dimensions,s=a.filter(e=>"U"===e._nodeStatus);chai_1.assert.equal(s.length,1);const r=a.filter(e=>"D"===e._nodeStatus);chai_1.assert.equal(r.length,0),chai_1.assert.isTrue(a.filter(e=>!["D","U"].includes(e._nodeStatus)).every(e=>"R"===e._nodeStatus))})}),it("can execute a node update mutation, and have the correct api payload with nornal mutable collection including deleted lines",async()=>{await xtrem_core_1.Test.withContext(async e=>{const t=await e.read(nodes_1.TestCustomer,{code:"I-JBADCCUST01"},{forUpdate:true});await((await t.customerProducts.at(0))?.$.set({customerProduct:"TEST"})),await t.customerProducts.delete(1,1);const a=(await api_helper_1.ApiHelper.parseNodeInputData(e,e.application.getFactoryByConstructor(nodes_1.TestCustomer),t)).customerProducts,s=a.filter(e=>"U"===e._nodeStatus);chai_1.assert.equal(s.length,1);const r=a.filter(e=>"D"===e._nodeStatus);chai_1.assert.equal(r.length,1),chai_1.assert.isTrue(a.filter(e=>!["D","U"].includes(e._nodeStatus)).every(e=>"R"===e._nodeStatus))})})});
//# sourceMappingURL=api-helper-test.js.map