import { Collection, date, integer, Node, Reference } from '@sage/xtrem-core';
import { TestCurrency } from './test-currency';
import { TestMiscellaneousTable } from './test-miscellaneous-table';
import { TestPjmProject } from './test-pjm-project';
import { TestPjmProjectDimension } from './test-pjm-project-dimension';
import { TestSite } from './test-site';
/** 4GL code: OPPOR */
export declare class TestProject extends Node {
    /** 4GL code: SALFCY */
    /** TODO FGR : reactivate with X3-285258 */
    readonly site: Reference<TestSite | null>;
    /** 4GL code: OPPNUM */
    readonly id: Promise<string>;
    /** 4GL code: OPPEXTNUM */
    readonly externalIdentifier: Promise<string>;
    /** 4GL code: OPPDATOPN */
    readonly openingDate: Promise<date | null>;
    /** 4GL code: CUR */
    /** TODO FGR : reactivate with X3-285258 */
    readonly currency: Reference<TestCurrency | null>;
    /** 4GL code: OPPCLO */
    readonly isClosed: Promise<boolean>;
    /** 4GL code: OPPTYP */
    readonly category: Reference<TestMiscellaneousTable | null>;
    /** 4GL code: OPPCMGNUM */
    readonly marketingCampaign: Promise<string | null>;
    /** 4GL code: OPPOPGNUM */
    readonly marketingOperation: Promise<string | null>;
    /** 4GL code: OPPOPGTYP */
    readonly marketingOperationType: Promise<string | null>;
    /** 4GL code: OPPORIVCR */
    readonly originalDocument: Promise<string | null>;
    /** 4GL code: OPPORIVCRL */
    readonly originalDocumentLine: Promise<integer>;
    /** 4GL code: CREHOU */
    readonly creationTime: Promise<string | null>;
    readonly pjmProject: Reference<TestPjmProject | null>;
    /** 4GL code: OPPINT */
    readonly isInternal: Promise<boolean>;
    /** 4GL code: OPPFRT */
    readonly isProvisional: Promise<boolean>;
    /** 4GL code: OPPDATTH */
    readonly suspensionDate: Promise<date | null>;
    /** 4GL code: OPPDATLV */
    readonly deliveryDate: Promise<date | null>;
    /** 4GL code: OPPDATLA */
    readonly launchingDate: Promise<date | null>;
    /** 4GL code: OPPDATS */
    readonly closingDate: Promise<date | null>;
    /** 4GL code: OPPPROACTIV */
    readonly isIndirectCostCalculated: Promise<boolean>;
    /** 4GL code: CUROPP */
    /** TODO FGR : reactivate with X3-285258 */
    readonly overviewCurrency: Reference<TestCurrency | null>;
    /** 4GL code: OPPIMPT */
    readonly isIntermediateLevelBudgetingAllowed: Promise<boolean>;
    /** 4GL code: OPEDEFFCY */
    /** TODO FGR : reactivate with X3-285258 */
    readonly operatingSite: Reference<TestSite | null>;
    /** 4GL code: OPPMOD */
    readonly isTemplate: Promise<boolean>;
    /** 4GL code: ORIOPP */
    readonly source: Reference<TestProject | null>;
    /** 4GL code: STRDAT */
    readonly startDate: Promise<date | null>;
    /** 4GL code: ENDDAT */
    readonly endDate: Promise<date | null>;
    /** 4GL code: DUEDAT */
    readonly dueDate: Promise<date | null>;
    /** 4GL code: OPPDUR */
    readonly duration: Promise<integer>;
    /** 4GL code: EREVDAT */
    readonly revenueEstimationDate: Promise<date | null>;
    /** 4GL code: PRCCPLADI */
    readonly progressRange: Reference<TestMiscellaneousTable | null>;
    /** 4GL code: PRCCPLDAT */
    readonly progressEstimationDate: Promise<date | null>;
    readonly dimensions: Collection<TestPjmProjectDimension>;
    readonly pjmDimensions: Collection<TestPjmProjectDimension>;
    /** 4GL code: TASBUDAUT */
    readonly isBudgetCreatedAutomatically: Promise<boolean>;
}
//# sourceMappingURL=test-project.d.ts.map