import { Collection, date, Node, Reference } from '@sage/xtrem-core';
import { TestEntityType } from '../enums/test-entity-type';
import { TestContactRelationship } from './test-contact-relationship';
import { TestContactRelationshipAddressLine } from './test-contact-relationship-address-line';
import { TestCustomer } from './test-customer';
import { TestMiscellaneousTable } from './test-miscellaneous-table';
/** 4GL code: TestCustomerContact */
export declare class TestCustomerContact extends Node {
    /** 4GL code: BPATYP */
    readonly entityType: Promise<TestEntityType>;
    /** 4GL code: BPANUM */
    readonly customer: Reference<TestCustomer>;
    /** 4GL code: CCNCRM */
    readonly code: Reference<TestContactRelationship | null>;
    /** 4GL code: CNTSRV */
    readonly department: Promise<string>;
    /** 4GL code: CNTMSS */
    readonly role: Reference<TestMiscellaneousTable | null>;
    /** 4GL code: TEL */
    readonly landline: Promise<string>;
    /** 4GL code: FAX */
    readonly fax: Promise<string>;
    /** 4GL code: MOB */
    readonly cellPhone: Promise<string>;
    /** 4GL code: WEB */
    readonly email: Promise<string>;
    /** 4GL code: DPO */
    readonly isDataProtectionOfficer: Promise<boolean | null>;
    /** 4GL code: CNTFULNAM */
    readonly relationshipFullNameSearchKey: Promise<string>;
    /** 4GL code: CNTLNA */
    readonly relationshipLastName: Promise<string>;
    /** 4GL code: CNTFNA */
    readonly relationshipFirstName: Promise<string>;
    /** 4GL code: CNTBIR */
    readonly relationshipDateOfBirth: Promise<date | null>;
    /** 4GL code: CNTCSP */
    readonly relationshipProfessionalCategory: Reference<TestMiscellaneousTable | null>;
    /** 4GL code: CRYNAM */
    readonly relationshipCountryName: Promise<string>;
    /** 4GL code: ADD */
    readonly addressLines: Collection<TestContactRelationshipAddressLine>;
    /** 4GL code: ADD */
    readonly relationshipAddressLines: Collection<TestContactRelationshipAddressLine>;
    /** 4GL code: ZIP */
    readonly relationshipZipCode: Promise<string>;
    /** 4GL code: CTY */
    readonly relationshipCity: Promise<string>;
    /** 4GL code: SAT */
    readonly relationshipState: Promise<string>;
    /** 4GL code: CNTETS */
    readonly relationshipLandline: Promise<string>;
    /** 4GL code: CNTFAX */
    readonly relationshipFax: Promise<string>;
    /** 4GL code: CNTMOB */
    readonly relationshipCellPhone: Promise<string>;
    /** 4GL code: CNTEMA */
    readonly relationshipEmail: Promise<string>;
    /** 4GL code: CNTFBDMAG */
    readonly relationshipIsMailingProhibited: Promise<boolean | null>;
}
//# sourceMappingURL=test-customer-contact.d.ts.map