/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.X3StorageSoapWebServiceHelper=void 0;const xtrem_core_1=require("@sage/xtrem-core"),web_service_helper_1=require("../soap/classes/web-service-helper"),x3_storage_manager_1=require("./x3-storage-manager");class X3StorageSoapWebServiceHelper{static{this.logger=xtrem_core_1.Logger.getLogger(__filename,"storage")}static manageWebServiceValidationMessages(e){const{diagnoses:r}=e.$.context;r.filter(e=>e.severity===xtrem_core_1.ValidationSeverity.info).forEach(e=>{this.logger.verbose(()=>`${e.path}: ${e.message}`)}),r.filter(e=>e.severity===xtrem_core_1.ValidationSeverity.warn).forEach(e=>{this.logger.warn(()=>`${e.path}: ${e.message}`)})}static async executeWebService(e,r,t,a,o){const i=await X3StorageSoapWebServiceHelper.resolveWebService(t,r),s=await X3StorageSoapWebServiceHelper.getWebServicePayload(e.factory,r,o);let c;switch(i.type){case"import":c=await web_service_helper_1.WebServiceHelper.importWebServiceCall(r.$.context,e.factory,r.$.status,s,i.name,i.outputNames||[],a);break;case"subProg":c=await web_service_helper_1.WebServiceHelper.subProgramWebServiceCall(r.$.context,e.factory,s,i.name,a);break;case"object":c=await web_service_helper_1.WebServiceHelper.objectWebServiceCall(r.$.context,e.factory,r.$.status,s,i.name,a);break;default:throw new Error(`Invalid web service type ${i.type}, ${i.name}`)}if(this.manageWebServiceValidationMessages(r),r.$.context.diagnoses.some(e=>e.severity>=xtrem_core_1.ValidationSeverity.error))throw xtrem_core_1.OperationError.fromNodeMutation(r,"executeWebService",r.$.context.diagnoses);return c}static resolveWebService(e,r){return"function"==typeof e?e.call(r):e}static async getWebServicePayload(e,r,t){const a=await r.$.payload({returnEnumsAsNumber:true});return t?.removeTransients?x3_storage_manager_1.X3StorageManager.removeTransientKeyValues(e,a):a}static async insert(e,r,t){if(!e.webServices?.create)throw new Error(`${e.factory.name}: Create web service details not supplied to external storage manager.`);const a=await X3StorageSoapWebServiceHelper.executeWebService(e,r,e.webServices?.create,t,{removeTransients:true}),o={},i=await X3StorageSoapWebServiceHelper.resolveWebService(e.webServices?.create,r);if("import"===i.type){if(a.output=a.output||{},i.outputNames)i.outputNames.forEach(t=>{const i=e.factory.properties.find(a=>a.columnName===t&&!e.getInactiveProperties(r.$.context).includes(a));if(i)o[i.name]=a.output?.[t]})}else if("object"===i.type)if(a.results=a.results||{},i.outputNames)i.outputNames.forEach(t=>{const i=e.factory.properties.find(a=>a.columnName===t&&!e.getInactiveProperties(r.$.context).includes(a));if(i)o[i.name]=a.results[i.name]});return o._id=e.getId(r.$.context,{...r.$.getRawPropertyValues(),...o}),o}static async update(e,r,t){if(!e.webServices?.update)throw new Error(`${e.factory.name}: Update web service not supplied to external storage manager.`);return await X3StorageSoapWebServiceHelper.executeWebService(e,r,e.webServices.update,t,{removeTransients:true}),[]}static async delete(e,r,t){if(!e.webServices?.delete)throw new Error(`${e.factory.name}: Delete web service not supplied to external storage manager.`);return await X3StorageSoapWebServiceHelper.executeWebService(e,r,e.webServices.delete,t),1}}exports.X3StorageSoapWebServiceHelper=X3StorageSoapWebServiceHelper;
//# sourceMappingURL=x3-storage-soap-web-service-helper.js.map