/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.X3StorageManager=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_x3_sql_manager_1=require("@sage/xtrem-x3-sql-manager"),lodash=require("lodash"),api_helper_1=require("../api/api-helper"),sql_mapper_1=require("../sql-mapper"),sql_resolver_1=require("../sql-mapper/sql-resolver"),folder_manager_1=require("./folder-manager"),x3_storage_soap_web_service_helper_1=require("./x3-storage-soap-web-service-helper");class X3StorageManager{static{this.hashtagPlaceholder="<PLACEHOLDER_FOR_HASHTAG>"}constructor(e={}){if(this.options=e,this.skipValidation=true,this.logger=xtrem_core_1.Logger.getLogger(__filename,"storage"),this.#e=false,!this.options?.joins)this.options.joins={};if(!this.options?.joins?.referenceJoins)this.options.joins.referenceJoins={};this.options.joins.referenceJoins._createUser={code:"_createUser"},this.options.joins.referenceJoins._updateUser={code:"_updateUser"}}get joins(){return this.options?.joins||{}}get webServices(){return this.options?.webServices}get isDenormalized(){return this.options?.isDenormalized}get denormalized(){return this.options?.denormalized}get accessMapping(){return this.options?.accessMapping}get compositeReferences(){return this.options?.compositeReferences}get joinFallbackProperties(){return this.options?.joinFallbackProperties}static getFolderName(e){return folder_manager_1.FolderManager.getFolderName({context:e})}static verifyCompositeTargetProperty(e,r){if(!r)throw new Error(`${e}: invalid target property in composite reference. Property does not exist in target node.`);if(!r.isStored&&"collection"!==r.type)throw new Error(`${e}: can only map composite reference to a stored property.`)}static verifyCompositeProperties(e,r,t,i){const o=i.split("."),n=`${e.name}.${t}`,s=e.findProperty(t,{includeSystemProperties:true});if(s?.isVital)throw new Error(`${e.name}.${t} - composed properties cannot be vital, rather use isMutable`);let a,l=r.targetFactory,c=`${l?.name}`;if(o.forEach(e=>{if(c+=`.${e}`,!l)throw new Error(`${c}: invalid target node for composite reference.`);a=l.properties.find(r=>r.name===e),this.verifyCompositeTargetProperty(c,a),l=a?.isReferenceProperty()?a.targetFactory:void 0}),s.type!==a?.type)throw new Error(`${n} <=> ${c}(reference ${e.name}.${r.name}): property type mismatch in composite reference.`);if(a.isReferenceProperty()&&s.isReferenceProperty()&&s.targetFactory!==a.targetFactory)throw new Error(`${n} <=> ${c}(reference ${e.name}.${r.name}): target node mismatch in composite reference.`)}verifyCompositeReferences(e){if(this.compositeReferences){const{compositeReferences:r}=this;Object.keys(r).forEach(t=>{const i=e.findProperty(t,{includeSystemProperties:true});if(!i.isReferenceProperty())throw new Error(`${e.name}.${t}: invalid property in composite reference.`);Object.keys(r[t]).forEach(o=>{X3StorageManager.verifyCompositeProperties(e,i,o,r[t][o])})})}}#e;verifyFactory(){if(this.#e)return;const e=this.#r,r=e.keyProperties.map(e=>e.name);if(this.isDenormalized){if("integer"!==e.findProperty("denormalizedIndex",{includeSystemProperties:true}).type)throw new Error(`${e.name}: Property denormalizedIndex must be of type 'integer'.`);if(!r.includes("denormalizedIndex"))throw new Error(`${e.name}: Denormalized node must have property 'denormalizedIndex' as a keyProperty.`)}e.uniqueKeyProperties.forEach(t=>{if(t.every(e=>r.includes(e))&&t.length<r.length)throw new Error(`${e.name}: invalid unique index ${t}. Unique index is a subset of the node key properties.`)}),this.verifyCompositeReferences(e);const t=e.properties.filter(e=>e.isStored&&sql_resolver_1.systemColumns.includes(e.columnName)&&null==sql_resolver_1.systemProperties[e.name]).map(e=>e.name);if(t.length>0)throw new Error(`${e.name}: has properties that relate to columns managed by the framework. ${t}.`);this.#e=true}#r;set factory(e){this.#r=e}get factory(){return this.#r}canCreate(e){return e||!!this.options.canCreate}canUpdate(e){return e||!!this.options.canUpdate}canDelete(e){return e||!!this.options.canDelete}canDeleteMany(e){return e||!!this.options.canDelete}getMaxRepeat(e){if(this.isDenormalized){const r=this.denormalized?.maxRepeat;if("function"==typeof r)return r(e);return r||1}return 1}get compositeReferencePaths(){const e={};if(this.compositeReferences){const{compositeReferences:r}=this;Object.keys(r).forEach(t=>{Object.keys(r[t]).forEach(i=>{const o=r[t][i].split(".");e[i]=[t,...o]})})}return e}static removeTransientKeyValues(e,r){return e.keyProperties.forEach(t=>{if(null!=r[t.name])if(e.externalStorageManager?.isKeyPropertyTransient(t.name,r[t.name]))delete r[t.name]}),e.properties.filter(e=>["reference","collection"].includes(e.type)).forEach(e=>{if(null!=r[e.name]&&"object"==typeof r[e.name]){if(e.isReferenceProperty()){const{targetFactory:t}=e;r[e.name]=this.removeTransientKeyValues(t,r[e.name])}if(e.isCollectionProperty()){const{targetFactory:t}=e;r[e.name]=r[e.name].map(e=>this.removeTransientKeyValues(t,e))}}}),r}async getSystemReturningValue(e,r){const t=await e.select(this.factory.nodeConstructor,{_createStamp:true,_updateStamp:true,_createUser:true,_updateUser:true},{filter:{_id:r},first:1});if(0===t.length)return{};return t[0]}async insert(e,r){if(this.isDenormalized||r.path.length>0)return Promise.resolve({_id:String(e._id)});let t;if(this.webServices?.create)t=await x3_storage_soap_web_service_helper_1.X3StorageSoapWebServiceHelper.insert(this,e,r);else t=await api_helper_1.ApiHelper.insert(this,e,r);const i=await this.getSystemReturningValue(e.$.context,t._id);return lodash.merge(t,i)}async update(e,r){if(this.isDenormalized||r.path.length>0)return Promise.resolve([]);let t;if(this.webServices?.update)t=await x3_storage_soap_web_service_helper_1.X3StorageSoapWebServiceHelper.update(this,e,r);else t=await api_helper_1.ApiHelper.update(this,e,r);const i=await this.getSystemReturningValue(e.$.context,e._id);if(0===t.length)return[i];return t.map(e=>lodash.merge(e,i))}delete(e,r){if(this.isDenormalized||r.path.length>0)return Promise.resolve(0);if(this.webServices?.delete)return x3_storage_soap_web_service_helper_1.X3StorageSoapWebServiceHelper.delete(this,e,r);return api_helper_1.ApiHelper.delete(this,e,r)}getAllowedAccessCodes(e,r,t){const getCodes=async r=>{const i=r&&await r(e);if(null==i){if(null!=t&&!t.includes(""))t.push("");return t}return i};switch(r){case"accessCode":return getCodes(this.options?.allowedAccessCodes);case"site":return getCodes(this.options?.allowedSiteCodes);default:return getCodes(()=>null)}}getEmptyDenormalizedResult(e,r){return r.reduce((r,t)=>{const i=this.factory.properties.find(e=>e.name===t);if(i){const t=sql_resolver_1.SqlResolver.getPropertyType(i);switch(t){case"boolean":r[i.name]=false;break;case"enum":r[i.name]=i.isNullable?null:void 0;break;case"integer":case"short":case"string":case"decimal":r[i.name]=sql_mapper_1.SqlConverter.typeDefaultValue(e,{property:i,type:t,isNullable:false});break;case"binaryStream":r[i.name]=i.isNullable?null:xtrem_core_1.BinaryStream.fromBuffer(Buffer.alloc(0));break;case"textStream":r[i.name]=i.isNullable?null:xtrem_core_1.TextStream.fromString("");break;default:r[i.name]=null}}return r},{})}static convertScalarValue(e){if(xtrem_decimal_1.Decimal.isDecimal(e)||xtrem_core_1.Datetime.isDatetime(e)||xtrem_core_1.DateValue.isDate(e)||xtrem_date_time_1.DateRange.isDateRange(e)||xtrem_date_time_1.DatetimeRange.isDatetimeRange(e)||xtrem_date_time_1.IntegerRange.isIntegerRange(e)||xtrem_date_time_1.DecimalRange.isDecimalRange(e)||e instanceof xtrem_core_1.Uuid)return e.toString();return e}isDenormalizedResultEmpty(e,r,t){const i=this.getEmptyDenormalizedResult(e,r),o=["_denormalizedParent","_id"];if(this.#r.isVitalChild)o.push(this.#r.vitalParentProperty.name);return r.filter(e=>!o.includes(e)).map(e=>((0,xtrem_core_1.isScalar)(t[e])?X3StorageManager.convertScalarValue(t[e]):String(t[e]))===((0,xtrem_core_1.isScalar)(i[e])?X3StorageManager.convertScalarValue(i[e]):String(i[e]))).every(e=>e)}getSizedDenormalizedResult(e,r,t){const i=this.denormalized?.minRepeat||"zero";let o=-1,n=r.length-1;for(;n>=0;){const i=r[n];if(!this.isDenormalizedResultEmpty(e,t,i)){o=n;break}n-=1}switch(i){case"zero":return-1===o?[]:r.slice(0,o+1);case"one":return-1===o?r.slice(0,1):r.slice(0,o+1);default:return r}}mapDenormalizedResponse(e,r,t,i){const o=[];if(0===r.length)return[];const n={},s=[...this.factory.keyProperties.map(e=>e.name),...Object.keys(sql_resolver_1.systemProperties)];if(s.filter(e=>"denormalizedIndex"!==e).forEach(e=>{const o=i.find(r=>r.property&&r.property.name===e);if(o&&o.columnAlias)n[e]=t.columnValue(o,r[0][o.columnAlias])}),this.factory.properties.find(e=>"_denormalizedParent"===e.name))n._denormalizedParent=this.factory.keyProperties.map(e=>e.name).map(e=>String(r[0][e])).join("|");const a=this.factory.properties.filter(e=>!s.includes(e.name)&&(e.isStored||"_id"===e.name)&&"denormalizedIndex"!==e.name).map(e=>e.name);for(let s=0;s<this.getMaxRepeat(e);s+=1){const e={};e.denormalizedIndex=s+1,a.forEach(o=>{const n=i.find(e=>e.property.name===o&&e.columnAlias?.endsWith(`_${s}`));if(n&&n.columnAlias)e[o]=t.columnValue(n,r[0][n.columnAlias])}),o.push({...e,...n})}return this.getSizedDenormalizedResult(e,o,a)}getDenormalizedFilterJoin(e){const r=this.factory.keyProperties.map(e=>e.name),t=this.factory.findProperty("denormalizedIndex",{includeSystemProperties:true}),i=r.filter(e=>e!==t.name),o=e.filters.find(e=>Object.keys(e).every(e=>i.includes(e))&&i.every(r=>Object.keys(e).includes(r)));if(!o)throw new Error(`${this.factory.name}: Denormalized node key property filter missing.`);const n=Object.keys(o);if(n.filter(e=>!r.includes(e)).length>0||i.filter(e=>!n.includes(e)).length>0)throw new Error(`${this.factory.name}: Filter of denormalized node can only contain keyProperties ${r}.`);return o}getDenormalizedPropertyColumnSuffix(e){return this.options?.denormalizedPropertyColumnSuffix?.[e]}query(e,r){if(!r.filters)r.filters=[];r.filters=r.filters.map(e=>{if(e._id&&Number(e._id)<0)delete e._id;return e});const t={...r};if(this.isDenormalized){if(r.filters.some(e=>-9999===e.denormalizedIndex))return new xtrem_core_1.AsyncGenericReader({read:()=>{},stop:()=>{this.logger.verbose(()=>"0 records read")}});const e=this.getDenormalizedFilterJoin(r);t.filters=[lodash.pick(e,Object.keys(e))]}const i=new sql_mapper_1.SqlQuery(e,this.factory,t,X3StorageManager.getFolderName(e)),o=i.getSqlQuery();if(this.isDenormalized&&i.isAggregateQuery())throw new Error(`${this.factory.name}: Aggregate queries are not supported for denormalized nodes`);const{outputColumns:n}=i,getRawReader=async()=>{const r=xtrem_x3_sql_manager_1.PoolManager.getX3Pool(e),t=await o.promisedParameterValues;return this.logger.verbose(()=>`${o.sql}\n ${JSON.stringify(t)}`),r.execute(o.sql,t,{decimalColumns:n?.filter(e=>"decimal"===e.type).map(e=>e.columnAlias||"")})};if(r.count)return new xtrem_core_1.AsyncArrayReader(getRawReader).map(e=>{if(e.NROWS)return Number(e.NROWS);return 0});let s=null,a=[],l=0;const read=async()=>{if(null==s)if(s=await getRawReader(),this.isDenormalized)a=this.mapDenormalizedResponse(e,s,i,n);else a=await(0,xtrem_core_1.asyncArray)(s).map(e=>{if(i.isAggregateQuery())return i.mapAggregateRecordIn(i.groupValueColumns.groups,i.groupValueColumns.values,e);return i.mapRecordIn(n,e)}).toArray();try{if(l>a.length-1)return;if(0===l)this.logger.verbose(()=>"query result ready");const t=a[l];if(void 0!==t)l+=1;if(!r.count&&!r.selector&&!t._id)t._id=this.getId(e,t);return t}catch(e){throw this.logger.error(()=>`Error '${e.message}`),e}},stop=()=>{this.logger.verbose(()=>`${l} records read`)};return new xtrem_core_1.AsyncGenericReader({read,stop})}mapRecordIn(e){return e}mapAggregateRecordIn(e){return e}isCompositeProperty(e){return null!=this.compositeReferencePaths[e]}walkToForeignCompositeFactory(e,r=0,t=this.factory){const i=e[r],o=e.slice(0,r);if(r!==e.length-1){const n=t.findProperty(i,{includeSystemProperties:true});if(!n.isReferenceProperty())throw new Error(`${this.factory.name}.${i}(${o}): invalid property in composite path, this property needs to be a reference property.`);const{targetFactory:s}=n;return this.walkToForeignCompositeFactory(e,r+1,s)}return t}static tryGet(e,r){return e.$.context.withoutGetPropertyValueErrorLogger(()=>e.$.get(r).catch(()=>null))}getCompositeReferenceJoin(e){const r=this.joins.referenceJoins?.[e];if(r)return r;const t=this.compositeReferencePaths[e],i=this.walkToForeignCompositeFactory(t),o=i.externalStorageManager,n=t[t.length-1],s=i.findProperty(n,{includeSystemProperties:true});if(!s.isReferenceProperty())throw new Error(`${i.name}.${n}: node missing on reference.`);const{targetFactory:a}=s,l=o.getReferenceJoin(n),c={};if(Object.keys(l).forEach(r=>{c[r]=async function(){const i=this.$.getRawPropertyValue(e),s=l[r];if("function"==typeof s){const e=t.slice(0,t.length-1).join("."),r=await this.$.get(e);return s.call(r)}if(n===s&&null!=i&&!o.isPropertyValueTransient(this.$.context,n,i)){if(1===String(i).split("|").length)return i;const e=a.parseNodeId(String(i));if(null!=e._id)return i;return e[r]}return this.$.get([...t,r].join("."))}}),!this.joins.referenceJoins)this.joins.referenceJoins={};return this.joins.referenceJoins[e]=c,c}getCompositeCollectionJoin(e){const r=this.joins.collectionJoins?.[e];if(r)return r;const t=this.compositeReferencePaths[e],i=this.walkToForeignCompositeFactory(t),o=i.externalStorageManager,n=t[t.length-1],s=o.getCollectionJoin(n),a=i.findProperty(n,{includeSystemProperties:true}),l=Object.keys(s).reduce((e,r)=>(e[r]=async function(){const e=t.slice(0,t.length-1).join("."),i=await X3StorageManager.tryGet(this,e);if(!i){if("added"!==this.$.status)throw new Error(`Failed to get property value ${e} from ${this.$.factory.name}(${this.$.status}) in composite join`);return null}if("function"==typeof s[r])return s[r].call(i);let o=await i.$.get(s[r]);if(o instanceof xtrem_core_1.Node&&a.isCollectionProperty()){const{targetFactory:e}=a;if(e.externalStorageManager.isDenormalized)o=i.$.getRawPropertyValue(r)}return o},e),{});if(!this.joins.collectionJoins)this.joins.collectionJoins={};return this.joins.collectionJoins[e]=l,l}getReferenceJoin(e){let r=this.joins.referenceJoins?.[e];if(r)return r;if(this.isCompositeProperty(e))return this.getCompositeReferenceJoin(e);const t=this.factory.findProperty(e,{includeSystemProperties:true}),i=t.isReferenceProperty()?t.targetFactory:void 0;if(i&&1===i.keyProperties.length)r={[i.keyProperties[0].name]:e};else throw new Error(`${this.factory.name}.${e}: reference join to ${i?.name}(${i?.keyProperties.map(e=>e.name)}) is not supplied.`);if(Object.keys(r).forEach(t=>{if("string"==typeof r?.[t])if(!this.factory.properties.map(e=>e.name).includes(r[t]))throw new Error(`${this.factory.name}.${e}: join property not found.`)}),!this.joins.referenceJoins)this.joins.referenceJoins={};return this.joins.referenceJoins[e]=r,r}getLocalization(e){return this.joins.localizedStrings&&this.joins.localizedStrings[e]}getCollectionJoin(e){if(this.isCompositeProperty(e))return this.getCompositeCollectionJoin(e);const r=this.factory.findProperty(e,{includeSystemProperties:true});if(!r.isCollectionProperty())throw new Error(`${this.factory.name}.${e}: not a collection property.`);const{targetFactory:t}=r;if((t?.externalStorageManager).isDenormalized){const e={};return this.factory.keyProperties.forEach(r=>{e[r.name]=r.name}),e}const i=this.joins.collectionJoins&&this.joins.collectionJoins[e];if(!i)throw new Error(`${this.factory.name}.${e}: collection join not supplied.`);return i}parseOrderBy(e,r){return new sql_mapper_1.SqlConverter(e,X3StorageManager.getFolderName(e),this.factory).convertOrderBy(r)}parseCursor(e,r){return sql_mapper_1.SqlQuery.parseCursor(e,r)}getId(e,r){let t=true;const i=this.factory.keyProperties.reduce((e,i,o)=>{if(null==r[i.name])t=false;const n=String(r[i.name]);if(1===this.factory.keyProperties.length||0===o)return n;return`${e}|${n}`},"");if(!t)return String(e.allocateTransientId());if("#"===i[0])return`${X3StorageManager.hashtagPlaceholder}${i.slice(1)}}`;return i}isKeyPropertyTransient(e,r){const t=Number(r);if(Number.isFinite(t)&&t<0)return true;return false}isReverseReferenceProperty(e){const r=this.factory.properties.find(r=>r.name===e);if(!r||"reference"!==r.type)return false;const t=this.getReferenceJoin(e),i=Object.values(t).filter(e=>"string"==typeof e).includes(r.name);if(!r.columnName&&!i)return true;return false}isPropertyValueTransient(e,r,t){if(null==t)return false;const i=this.factory.findProperty(r,{includeSystemProperties:true}),o=sql_resolver_1.SqlResolver.getPropertyType(i);switch(o){case"string":case"float":case"double":case"integer":case"short":case"decimal":{const e=parseInt(String(t),10);return Number.isFinite(e)&&e<0}default:return t===sql_mapper_1.SqlConverter.typeDefaultValue(e,{property:i,type:o,isNullable:false})}}getTransientValue(e,r){const t=this.factory.properties.find(e=>e.name===r),i=t&&sql_resolver_1.SqlResolver.getPropertyType(t);switch(i){case"string":return String(e.allocateTransientId());case"float":case"double":case"integer":case"short":case"decimal":return e.allocateTransientId();default:return sql_mapper_1.SqlConverter.typeDefaultValue(e,{property:t,type:i,isNullable:false})}}getKeyValues(e,r,t){if((0,xtrem_core_1.isScalar)(r)){if(this.factory.keyProperties.length>1)throw new Error(`${this.factory.name} incomplete key passed for read.`);return{[this.factory.keyProperties[0].name]:r}}return this.factory.keyProperties.reduce((i,o)=>{if(i[o.name]=r[o.name],t?.allocateTransient&&!t.isOnlyForDefaultValues&&void 0===i[o.name])i[o.name]=this.getTransientValue(e,o.name);return i},{})}get defaultOrderBy(){return this.factory.keyProperties.reduce((e,r)=>(e[r.name]=1,e),{})}async getJoinValues(e,r,t,i){const o=this.factory.properties.find(e=>e.name===t),n=o.targetFactory.externalStorageManager;let s={};if("reference"===o?.type)s=this.getReferenceJoin(t);else if("collection"===o?.type)s=this.getCollectionJoin(t);else if("referenceArray"===o?.type)throw Error(`${this.factory.name}.${t}: referenceArray is not supported.`);else return{};const a={};return await(0,xtrem_core_1.asyncArray)(Object.keys(s)).forEach(async t=>{if("string"==typeof s[t])if(null!=r[s[t]])a[t]=r[s[t]];else if(n.isDenormalized)try{a[t]=await e.$.get(s[t])}catch(e){a[t]=null,a.denormalizedIndex=-9999}else a[t]=await e.$.get(s[t]);if("function"==typeof s[t])a[t]=await s[t].call(e)}),a}getInactiveProperties(e){return this.factory.properties.filter(e=>e.isStored&&"denormalizedIndex"!==e.name&&e.serviceOptions.length>0).filter(r=>!r.serviceOptions.every(r=>e.isServiceOptionActiveSync(r)))}static executeApiOperation(e,r,t,i,o){return api_helper_1.ApiHelper.executeOperation(e,"custom",r,t,i,o)}static getDateDefaultValue(e){if(e.$.isOnlyForDefaultValues)return null;return xtrem_core_1.DateValue.make(1e3,1,1)}}exports.X3StorageManager=X3StorageManager;
//# sourceMappingURL=x3-storage-manager.js.map