import { AnyRecord, AnyRecordWithId, AnyValue, AsyncReader, AsyncResponse, Context, DateValue, Dict, Extend, ExternalStorageManager, FilterTag, InternalPropertyJoin, Node, NodeExternalQueryOptions, NodeFactory, OrderBy, OrderByClause, Property, PropertyAndValue, ValidationContext } from '@sage/xtrem-core';
import { AccessMapping, ApiMethod, Denormalized, Joins, StorageWebServices, StringPropertyLocalization, X3StorageManagerOptions } from './storage-types';
export declare class X3StorageManager<T extends Node> implements ExternalStorageManager<T> {
    #private;
    readonly options: X3StorageManagerOptions<T>;
    static hashtagPlaceholder: string;
    /**
     * Setting this attribute to true skips the execution of the controls when a node is saved, as the X3 has all the control logic.
     */
    skipValidation: boolean;
    private logger;
    /**
     *
=     * @param options
     */
    constructor(options?: X3StorageManagerOptions<T>);
    get joins(): Joins<T>;
    get webServices(): StorageWebServices<T> | undefined;
    /**
     * This is a denormailized node
     */
    get isDenormalized(): boolean | undefined;
    /**
     * Denormalized node metadata
     */
    get denormalized(): Denormalized | undefined;
    /** Access mapping used in access rights manager to map custom queries and mutations to standard operations */
    get accessMapping(): AccessMapping | undefined;
    /** Composite reference property mapping */
    get compositeReferences(): Dict<Dict<string>> | undefined;
    /**
     * Properties of the node that are required to fallback on the type default when retrieving data
     * Example:
     * In a node that is referenced that has a legislation, we need retrieve the value for the legislation join exactly,
     * and if that record does not exist, fallback on the record where the legislation is ' '
     */
    get joinFallbackProperties(): (keyof T)[] | undefined;
    /**
     * Current folder
     * @param context
     * @returns
     */
    static getFolderName(context: Context): string;
    private static verifyCompositeTargetProperty;
    private static verifyCompositeProperties;
    /**
     * Verify the composite references of the factory
     * @param factory
     */
    private verifyCompositeReferences;
    /**
     * Verify the factory when it is constructed
     * @param factory
     */
    verifyFactory(): void;
    /**
     * Set the storage manager factory value
     * We verify the factory and throw if anything in the node definition is invalid.
     */
    set factory(value: NodeFactory);
    get factory(): NodeFactory;
    canCreate(canCreate: boolean): boolean;
    canUpdate(canUpdate: boolean): boolean;
    canDelete(canDelete: boolean): boolean;
    canDeleteMany(canDeleteMany: boolean): boolean;
    /**
     * The maxRepeat value of the denormalized node
     * @param context
     * @returns
     */
    getMaxRepeat(context: Context): number;
    /**
     * Reconstruct the compositeReference of the node to be mapped to a path
     * Example
     *  {
     *    foo: {
     *      bar: 'bar'
     *    }
     *  }
     * will resolve to
     * {
     *  bar: ['foo','bar']
     * }
     */
    get compositeReferencePaths(): Dict<string[]>;
    /**
     * Removes the keyProperties that were populated with transient values, X3 will expect an empty value for this
     * and generate its own value. Example: document numbers (sales order number SOHNUM)
     * We walk the payload remove the relevant transient values
     * @param factory
     * @param payload
     * @returns
     */
    static removeTransientKeyValues(factory: NodeFactory, payload: any): any;
    private getSystemReturningValue;
    insert(node: Extend<T>, cx: ValidationContext): Promise<AnyRecordWithId>;
    update(node: Extend<T>, cx: ValidationContext): Promise<AnyRecord[]>;
    delete(node: Extend<T>, cx: ValidationContext): Promise<number>;
    getAllowedAccessCodes(context: Context, tag: FilterTag, allowedAccessCodes: string[] | null): Promise<string[] | null>;
    /**
     * Return an object that is the same as an empty result of a denormalized node
     * @param context
     * @param otherPropNames
     * @returns
     */
    private getEmptyDenormalizedResult;
    /**
     * Convert scalar values, complex objects are converted to a simple string value
     * @param val
     * @returns
     */
    static convertScalarValue(val: AnyValue): AnyValue;
    /**
     * compare a record and a result to see if it is an empty result
     * @param context
     * @param otherPropNames
     * @param record
     * @returns
     */
    private isDenormalizedResultEmpty;
    /**
     * If required slice the result of a denormalized query to the configured sizing
     * @param mapped
     * @param otherPropNames
     * @returns
     */
    private getSizedDenormalizedResult;
    /**
     * Map the response of the sql query to the parent table to get a denormalized result of many records from the single record
     * @param response
     * @param sqlQuery
     * @param outputColumns
     */
    private mapDenormalizedResponse;
    /**
     * get the key join filter from the list of filters passed to the query
     * for a denormalized query one of the filter must be a key filter
     * @param options
     */
    private getDenormalizedFilterJoin;
    getDenormalizedPropertyColumnSuffix(propertyName: string): number | undefined;
    query(context: Context, options: NodeExternalQueryOptions<T>): AsyncReader<T>;
    mapRecordIn(record: AnyRecord): AnyRecord;
    mapAggregateRecordIn(record: AnyRecord): AnyRecord;
    /**
     * Does the property belong to a composite reference
     * @param propertyName
     * @returns
     */
    isCompositeProperty(propertyName: string): boolean;
    /**
     * Walk to the factory that is at the end of a composite path
     * Example:
     * stockSite.legalCompany.legislation
     * Will return the factoy of the legalCompany(Company)
     * stockSite.legalCompany
     * Will return the factoy of the stockSite(Site)
     * @param path
     * @param currentIndex
     * @param currentFactory
     * @returns
     */
    private walkToForeignCompositeFactory;
    /**
     * Compute the join of a composite reference
     * @param propertyName
     * @returns
     */
    private getCompositeReferenceJoin;
    /**
     * Get the join of a composite reference
     * @param propertyName
     * @returns
     */
    private getCompositeCollectionJoin;
    /**
     * Get the join defined or computed for a reference property
     * @param propertyName
     * @returns
     */
    getReferenceJoin(propertyName: string): InternalPropertyJoin<T>;
    getLocalization(propertyName: string): StringPropertyLocalization<T> | undefined;
    /**
     * Get the join defined or computed for a collection property
     * @param propertyName
     * @returns
     */
    getCollectionJoin(propertyName: string): InternalPropertyJoin<T>;
    parseOrderBy(context: Context, orderBy: OrderBy<Node> | undefined): OrderByClause[];
    parseCursor(orderByClauses: OrderByClause[], value: string): PropertyAndValue[];
    /**
     * Gets the formatted key values a string concatenated by `|`
     * This will be used for the _id value
     *
     * @param context
     * @param values
     * @returns
     */
    getId(context: Context, values: Dict<any>): string;
    /**
     * Is the key property value allocated a transient value.
     * @param _propertyName
     * @param value
     * @returns
     */
    isKeyPropertyTransient(_propertyName: string, value: any): boolean;
    isReverseReferenceProperty(propertyName: string): boolean;
    isPropertyValueTransient(context: Context, propertyName: string, value: AnyValue): boolean;
    /**
     * Get the transient value for the specific type of the property passed
     * @param context
     * @param propertyName
     * @returns
     */
    private getTransientValue;
    /**
     * Get the values of the key properties
     * @param context
     * @param values
     * @param options
     * @returns
     */
    getKeyValues(context: Context, values: any, options?: {
        allocateTransient: boolean;
        isOnlyForDefaultValues?: boolean;
    }): Dict<any>;
    /**
     * The default order by consists of the key properties
     */
    get defaultOrderBy(): OrderBy<Node>;
    /**
     * Get the join values for the reference or collection passed
     * @param node
     * @param data
     * @param propertyName
     * @returns
     */
    getJoinValues(node: Extend<T>, data: any, propertyName: string, _index: number): Promise<Dict<any>>;
    /**
     * Get all the properties inactivated by service options (activity codes)
     * @param context
     * @returns
     */
    getInactiveProperties(context: Context): Property[];
    /**
     * Wrapper to execute node API mutation.
     * @param context
     * @param type
     * @param nodeName
     * @param operationName
     * @param inputData
     * @returns
     */
    static executeApiOperation<ReturnT = AnyRecord>(context: Context, method: ApiMethod, nodeName: string, operationName: string, inputData: Dict<AsyncResponse<AnyValue>> | Node): Promise<ReturnT>;
    static getDateDefaultValue(node: Node): DateValue | null;
}
//# sourceMappingURL=x3-storage-manager.d.ts.map