import { AsyncResponse, Context, Dict, Extend, InternalPropertyJoin, Node, StandardOperation } from '@sage/xtrem-core';
export interface WebService {
    name: string;
    type: 'subProg' | 'object' | 'import';
    outputNames?: string[];
}
export type WebServiceType<This extends Node> = ((this: Extend<This>) => AsyncResponse<WebService>) | WebService;
export interface StorageWebServices<This extends Node> {
    create?: WebServiceType<This>;
    update?: WebServiceType<This>;
    delete?: WebServiceType<This>;
}
export type ApiMethod = 'CRUD' | 'IMPORT' | 'CLASS' | 'SCRIPT';
export type ApiType = 'custom' | 'create' | 'update' | 'delete';
export interface Denormalized {
    maxRepeat: ((context: Context) => number) | number;
    minRepeat?: 'zero' | 'one' | 'maximum';
}
export interface StringPropertyLocalization<T extends Node = Node> {
    tableName: (keyof T | ((this: Extend<T>) => AsyncResponse<string>)) | string;
    columnName: (keyof T | ((this: Extend<T>) => AsyncResponse<string>)) | string;
    key1: (keyof T | ((this: Extend<T>) => AsyncResponse<any>))[] | null;
    key2?: (keyof T | ((this: Extend<T>) => AsyncResponse<any>))[] | null;
    concatenator?: string;
}
export interface Joins<T extends Node> {
    referenceJoins?: Dict<InternalPropertyJoin<T>>;
    collectionJoins?: Dict<InternalPropertyJoin<T>>;
    localizedStrings?: Dict<StringPropertyLocalization<T>>;
}
/**
 * Access mapping used in access rights manager to map custom queries and mutations to standard operations
 */
export type AccessMapping = Dict<StandardOperation | string | ((context: Context) => StandardOperation | string)>;
/**
 * Storage manager options
 */
export interface X3StorageManagerOptions<T extends Node> {
    isDenormalized?: boolean;
    denormalized?: Denormalized;
    /** Access mapping used in access rights manager to map custom queries and mutations to standard operations */
    accessMapping?: AccessMapping;
    allowedAccessCodes?: (context: Context) => Promise<string[] | null>;
    allowedSiteCodes?: (context: Context) => Promise<string[] | null>;
    compositeReferences?: Dict<Dict<string>>;
    joinFallbackProperties?: (keyof T)[];
    webServices?: StorageWebServices<T>;
    joins?: Joins<T>;
    canCreate?: boolean;
    canUpdate?: boolean;
    canDelete?: boolean;
    denormalizedPropertyColumnSuffix?: Dict<number>;
}
/**
 * Storage manager extension options
 */
export interface X3StorageManagerExtensionOptions<T extends Node> {
    /** Access mapping used in access rights manager to map custom queries and mutations to standard operations */
    accessMapping?: AccessMapping;
    compositeReferences?: Dict<Dict<string>>;
    joins?: Joins<T>;
    canCreate?: boolean;
    canUpdate?: boolean;
    canDelete?: boolean;
}
//# sourceMappingURL=storage-types.d.ts.map