/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlValueConverter=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_decimal_1=require("@sage/xtrem-decimal"),xtrem_shared_1=require("@sage/xtrem-shared"),xtrem_ts_to_sql_1=require("@sage/xtrem-ts-to-sql"),sql_converter_1=require("./sql-converter"),sql_resolver_1=require("./sql-resolver");function convertNumberForAssignment(e,r,t){switch(sql_resolver_1.SqlResolver.getPropertyType(r)){case"integer":case"short":{const e=+t;if(Number.isInteger(e))return e;throw new Error(`${r.name}: Cannot assign ${t&&t.toString()} to a property of type ${r.type}. Did you forget a Math.floor?`)}case"double":case"float":{if("number"==typeof t)return t;if(xtrem_decimal_1.Decimal.isDecimal(t))return t.toNumber();const e=+t;if(Number.isFinite(e))return e;throw new Error(`${r.name}: Cannot assign ${t&&t.toString()} to a property of type ${r.type}.`)}case"decimal":{if("number"==typeof t)return xtrem_decimal_1.Decimal.make(t);if(xtrem_decimal_1.Decimal.isDecimal(t))return t;const e=+t;if(Number.isFinite(e))return xtrem_decimal_1.Decimal.make(String(t));throw new Error(`${r.name}: Cannot assign ${t&&t.toString()} to a property of type ${r.type}.`)}default:return t}}function booleanToSql(e){return e?"1":"0"}function decimalToSql(e,r){if(null==r)return 0;return xtrem_decimal_1.Decimal.isDecimal(r)?r.toNumber():r}function numberToSql(e,r,t){if(null==e)return 0;return convertNumberForAssignment(r,t,e)}function binaryStreamToSql(e,r,t){if(r&&r.value)return r.value;return t?null:"''"}function textStreamToSql(e,r,t){if(r&&r.value)return r.value;return t?null:"''"}function toSql(e,r,t,l,n){const o=!!t.isNullable||!!n,a=sql_resolver_1.SqlResolver.getPropertyType(t),u=null==l?sql_converter_1.SqlConverter.typeDefaultValue(e,{property:t,type:a,isNullable:false}):l;switch(a){case"boolean":return booleanToSql(u);case"enum":if(!Number.isFinite(Number(u))){return t.dataType.numberValue(u)}return u;case"string":return(0,xtrem_ts_to_sql_1.quote)(""===u?" ":u);case"decimal":return decimalToSql(e,u);case"short":case"float":case"double":case"integer":return numberToSql(u,r,t);case"date":{const{dialect:r}=sql_resolver_1.SqlResolver.getX3Pool(e);return sql_resolver_1.SqlResolver.toDate((0,xtrem_ts_to_sql_1.quote)(u.toString()),false,r)}case"dateRange":case"datetimeRange":case"time":case"datetime":return(0,xtrem_ts_to_sql_1.quote)(null==u?"":u.toString());case"uuid":return u&&u.data?u.data:u;case"binaryStream":return binaryStreamToSql(e,u,o);case"textStream":return textStreamToSql(e,u,o);default:return u}}function fromSqlToBoolean(e,r){if(null==e&&r.isNullable)return null;return 1===Number(e)}function fromSqlToInteger(e,r){if(null==e)return r;return Number(e)}function fromSqlToEnum(e,r){const t=r.dataType;return 0===Number(e)?r.isNullable?null:void 0:t.stringValue(Number(e))}function fromSqlToString(e){if(null==e||" "===e||""===e)return"";return e}function fromSqlToDecimal(e,r){if(null==e)return r;return xtrem_decimal_1.Decimal.make(e)}function fromSqlToDate(e,r){if(null==e)return null;if("string"==typeof e){const t=e.split("-").map(e=>Number(e));if(0===t[0])return null;const l=xtrem_date_time_1.DateValue.make(t[0],t[1]??1,t[2]??1);if(r.toString()===l.toString())return null;return l}const t=new Date(e),l=xtrem_date_time_1.DateValue.fromJsDate(t,"UTC");if(r.toString()===l.toString())return null;return l}function fromSqlToDateRange(e,r){return e&&xtrem_date_time_1.DateRange.parse(e)||r}function fromSqlToDatetimeRange(e,r){return e&&xtrem_date_time_1.DatetimeRange.parse(e)||r}function fromSqlToTime(e,r,t){return e&&"string"==typeof e?xtrem_date_time_1.Time.parse(e,t):r}function fromSqlToDatetime(e,r){if(null==e||e instanceof xtrem_date_time_1.Datetime&&r.value===e.value)return null;const t=new Date(e),l=new Date(Date.UTC(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds()));return null===l?null:xtrem_date_time_1.Datetime.fromJsDate(l)}function fromSqlToUuid(e){const r="0".repeat(32);if(null==e)return null;const t=e.toString("hex");return t===r?null:t}function fromSqlToBinaryStream(e,r,t){if(null==r)return t;if(r&&r.length>0)return xtrem_core_1.BinaryStream.fromBuffer(r);return t}function fromSqlToTextStream(e,r,t){if(null==r)return t;if(r&&r.length>0)return xtrem_core_1.TextStream.fromString(r);return t}function fromSql(e,r,t){const{property:l}=r;if(!l)throw new xtrem_shared_1.LogicError("missing property");const n=sql_resolver_1.SqlResolver.getType(r);switch(n){case"boolean":return fromSqlToBoolean(t,l);case"enum":return fromSqlToEnum(t,l);case"integer":case"short":return fromSqlToInteger(t,sql_converter_1.SqlConverter.typeDefaultValue(e,{property:l,type:n,isNullable:l.isNullable}));case"string":return fromSqlToString(t);case"decimal":return fromSqlToDecimal(t,sql_converter_1.SqlConverter.typeDefaultValue(e,{property:l,type:n,isNullable:l.isNullable}));case"date":return fromSqlToDate(t,sql_converter_1.SqlConverter.typeDefaultValue(e,{property:l,type:n,isNullable:false}));case"dateRange":return fromSqlToDateRange(t,sql_converter_1.SqlConverter.typeDefaultValue(e,{property:l,type:n,isNullable:false}));case"datetimeRange":return fromSqlToDatetimeRange(t,sql_converter_1.SqlConverter.typeDefaultValue(e,{property:l,type:n,isNullable:l.isNullable}));case"time":return fromSqlToTime(t,sql_converter_1.SqlConverter.typeDefaultValue(e,{property:l,type:n,isNullable:false}),e.currentLocale);case"datetime":return fromSqlToDatetime(t,sql_converter_1.SqlConverter.typeDefaultValue(e,{property:l,type:n,isNullable:false}));case"uuid":return fromSqlToUuid(t);case"binaryStream":return fromSqlToBinaryStream(e,t,sql_converter_1.SqlConverter.typeDefaultValue(e,{property:l,type:n,isNullable:false}));case"textStream":return fromSqlToTextStream(e,t,sql_converter_1.SqlConverter.typeDefaultValue(e,{property:l,type:n,isNullable:false}));default:return null==t?null:t}}class SqlValueConverter{static{this.fromSql=fromSql}static{this.toSql=toSql}}exports.SqlValueConverter=SqlValueConverter;
//# sourceMappingURL=sql-value-converter.js.map