import { AnyValue, Context, NodeFactory, Property, TypeName } from '@sage/xtrem-core';
import { DateValue } from '@sage/xtrem-date-time';
import { Dict } from '@sage/xtrem-shared';
import { BasicConversionResult, ConversionResultType, Converter } from '@sage/xtrem-ts-to-sql';
import { Dialect, Pool } from '@sage/xtrem-x3-sql';
import { ConversionResult, SqlConverter } from './sql-converter';
export declare const systemProperties: Dict<any>;
export declare const systemColumns: any[];
export declare class SqlResolver {
    static getX3Pool<T extends AnyValue>(context: Context): Pool<T>;
    static getNullDate(poolDialect: Dialect): DateValue;
    static getDummyConverter(poolDialect: Dialect): Converter;
    static toChar(result: BasicConversionResult, poolDialect: Dialect): string;
    static toDate(sql: string, dateTime: boolean, poolDialect: Dialect): string;
    static limitClause(limit: number, poolDialect: Dialect): string;
    static fetchOnlyClause(limit: number, poolDialect: Dialect): string;
    private static getNumericAggregateValueType;
    private static getAggregateValueType;
    private static checkDateOrDatetimeType;
    private static castIfBoolean;
    static nullValue(context: Context, type: ConversionResultType): string;
    /**
     * Get a dummy value for the specified type
     * @param context
     * @param type
     * @returns
     */
    static placeholderValue(context: Context, type: TypeName | undefined): string;
    /**
     * Get the column/scalar type of a property
     * @param result
     * @returns
     */
    static getType(result: ConversionResult): ConversionResultType;
    /**
     * Get the column/scalar type of a property
     * @param property
     * @returns
     */
    static getPropertyType(property: Property): ConversionResultType;
    static orderByDirections(context?: any): {
        asc: string;
        desc: string;
    };
    static convertToConversionPair(context: Context, sql: string, type: ConversionResultType, conversionPair: string[]): string;
    private static getDayAggregateSql;
    private static getMonthAggregateSql;
    private static getYearAggregateSql;
    static getDateAggregateSql(sql: string, name: 'year' | 'month' | 'day', poolDialect: Dialect): string;
    private static aggregateSql;
    static resolveAggregate(context: Context, result: ConversionResult, name: string): ConversionResult;
    static makeName30(name: string): string;
    static makeColumnAlias(sql: string, dialect: Dialect, alias?: string): string;
    static stripColumnAlias(alias: string): string;
    static resolveJson(context: Context, result: ConversionResult, name: string): ConversionResult;
    static resolveRange(context: Context, result: ConversionResult, name: string, type: ConversionResultType): ConversionResult;
    static resolveDate(sqlConverter: SqlConverter, result: ConversionResult, name: string): ConversionResult;
    /**
     * Is the property a system property
     * @param propertyName
     * @returns
     */
    static isSystemOrTechnicalColumn(propertyName: string): boolean;
    static findProperty(factory: NodeFactory, propertyName: string): Property;
    static resolve(sqlConverter: SqlConverter, context: Context, parent: ConversionResult, name: string): ConversionResult;
    private static propertyColumnSql;
    private static constructSql;
    private static getFieldName;
}
//# sourceMappingURL=sql-resolver.d.ts.map