/* Copyright (c) 2020-2025 The Sage Group plc or its licensors. Sage, Sage logos, and Sage product and service names mentioned herein are the trademarks of Sage Global Services Limited or its licensors. All other trademarks are the property of their respective owners. */
"use strict";Object.defineProperty(exports,"__esModule",{value:true}),exports.SqlQuery=void 0;const xtrem_core_1=require("@sage/xtrem-core"),xtrem_date_time_1=require("@sage/xtrem-date-time"),xtrem_shared_1=require("@sage/xtrem-shared"),sql_converter_1=require("./sql-converter"),sql_resolver_1=require("./sql-resolver"),sql_value_converter_1=require("./sql-value-converter");class SqlQuery{static{this.internalStatistics={queryCount:0}}constructor(e,r,t,s){if(this.context=e,this.factory=r,this.options=t,this.schemaName=s,this._inactiveProperties=[],t.locale)this.currentLocale=t.locale;const{joinFallbackProperties:o}=this.externalStorageManager;if(t.singleResultRequest&&o&&o.length>0)this.options=this.fillFallbackPropertyOptions(t);this.sqlConverter=new sql_converter_1.SqlConverter(this.context,this.schemaName,this.factory)}fillFallbackPropertyOptions(e){const r={...e},{joinFallbackProperties:t}=this.externalStorageManager;return r.first=1,t?.forEach(e=>{if(!r.orderBy)r.orderBy={};r.orderBy[e]=1,r.filters.forEach((t,s)=>{if(t[e]&&"object"!=typeof t[e])if(t[e]={_in:[t[e],null]},r.filters[s]=t,r.orderBy)r.orderBy[e]=-1})}),r}get externalStorageManager(){return this.factory.externalStorageManager}get outputColumns(){return this._selectedColumns}get groupValueColumns(){return{groups:this.groupColumns,values:this.valueColumns}}getGroupsOrderBy(e){return this.sqlConverter.convertAggregateGroups(e).map((r,t)=>({...r,path:e[t].path,direction:1,property:r.property,group:e[t]}))}orderBySql(e,r,t){const{orderByClauses:s}=this;if(!s)return"";if(0===s.length)return"";return`ORDER BY ${s.map(s=>{const o=e?1===s.direction?-1:1:s.direction,a=sql_resolver_1.SqlResolver.orderByDirections(this.context);return`${SqlQuery.getAggregationOrderByAlias(s,r,t)} ${-1===o?a.desc:a.asc}`}).join(", ")}`}static getAggregationOrderByAlias(e,r,t){const s=[...t||[],...r||[]].find(r=>{const t=sql_resolver_1.SqlResolver.stripColumnAlias(r.columnAlias??"");return t?.substring(0,t.lastIndexOf(`_${r.aggregationOperator||""}`.toUpperCase()))===`${e.columnAlias}`});return s?.columnAlias?s?.columnAlias:e.columnAlias}cursorWhere(e){if(!this.options[e])return"";if(!this.orderByClauses)throw new Error(`${this.factory.tableName}: missing 'orderBy' option`);const{orderByClauses:r}=this,t=r.map((t,s)=>{const o=[];for(let t=0;t<s;t+=1){const s=r[t],a=this.sqlConverter.addValuePathParameter(`${e}.${t}.value`,sql_resolver_1.SqlResolver.getPropertyType(s.property),s.property);o.push(`${s.sql} = ${a}`)}const a="before"===e?t.direction>0?"<":">":t.direction>0?">":"<";{const{property:r}=t;let l="";const i=this.sqlConverter.addValuePathParameter(`${e}.${s}.value`,sql_resolver_1.SqlResolver.getPropertyType(r),r);if(l=`${t.sql} ${a} ${i}`,"<"===a&&r.isNullable){const e=sql_resolver_1.SqlResolver.getPropertyType(t.property);l=`(${l} OR ${sql_resolver_1.SqlResolver.convertToConversionPair(this.context,t.sql,e,["1","0"])}=1)`}o.push(l)}return`(${sql_converter_1.SqlConverter.and(o)})`});return sql_converter_1.SqlConverter.or(t)}whereClause(){const e=this.sqlConverter.convertFilters(this.options.filters);if(!this.externalStorageManager.isDenormalized)e.push(this.cursorWhere("after")),e.push(this.cursorWhere("before"));return sql_converter_1.SqlConverter.and(e)}getGroupByClauses(e){const r=this.aggregateResult;if(r?.groups?.length){return{groupByClause:`GROUP BY ${r?.groups.map(e=>e.sql).join(", ")}`,groupOrderByClause:` ORDER BY ${r?.groups.map(r=>`${r.columnAlias} ${e?"DESC":"ASC"}`).join(", ")}`}}if(r?.values?.length)return{};return{groupOrderByClause:this.orderBySql(e)}}static transformConverted(e){e.forEach(r=>{if(r.denormalizeChildSlots&&r.denormalizeChildSlots.length>0)r.denormalizeChildSlots.forEach(r=>{e.push(r)})})}getOutputPaths(e,r,t){const s=true===e?{_id:true}:e;return Object.entries(s).forEach(([e,s])=>{const o=[...r,e];if(true===s)t.push(o);else if(s&&"object"==typeof s){if(!s._id)t.push(o);this.getOutputPaths(s,o,t)}}),t}getTableColumnPaths(){const e=Object.values(sql_resolver_1.systemProperties).map(e=>sql_resolver_1.SqlResolver.findProperty(this.factory,e.name));return[...this.factory.properties.filter(e=>!Object.values(sql_resolver_1.systemProperties).find(r=>r.name===e.name)),...e].filter(e=>e.isStored&&"collection"!==e.type&&"denormalizedIndex"!==e.name&&!this._inactiveProperties.includes(e)).map(e=>[e.name])}getOutputColumns(){const e=this.options.selector?this.getOutputPaths(this.options.selector,[],[]):this.getTableColumnPaths(),r=this.sqlConverter.convertOutputPaths(e);return SqlQuery.transformConverted(r),r.filter(e=>!!e.sql)}columnValue(e,r){if(this._inactiveProperties.some(r=>r.name===e.property?.name))return null;return sql_value_converter_1.SqlValueConverter.fromSql(this.context,e,r)}async mapRecordIn(e,r){const t={};if(!e)throw new xtrem_shared_1.LogicError("missing outputColumns");if(true===this.options.selector){const t=e[0];if(t.columnAlias&&1===t.payloadPath?.length&&"_id"===t.payloadPath[0]){if("_id"!==t.property?.name)throw new xtrem_shared_1.LogicError(`unexpected property: ${t.property?.name}`);const e=sql_resolver_1.SqlResolver.stripColumnAlias(t.columnAlias??"");return r[e]}}return await(0,xtrem_core_1.asyncArray)(e).forEach(e=>{if(e.payloadPath){if(!e.columnAlias)throw new xtrem_shared_1.LogicError("no column alias");const s=sql_resolver_1.SqlResolver.stripColumnAlias(e.columnAlias??""),o=this.columnValue(e,r[s]);let a=t;const l=e.payloadPath[e.payloadPath.length-1];for(let r=0;r<e.payloadPath.length-1&&null!=a;r+=1){const t=e.payloadPath[r];if("object"!=typeof a[t])a[t]={};if(null===o&&"_id"===l&&r===e.payloadPath.length-2)a[t]=null;a=a[t]}if(a)a[l]=o}}),this._inactiveProperties.forEach(e=>{t[e.name]=null}),t}async mapAggregateRecordIn(e,r,t){const assign=(e,r,t,s)=>{const o=r.shift();if(r.length>(s?1:0)){if(!e[o])e[o]={};assign(e[o],r,t,s)}else e[o]=t},s={};return await(0,xtrem_core_1.asyncArray)(e).forEach(e=>{s.group=s.group||{};const r=e.aggregationOperator??"value",o=e.payloadPath&&e.payloadPath.length>0?[...e.payloadPath,r]:[...e.path.split(".").slice(1),r],a=sql_resolver_1.SqlResolver.stripColumnAlias(e.columnAlias??"");assign(s.group,o,this.columnValue(e,t[a]),e.aggregationOperator)}),await(0,xtrem_core_1.asyncArray)(r).forEach(e=>{s.values=s.values||{};const r=e.aggregationOperator??"value",o=e.payloadPath&&e.payloadPath.length>0?[...e.payloadPath,r]:[...e.path.split(".").slice(1),r],a=sql_resolver_1.SqlResolver.stripColumnAlias(e.columnAlias??"");assign(s.values,o,this.columnValue(e,t[a]))}),s}isAggregateQuery(){return!!this.aggregateResult?.groups?.length||!!this.aggregateResult?.values?.length}isSingleResult(){return!!(this.aggregateResult&&this.aggregateResult.groups&&0===this.aggregateResult.groups.length)}get defaultOrderBy(){return this.factory.keyProperties.filter(e=>this.externalStorageManager.isDenormalized&&"denormalizedIndex"!==e.name).reduce((e,r)=>(e[r.name]=1,e),{})}static lockClause(e){return""}static safeParseInt(e,r){const t=Number(r);if(!Number.isInteger(t))throw new Error(`column ${e.name}: invalid integer value ${r}`);return t}static safeParseFloat(e,r){const t=Number(r);if(!Number.isFinite(t))throw new Error(`column ${e.name}: invalid number value ${r}`);return t}static parsePropertyValue(e,r){const t=sql_resolver_1.SqlResolver.getPropertyType(e);if("string"===t)return r;if(!r)return null;switch(t){case"float":case"double":case"decimal":return this.safeParseFloat(e,r);case"integer":case"short":return this.safeParseInt(e,r);case"boolean":return"true"===String(r);case"enum":if(!Number.isFinite(Number(r))){return e.dataType.numberValue(r)}return this.safeParseInt(e,r);case"date":return xtrem_date_time_1.DateValue.parse(r);case"dateRange":return xtrem_date_time_1.DateRange.parse(r);case"datetimeRange":return xtrem_date_time_1.DatetimeRange.parse(r);case"time":return xtrem_date_time_1.Time.parse(r);case"datetime":return xtrem_date_time_1.Datetime.parse(r);case"uuid":return xtrem_core_1.Uuid.fromString(r);default:throw new Error(`column ${e.name}: unsupported type ${t}`)}}static cursorChecksum(e){const r=e.replace(/'/g,'"');return`#${((0,xtrem_core_1.fastHash)(r.replace(/'/g,'"'))%100).toString().padStart(2,"0")}`}static removeCursorChecksum(e){if(!e)return e;const r=e.substring(0,e.length-3),t=this.cursorChecksum(r);if(!e.endsWith(t))throw new Error(`${e}: invalid cursor value (checksum verification failed)`);return r}static parseCursorValues(e,r){if(0===e.length)throw new Error("Cannot parse cursor: missing orderBy");if(r.length>e.length)throw new Error("Cannot parse cursor: too many values");if(r.length<e.length)throw new Error("Cannot parse cursor: too few values");return e.map((e,t)=>({property:e.property,value:this.parsePropertyValue(e.property,r[t])}))}static parseCursor(e,r){const t=this.removeCursorChecksum(r);return this.parseCursorValues(e,(0,xtrem_core_1.friendlyJsonParse)(t))}isMissingColumnInOrderByClause(e){return!this._selectedColumns?.find(r=>r.property===e.property||this.isAggregateQuery()&&sql_resolver_1.SqlResolver.stripColumnAlias(r.columnAlias??"")===sql_resolver_1.SqlResolver.stripColumnAlias(`${e.columnAlias}_${(r?.aggregationOperator||"").toUpperCase()}`))}getSqlQuery(){SqlQuery.internalStatistics.queryCount+=1;const{options:e}=this;this.aggregateResult=this.sqlConverter.convertAggregate(e.count&&this.options.aggregate?.values?{groups:this.options.aggregate.groups,values:[]}:this.options.aggregate);const r=this.options.aggregate&&!this.options.orderBy?this.getGroupsOrderBy(this.options.aggregate.groups):this.sqlConverter.convertOrderBy(this.options.orderBy||this.defaultOrderBy);if(this.orderByClauses=this.options.count?[]:r,this.after=this.options.after&&!this.externalStorageManager.isDenormalized?SqlQuery.parseCursor(this.orderByClauses,this.options.after):void 0,this.before=this.options.before&&!this.externalStorageManager.isDenormalized?SqlQuery.parseCursor(this.orderByClauses,this.options.before):void 0,e.forUpdate&&!this.context.isWritable)throw new Error(`${this.factory.name}: cannot query for update: context is readonly`);const t=e.forUpdate?SqlQuery.lockClause("t0"):"",s=!!e.last&&!e.count,o=sql_resolver_1.SqlResolver.getX3Pool(this.context),a=s?e.last?sql_resolver_1.SqlResolver.limitClause(e.last,o.dialect):"":"",l=!s?e.first?sql_resolver_1.SqlResolver.limitClause(e.first,o.dialect):"":a,i=s?e.last?sql_resolver_1.SqlResolver.fetchOnlyClause(e.last,o.dialect):"":"",n=!s?e.first?sql_resolver_1.SqlResolver.fetchOnlyClause(e.first,o.dialect):"":i;if(e.count)this._selectedColumns=[];else if(this.isAggregateQuery()){const{groups:e,values:r}=this.aggregateResult;this.groupColumns=e,this.valueColumns=r,this._selectedColumns=[...r||[],...e||[]]}else{this._inactiveProperties=this.externalStorageManager.getInactiveProperties(this.context);const e=this.getOutputColumns();this._selectedColumns=e}const{groupByClause:u,groupOrderByClause:c}=this.getGroupByClauses(s),h=[];if(this.orderByClauses.filter(e=>this.isMissingColumnInOrderByClause(e)).forEach(e=>{h.push(e.path.join(".")),this._selectedColumns.push({alias:"",...e,path:e.path.join("."),property:e.property,factory:this.factory})}),this.isAggregateQuery()&&h.length>0)throw new Error(`${h.join(",")} not contained in either an aggregate function or the GROUP BY clause`);const p=`WHERE ${this.whereClause()}`,g=this._selectedColumns.map(e=>`${e.sql} AS ${e.columnAlias}`).join(", "),m=this.sqlConverter.getTableAliases().replace(/\sAS\s/g," ").trim();let d=[e.count?`SELECT COUNT(*) AS ${sql_resolver_1.SqlResolver.makeColumnAlias("NROWS",this.sqlConverter.dialect)}`:`SELECT ${l} ${g}`,`FROM ${m}`,p,u].join(" ");const f=this.sqlConverter.getParameterValues(this.context,{filters:e.filters,before:this.before,after:this.after});if(e.count)return{sql:d,promisedParameterValues:f};if(!this.isSingleResult())d+=` ${this.orderBySql(s,this.groupColumns,this.valueColumns)||c||""}`;return d+=` ${n} ${t}`,{sql:d,promisedParameterValues:f}}}exports.SqlQuery=SqlQuery;
//# sourceMappingURL=sql-query.js.map